/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.PrintStream;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.util.StringUtils;

public class RecorderEntry
implements BuildLogger {
    private String filename = null;
    private boolean record = true;
    private int loglevel = 2;
    private PrintStream out = null;
    private long targetStartTime = 0L;
    private boolean emacsMode = false;

    protected RecorderEntry(String name) {
        this.filename = name;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setRecordState(Boolean state) {
        if (state != null) {
            this.record = state;
        }
    }

    public void buildStarted(BuildEvent event) {
        this.log("> BUILD STARTED", 4);
    }

    public void buildFinished(BuildEvent event) {
        this.log("< BUILD FINISHED", 4);
        Throwable error = event.getException();
        if (error == null) {
            this.out.println(StringUtils.LINE_SEP + "BUILD SUCCESSFUL");
        } else {
            this.out.println(StringUtils.LINE_SEP + "BUILD FAILED" + StringUtils.LINE_SEP);
            error.printStackTrace(this.out);
        }
        this.out.flush();
        this.out.close();
    }

    public void targetStarted(BuildEvent event) {
        this.log(">> TARGET STARTED -- " + event.getTarget(), 4);
        this.log(StringUtils.LINE_SEP + event.getTarget().getName() + ":", 2);
        this.targetStartTime = System.currentTimeMillis();
    }

    public void targetFinished(BuildEvent event) {
        this.log("<< TARGET FINISHED -- " + event.getTarget(), 4);
        String time = RecorderEntry.formatTime(System.currentTimeMillis() - this.targetStartTime);
        this.log(event.getTarget() + ":  duration " + time, 3);
        this.out.flush();
    }

    public void taskStarted(BuildEvent event) {
        this.log(">>> TASK STARTED -- " + event.getTask(), 4);
    }

    public void taskFinished(BuildEvent event) {
        this.log("<<< TASK FINISHED -- " + event.getTask(), 4);
        this.out.flush();
    }

    public void messageLogged(BuildEvent event) {
        this.log("--- MESSAGE LOGGED", 4);
        StringBuffer buf = new StringBuffer();
        if (event.getTask() != null) {
            String name = event.getTask().getTaskName();
            if (!this.emacsMode) {
                String label = "[" + name + "] ";
                int size = 12 - label.length();
                for (int i = 0; i < size; ++i) {
                    buf.append(" ");
                }
                buf.append(label);
            }
        }
        buf.append(event.getMessage());
        this.log(buf.toString(), event.getPriority());
    }

    private void log(String mesg, int level) {
        if (this.record && level <= this.loglevel) {
            this.out.println(mesg);
        }
    }

    public void setMessageOutputLevel(int level) {
        if (level >= 0 && level <= 4) {
            this.loglevel = level;
        }
    }

    public void setOutputPrintStream(PrintStream output) {
        this.out = output;
    }

    public void setEmacsMode(boolean emacsMode) {
        this.emacsMode = emacsMode;
    }

    public void setErrorPrintStream(PrintStream err) {
        this.out = err;
    }

    private static String formatTime(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        if (minutes > 0L) {
            return Long.toString(minutes) + " minute" + (minutes == 1L ? " " : "s ") + Long.toString(seconds % 60L) + " second" + (seconds % 60L == 1L ? "" : "s");
        }
        return Long.toString(seconds) + " second" + (seconds % 60L == 1L ? "" : "s");
    }
}

