/*
 * Decompiled with CFR 0.152.
 */
package free.jin;

import free.jin.Server;
import free.jin.User;
import free.util.Struct;
import free.util.Utilities;

public class ConnectionDetails
extends Struct {
    private ConnectionDetails() {
    }

    public static ConnectionDetails create(Server server, User user, String string, String string2, boolean bl, String string3, int[] nArray) {
        ConnectionDetails connectionDetails = new ConnectionDetails();
        connectionDetails.setProperty("server", server);
        connectionDetails.setProperty("user", user);
        connectionDetails.setStringProperty("username", string);
        connectionDetails.setStringProperty("password", string2);
        connectionDetails.setBooleanProperty("savePassword", bl);
        connectionDetails.setStringProperty("hostname", string3);
        connectionDetails.setProperty("ports", nArray == null ? null : nArray.clone());
        return connectionDetails;
    }

    public static ConnectionDetails createGuest(Server server, String string, String string2, int[] nArray) {
        ConnectionDetails connectionDetails = new ConnectionDetails();
        connectionDetails.setProperty("server", server);
        connectionDetails.setProperty("user", server.getGuest());
        connectionDetails.setStringProperty("username", string);
        connectionDetails.setStringProperty("hostname", string2);
        connectionDetails.setProperty("ports", nArray.clone());
        return connectionDetails;
    }

    public ConnectionDetails usePort(int n) {
        int[] nArray = this.getPorts();
        int n2 = Utilities.indexOf(nArray, n);
        if (n2 == -1) {
            throw new IllegalArgumentException("The specified port (" + n + ") is not in the list");
        }
        for (int i = n2; i > 0; --i) {
            nArray[i] = nArray[i - 1];
        }
        nArray[0] = n;
        if (this.isGuest()) {
            return ConnectionDetails.createGuest(this.getServer(), this.getUsername(), this.getHost(), nArray);
        }
        return ConnectionDetails.create(this.getServer(), this.getUser(), this.getUsername(), this.getPassword(), this.isSavePassword(), this.getHost(), nArray);
    }

    public Server getServer() {
        return (Server)this.getProperty("server");
    }

    public User getUser() {
        return (User)this.getProperty("user");
    }

    public boolean isGuest() {
        return this.getUser().isGuest();
    }

    public String getUsername() {
        return this.getStringProperty("username");
    }

    public String getPassword() {
        if (this.isGuest()) {
            return "";
        }
        return this.getStringProperty("password");
    }

    public boolean isSavePassword() {
        if (this.isGuest()) {
            throw new IllegalStateException();
        }
        return this.getBooleanProperty("savePassword");
    }

    public String getHost() {
        return this.getStringProperty("hostname");
    }

    public int[] getPorts() {
        return (int[])((int[])this.getProperty("ports")).clone();
    }
}

