/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.web;

import java.util.Iterator;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.apache.commons.collections.iterators.EnumerationIterator;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.PropertyConverter;

public class ServletContextConfiguration
extends AbstractConfiguration {
    protected ServletContext context;

    public ServletContextConfiguration(Servlet servlet) {
        this.context = servlet.getServletConfig().getServletContext();
    }

    public ServletContextConfiguration(ServletContext context) {
        this.context = context;
    }

    public Object getProperty(String key) {
        String value = this.context.getInitParameter(key);
        List list = PropertyConverter.split(value, AbstractConfiguration.getDelimiter());
        return list.size() > 1 ? list : value;
    }

    protected void addPropertyDirect(String key, Object obj) {
        throw new UnsupportedOperationException("Read only configuration");
    }

    public boolean isEmpty() {
        return !this.getKeys().hasNext();
    }

    public boolean containsKey(String key) {
        return this.getProperty(key) != null;
    }

    public void clearProperty(String key) {
        throw new UnsupportedOperationException("Read only configuration");
    }

    public Iterator getKeys() {
        return new EnumerationIterator(this.context.getInitParameterNames());
    }
}

