define("mod_forum/local/grades/local/grader/user_picker",["exports","core/templates","./user_picker/selectors","core/str"],(function(_exports,_templates,_selectors,_str){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * This module will tie together all of the different calls the gradable module will make.
   *
   * @module     mod_forum/local/grades/local/grader/user_picker
   * @copyright  2019 Mathew May <mathew.solutions>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_templates=_interopRequireDefault(_templates),_selectors=_interopRequireDefault(_selectors);class UserPicker{constructor(userList,showUserCallback,preChangeUserCallback){this.userList=userList,this.showUserCallback=showUserCallback,this.preChangeUserCallback=preChangeUserCallback,this.currentUserIndex=0,this.render=this.render.bind(this),this.setUserId=this.setUserId.bind(this)}setUserId(userId){const userIndex=this.userList.findIndex((user=>user.id===parseInt(userId)));if(-1===userIndex)throw Error("User with id ".concat(userId," not found"));this.currentUserIndex=userIndex}async render(){this.root=document.createElement("div");const{html:html,js:js}=await this.renderNavigator();_templates.default.replaceNodeContents(this.root,html,js),await this.showUser(this.currentUser),this.registerEventListeners()}renderNavigator(){return _templates.default.renderForPromise("".concat("mod_forum/local/grades/local/grader","/user_picker"),{})}renderUserChange(context){return _templates.default.renderForPromise("".concat("mod_forum/local/grades/local/grader","/user_picker/user"),context)}async showUser(user){const[{html:html,js:js}]=await Promise.all([this.renderUserChange(user),this.showUserCallback(user)]),userRegion=this.root.querySelector(_selectors.default.regions.userRegion);_templates.default.replaceNodeContents(userRegion,html,js);this.root.querySelector(_selectors.default.regions.currentUser).textContent=await(0,_str.getString)("nowgradinguser","mod_forum",user.fullname)}registerEventListeners(){this.root.addEventListener("click",(async e=>{const button=e.target.closest(_selectors.default.actions.changeUser);if(button){(await this.preChangeUserCallback(this.currentUser)).failed||(this.updateIndex(parseInt(button.dataset.direction)),await this.showUser(this.currentUser))}}))}updateIndex(direction){return this.currentUserIndex+=direction,this.currentUserIndex<0?this.currentUserIndex=this.userList.length-1:this.currentUserIndex>this.userList.length-1&&(this.currentUserIndex=0),this.currentUserIndex}get currentUser(){return{...this.userList[this.currentUserIndex],total:this.userList.length,displayIndex:this.currentUserIndex+1}}get rootNode(){return this.root}}return _exports.default=async function(users,showUserCallback,preChangeUserCallback){let{initialUserId:initialUserId=null}=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};const userPicker=new UserPicker(users,showUserCallback,preChangeUserCallback);return initialUserId&&userPicker.setUserId(initialUserId),await userPicker.render(),userPicker},_exports.default}));

//# sourceMappingURL=user_picker.min.js.map