/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JDialog;
import net.sourceforge.squirrel_sql.client.gui.IProgressCallBackFactory;
import net.sourceforge.squirrel_sql.client.gui.ProgressCallBackFactory;
import net.sourceforge.squirrel_sql.client.session.DefaultSQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ForeignKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.ProgressCallBack;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.DropTableDialog;

public class DropTablesCommand
extends AbstractRefactoringCommand {
    private final ILogger s_log = LoggerController.createLogger(DropTablesCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DropTablesCommand.class);
    protected DropTableDialog customDialog;
    private List<ITableInfo> orderedTables;
    ProgressCallBack getOrderedTablesCallBack;
    private IProgressCallBackFactory progressCallBackFactory = new ProgressCallBackFactory();
    private HashSet<String> matViewLookup;

    public DropTablesCommand(ISession session, IDatabaseObjectInfo[] tables) {
        super(session, tables);
    }

    @Override
    protected void onExecute() {
        this.showCustomDialog();
    }

    protected void showCustomDialog() {
        ITableInfo[] tableInfos = new ITableInfo[this._info.length];
        for (int i = 0; i < tableInfos.length; ++i) {
            tableInfos[i] = (ITableInfo)this._info[i];
        }
        this.customDialog = new DropTableDialog(tableInfos, SessionUtils.getOwningFrame((ISession)this._session));
        this.customDialog.addExecuteListener(new AbstractRefactoringCommand.ExecuteListener());
        this.customDialog.addEditSQLListener(new AbstractRefactoringCommand.EditSQLListener(this.customDialog));
        this.customDialog.addShowSQLListener(new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, this.customDialog));
        this.customDialog.setLocationRelativeTo(SessionUtils.getOwningFrame((ISession)this._session));
        this.customDialog.setVisible(true);
    }

    @Override
    protected String[] generateSQLStatements() throws UserCancelledOperationException, SQLException {
        ArrayList<String> result = new ArrayList<String>();
        if (this.s_log.isDebugEnabled()) {
            this.s_log.debug((Object)"Generating SQL Statements");
        }
        List<ITableInfo> tables = this.customDialog.getTableInfoList();
        boolean cascadeConstraints = this.customDialog.getCascadeConstraints();
        try {
            this.orderedTables = tables.size() > 1 ? this.getOrderedTables(tables) : tables;
            if (cascadeConstraints) {
                if (this.s_log.isDebugEnabled()) {
                    this.s_log.debug((Object)"Getting DropChildFKConstraintsSQL (CASCADE=true)");
                }
                for (ITableInfo info : this.orderedTables) {
                    List<String> dropFKSQLs = this.getDropChildFKConstraints(info);
                    result.addAll(dropFKSQLs);
                }
            }
            if (this.s_log.isDebugEnabled()) {
                this.s_log.debug((Object)"Getting TableDropSQL");
            }
            for (ITableInfo info : this.orderedTables) {
                boolean isMaterializedView = this.isMaterializedView(info, this._session);
                List sqls = this._dialect.getTableDropSQL(info, cascadeConstraints, isMaterializedView, this._qualifier, this._sqlPrefs);
                result.addAll(sqls);
            }
        }
        catch (UnsupportedOperationException e2) {
            this._session.showMessage(s_stringMgr.getString("DropTablesCommand.unsupportedOperationMsg", new Object[]{this._dialect.getDisplayName()}));
        }
        return result.toArray(new String[0]);
    }

    private List<String> getDropChildFKConstraints(ITableInfo ti) throws SQLException {
        if (this.s_log.isDebugEnabled()) {
            this.s_log.debug((Object)"entered getDropChildFKConstraints()");
        }
        ArrayList<String> result = new ArrayList<String>();
        ForeignKeyInfo[] fks = this._session.getMetaData().getExportedKeysInfo(ti);
        if (fks != null) {
            if (this.s_log.isDebugEnabled()) {
                this.s_log.debug((Object)("FKs.length: " + fks.length));
            }
            for (ForeignKeyInfo info : fks) {
                if (this.s_log.isDebugEnabled()) {
                    this.s_log.debug((Object)("FK Info: " + info));
                }
                String fkName = info.getForeignKeyName();
                String fkTable = info.getForeignKeyTableName();
                result.add(this._dialect.getDropForeignKeySQL(fkName, fkTable, this._qualifier, this._sqlPrefs));
            }
        }
        if (this.s_log.isDebugEnabled()) {
            this.s_log.debug((Object)"leaving getDropChildFKConstraints()");
        }
        return result;
    }

    private List<ITableInfo> getOrderedTables(List<ITableInfo> tables) throws SQLException {
        if (tables.size() < 2) {
            return tables;
        }
        SQLDatabaseMetaData md = this._session.getSQLConnection().getSQLMetaData();
        ProgressCallBack getOrderedTablesCallBack = this.progressCallBackFactory.create((JDialog)this.customDialog, i18n.PROGRESS_DIALOG_ANALYZE_TITLE, tables.size());
        getOrderedTablesCallBack.setLoadingPrefix(i18n.LOADING_PREFIX);
        List result = SQLUtilities.getDeletionOrder(tables, (SQLDatabaseMetaData)md, (ProgressCallBack)getOrderedTablesCallBack);
        getOrderedTablesCallBack.setVisible(false);
        getOrderedTablesCallBack.dispose();
        getOrderedTablesCallBack = null;
        return result;
    }

    private boolean isMaterializedView(ITableInfo ti, ISession session) throws SQLException {
        if (!DialectFactory.isOracle((ISQLDatabaseMetaData)session.getMetaData())) {
            return false;
        }
        if (this.matViewLookup == null) {
            this.initMatViewLookup(session, ti.getSchemaName());
        }
        return this.matViewLookup.contains(ti.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMatViewLookup(ISession session, String schema) throws SQLException {
        this.matViewLookup = new HashSet();
        String sql = "SELECT TABLE_NAME FROM ALL_TAB_COMMENTS where COMMENTS like 'snapshot%' and OWNER = ? ";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = session.getSQLConnection().prepareStatement("SELECT TABLE_NAME FROM ALL_TAB_COMMENTS where COMMENTS like 'snapshot%' and OWNER = ? ");
            stmt.setString(1, schema);
            rs = stmt.executeQuery();
            if (rs.next()) {
                String tableName = rs.getString(1);
                this.matViewLookup.add(tableName);
            }
        }
        catch (Throwable throwable) {
            SQLUtilities.closeResultSet(rs);
            SQLUtilities.closeStatement((Statement)stmt);
            throw throwable;
        }
        SQLUtilities.closeResultSet((ResultSet)rs);
        SQLUtilities.closeStatement((Statement)stmt);
    }

    @Override
    protected void executeScript(final String script) {
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                final DropTableCommandExecHandler handler = new DropTableCommandExecHandler(DropTablesCommand.this._session);
                DropTablesCommand.this._session.getApplication().getThreadPool().addTask(new Runnable(){

                    @Override
                    public void run() {
                        SQLExecuterTask executer = new SQLExecuterTask(DropTablesCommand.this._session, script, (ISQLExecuterHandler)handler);
                        executer.setSchemaCheck(false);
                        executer.run();
                        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                handler.hideProgressDialog();
                                DropTablesCommand.this.customDialog.dispose();
                            }
                        });
                        DropTablesCommand.this._session.getSchemaInfo().reloadAllTables();
                    }
                });
            }
        });
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialectExt) {
        return true;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private class DropTableCommandExecHandler
    extends DefaultSQLExecuterHandler {
        ProgressCallBack cb;
        int tableCount;

        public DropTableCommandExecHandler(ISession session) {
            super(session);
            this.cb = null;
            this.tableCount = 0;
            this.cb = DropTablesCommand.this.progressCallBackFactory.create((JDialog)DropTablesCommand.this.customDialog, i18n.PROGRESS_DIALOG_DROP_TITLE, DropTablesCommand.this.orderedTables.size());
        }

        public void hideProgressDialog() {
            this.cb.setVisible(false);
            this.cb.dispose();
        }

        public void sqlStatementCount(int statementCount) {
            this.cb.setTotalItems(statementCount);
        }

        public void sqlToBeExecuted(String sql) {
            if (DropTablesCommand.this.s_log.isDebugEnabled()) {
                DropTablesCommand.this.s_log.debug((Object)("Statement to be executed: " + sql));
            }
            if (sql.startsWith("ALTER")) {
                this.cb.setLoadingPrefix(i18n.DROPPING_CONSTRAINT_PREFIX);
                String[] parts = StringUtilities.split((String)sql, (char)' ');
                this.cb.currentlyLoading(parts[parts.length - 1]);
            } else {
                this.cb.setLoadingPrefix(i18n.DROPPING_TABLE_PREFIX);
                if (this.tableCount < DropTablesCommand.this.orderedTables.size()) {
                    ITableInfo ti = (ITableInfo)DropTablesCommand.this.orderedTables.get(this.tableCount);
                    this.cb.currentlyLoading(ti.getSimpleName());
                }
                ++this.tableCount;
            }
        }
    }

    static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = DropTablesCommand.access$000().getString("DropTablesCommand.sqlDialogTitle");
        public static final String PROGRESS_DIALOG_ANALYZE_TITLE = DropTablesCommand.access$000().getString("DropTablesCommand.progressDialogAnalyzeTitle");
        public static final String PROGRESS_DIALOG_DROP_TITLE = DropTablesCommand.access$000().getString("DropTablesCommand.progressDialogDropTitle");
        public static final String LOADING_PREFIX = DropTablesCommand.access$000().getString("DropTablesCommand.loadingPrefix");
        public static final String DROPPING_CONSTRAINT_PREFIX = DropTablesCommand.access$000().getString("DropTablesCommand.droppingConstraintPrefix");
        public static final String DROPPING_TABLE_PREFIX = DropTablesCommand.access$000().getString("DropTablesCommand.droppingTablePrefix");
    }
}

