/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Font;
import java.io.Serializable;

public class FontInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static String DEFAULT_FAMILY = "Monospaced";
    private String _familyName;
    private boolean _isBold;
    private boolean _isItalic;
    private int _size;

    public FontInfo() {
        this.setFamily(DEFAULT_FAMILY);
        this.setSize(12);
    }

    public FontInfo(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null Font passed");
        }
        this.setFont(font);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    public String getFamily() {
        return this._familyName;
    }

    public void setFamily(String value) {
        this._familyName = value != null ? value : DEFAULT_FAMILY;
    }

    public boolean isBold() {
        return this._isBold;
    }

    public void setIsBold(boolean value) {
        this._isBold = value;
    }

    public boolean isItalic() {
        return this._isItalic;
    }

    public void setIsItalic(boolean value) {
        this._isItalic = value;
    }

    public int getSize() {
        return this._size;
    }

    public void setSize(int value) {
        this._size = value;
    }

    public void setFont(Font font) throws IllegalArgumentException {
        if (font == null) {
            throw new IllegalArgumentException("Null Font passed");
        }
        this._familyName = font.getFamily();
        this._isBold = font.isBold();
        this._isItalic = font.isItalic();
        this._size = font.getSize();
    }

    public boolean doesFontMatch(Font font) {
        if (font == null) {
            return false;
        }
        return font.getFamily().equals(this._familyName) && font.getSize() == this.getSize() && font.getStyle() == this.generateStyle();
    }

    public int generateStyle() {
        int style = 0;
        if (!this._isBold && !this._isItalic) {
            style = 0;
        } else {
            if (this._isBold) {
                style |= 1;
            }
            if (this._isItalic) {
                style |= 2;
            }
        }
        return style;
    }

    public Font createFont() {
        return new Font(this._familyName, this.generateStyle(), this._size);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this._familyName).append(", " + this._size);
        if (this._isBold) {
            buf.append(", bold");
        }
        if (this._isItalic) {
            buf.append(", italic");
        }
        return buf.toString();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this._familyName == null ? 0 : this._familyName.hashCode());
        result = 31 * result + (this._isBold ? 1231 : 1237);
        result = 31 * result + (this._isItalic ? 1231 : 1237);
        result = 31 * result + this._size;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FontInfo other = (FontInfo)obj;
        if (this._familyName == null ? other._familyName != null : !this._familyName.equals(other._familyName)) {
            return false;
        }
        if (this._isBold != other._isBold) {
            return false;
        }
        if (this._isItalic != other._isItalic) {
            return false;
        }
        return this._size == other._size;
    }

    public static interface IPropertyNames {
        public static final String FAMILY = "family";
        public static final String IS_BOLD = "isBold";
        public static final String IS_ITALIC = "isItalic";
        public static final String SIZE = "size";
    }
}

