/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.desktopcontainer;

import java.io.File;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.ISessionWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.TabWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.TitleFilePathHandler;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.TitleFilePathHandlerListener;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public abstract class SessionTabWidget
extends TabWidget
implements ISessionWidget {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SessionTabWidget.class);
    private ISession _session;
    private String _titleWithoutFile = "";
    private TitleFilePathHandler _titleFileHandler;

    public SessionTabWidget(String title, boolean resizeable, boolean closeable, boolean maximizeable, boolean iconifiable, ISession session) {
        super(title, resizeable, closeable, maximizeable, iconifiable, session.getApplication());
        this._session = session;
        this._titleWithoutFile = title;
        this.setupSheet();
        TitleFilePathHandlerListener titleFilePathHandlerListener = new TitleFilePathHandlerListener(){

            @Override
            public void refreshFileDisplay() {
                SessionTabWidget.this.setTitle(SessionTabWidget.this._titleWithoutFile);
            }
        };
        this._titleFileHandler = new TitleFilePathHandler(this._session.getApplication().getResources(), titleFilePathHandlerListener);
    }

    public SessionTabWidget(String title, boolean resizeable, ISession session) {
        this(title, resizeable, true, false, false, session);
    }

    @Override
    public ISession getSession() {
        return this._session;
    }

    @Override
    public void closeFrame(boolean withEvents) {
        if (!this._session.isfinishedLoading()) {
            return;
        }
        if (withEvents) {
            this.fireWidgetClosing();
        }
        this.dispose();
        if (withEvents) {
            this.fireWidgetClosed();
        }
    }

    private final void setupSheet() {
        this._session.getApplication().getWindowManager().registerSessionSheet(this);
        this.addWidgetListener(new SheetActivationListener());
    }

    @Override
    public void setTitle(String title) {
        this._titleWithoutFile = title;
        if (null == this._titleFileHandler) {
            super.setTitle(this._titleWithoutFile);
            return;
        }
        if (this._titleFileHandler.hasFile()) {
            String compositetitle = this._titleWithoutFile + this._titleFileHandler.getSqlFile();
            super.setTitle(compositetitle);
            super.addSmallTabButton(this._titleFileHandler.getFileMenuSmallButton());
        } else {
            super.setTitle(this._titleWithoutFile);
            super.removeSmallTabButton(this._titleFileHandler.getFileMenuSmallButton());
        }
    }

    public void setSqlFile(File sqlFile) {
        this._titleFileHandler.setSqlFile(sqlFile);
        this.setTitle(this._titleWithoutFile);
    }

    public void setUnsavedEdits(boolean unsavedEdits) {
        this._titleFileHandler.setUnsavedEdits(unsavedEdits);
    }

    private class SheetActivationListener
    extends WidgetAdapter {
        private SheetActivationListener() {
        }

        @Override
        public void widgetActivated(WidgetEvent e) {
            SessionTabWidget.this._session.setActiveSessionWindow((ISessionWidget)e.getWidget());
            SessionTabWidget.this._session.getApplication().getSessionManager().setActiveSession(SessionTabWidget.this._session, false);
        }
    }
}

