/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import net.sourceforge.squirrel_sql.fw.gui.IToggleAction;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ToolBar
extends JToolBar {
    private static ILogger s_log = LoggerController.createLogger(ToolBar.class);

    public ToolBar() {
    }

    public ToolBar(int orientation) {
        super(orientation);
    }

    @Override
    public JButton add(Action action) {
        JButton btn = super.add(action);
        this.initialiseButton(action, btn);
        return btn;
    }

    public JToggleButton addToggleAction(IToggleAction action) {
        JToggleButton tglBtn = new JToggleButton();
        tglBtn.setAction(action);
        super.add(tglBtn);
        action.getToggleComponentHolder().addToggleableComponent(tglBtn);
        this.initialiseButton(action, tglBtn);
        return tglBtn;
    }

    public AbstractButton add(Action action, AbstractButton btn) {
        btn.setAction(action);
        super.add(btn);
        this.initialiseButton(action, btn);
        return btn;
    }

    public void setUseRolloverButtons(boolean value) {
        this.putClientProperty("JToolBar.isRollover", value ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void initialiseButton(Action action, AbstractButton btn) {
        if (btn != null) {
            btn.setRequestFocusEnabled(false);
            btn.setText("");
            String tt = null;
            if (action != null) {
                tt = (String)action.getValue("ShortDescription");
            }
            btn.setToolTipText(tt != null ? tt : "");
            if (action != null) {
                Icon icon = this.getIconFromAction(action, "squirrelRolloverIcon");
                if (icon != null) {
                    btn.setRolloverIcon(icon);
                    btn.setRolloverSelectedIcon(icon);
                }
                if ((icon = this.getIconFromAction(action, "squirrelDisabledIcon")) != null) {
                    btn.setDisabledIcon(icon);
                }
            }
        }
    }

    protected Icon getIconFromAction(Action action, String key) {
        Object obj = action.getValue(key);
        if (obj != null) {
            if (obj instanceof Icon) {
                return (Icon)obj;
            }
            StringBuffer msg = new StringBuffer();
            msg.append("Non icon object of type ").append(obj.getClass().getName()).append(" was stored in an Action of type ").append(action.getClass().getName()).append(" using the key ").append(key).append(".");
            s_log.error(msg.toString());
        }
        return null;
    }
}

