/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.local;

import java.util.ArrayList;
import java.util.List;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;
import org.intellij.plugins.xsltDebugger.rt.engine.OutputEventQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputEventQueueImpl
implements OutputEventQueue {
    private final Debugger myDebugger;
    private final List<OutputEventQueue.NodeEvent> myEvents = new ArrayList<OutputEventQueue.NodeEvent>();
    private boolean myEnabled = true;

    public OutputEventQueueImpl(Debugger debugger) {
        this.myDebugger = debugger;
    }

    public void startDocument() {
        if (this.myEnabled) {
            this.myEvents.add(new OutputEventQueue.NodeEvent(0, null, null));
        }
    }

    public void endDocument() {
        if (this.myEnabled) {
            this.myEvents.add(new OutputEventQueue.NodeEvent(99, null, null));
        }
    }

    public void startElement(String prefix, String localName, String uri) {
        this.addEvent(new OutputEventQueue.NodeEvent(1, new OutputEventQueue.NodeEvent.QName(prefix, localName, uri), null));
    }

    public void attribute(String prefix, String localName, String uri, String value) {
        this.addEvent(new OutputEventQueue.NodeEvent(3, new OutputEventQueue.NodeEvent.QName(prefix, localName, uri), value));
    }

    public void endElement() {
        this.addEvent(new OutputEventQueue.NodeEvent(2, null, null));
    }

    public void characters(String s) {
        this.addEvent(new OutputEventQueue.NodeEvent(4, null, s));
    }

    public void comment(String s) {
        this.addEvent(new OutputEventQueue.NodeEvent(5, null, s));
    }

    public void pi(String target, String data) {
        this.addEvent(new OutputEventQueue.NodeEvent(6, new OutputEventQueue.NodeEvent.QName(target), data));
    }

    public void trace(String text) {
        this.addEvent(new OutputEventQueue.NodeEvent(20, null, text));
    }

    public void setEnabled(boolean b) {
        this.myEnabled = b;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    private void addEvent(OutputEventQueue.NodeEvent event) {
        if (this.myEnabled) {
            Debugger.StyleFrame frame = this.myDebugger.getCurrentFrame();
            if (frame != null) {
                event.setLocation(frame.getURI(), frame.getLineNumber());
            }
            this.myEvents.add(event);
        }
    }

    public List<OutputEventQueue.NodeEvent> getEvents() {
        try {
            ArrayList<OutputEventQueue.NodeEvent> arrayList = new ArrayList<OutputEventQueue.NodeEvent>(this.myEvents);
            return arrayList;
        }
        finally {
            this.myEvents.clear();
        }
    }
}

