/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.NewRootBunch;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public class DefaultBranchConfigInitializer
implements Runnable {
    private static final Logger LOG = Logger.getInstance(DefaultBranchConfigInitializer.class);
    @NonNls
    private static final String DEFAULT_TRUNK_NAME = "trunk";
    @NonNls
    private static final String DEFAULT_BRANCHES_NAME = "branches";
    @NonNls
    private static final String DEFAULT_TAGS_NAME = "tags";
    @NotNull
    private final Project myProject;
    @NotNull
    private final NewRootBunch myBunch;
    @NotNull
    private final VirtualFile myRoot;

    public DefaultBranchConfigInitializer(@NotNull Project project, @NotNull NewRootBunch bunch, @NotNull VirtualFile root) {
        if (project == null) {
            DefaultBranchConfigInitializer.$$$reportNull$$$0(0);
        }
        if (bunch == null) {
            DefaultBranchConfigInitializer.$$$reportNull$$$0(1);
        }
        if (root == null) {
            DefaultBranchConfigInitializer.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myRoot = root;
        this.myBunch = bunch;
    }

    @Override
    public void run() {
        SvnBranchConfigurationNew configuration = this.getDefaultConfiguration();
        if (configuration != null) {
            for (Url url : configuration.getBranchLocations()) {
                this.myBunch.reloadBranchesAsync(this.myRoot, url, InfoReliability.defaultValues);
            }
            this.myBunch.updateForRoot(this.myRoot, new InfoStorage<SvnBranchConfigurationNew>(configuration, InfoReliability.defaultValues), false);
        }
    }

    @Nullable
    public SvnBranchConfigurationNew getDefaultConfiguration() {
        SvnBranchConfigurationNew result = null;
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        Url rootUrl = SvnUtil.getUrl(vcs, VfsUtilCore.virtualToIoFile((VirtualFile)this.myRoot));
        if (rootUrl != null) {
            try {
                result = DefaultBranchConfigInitializer.getDefaultConfiguration(vcs, rootUrl);
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        } else {
            LOG.info("Directory is not a working copy: " + this.myRoot.getPresentableUrl());
        }
        return result;
    }

    @NotNull
    private static SvnBranchConfigurationNew getDefaultConfiguration(@NotNull SvnVcs vcs, @NotNull Url url) throws VcsException {
        if (vcs == null) {
            DefaultBranchConfigInitializer.$$$reportNull$$$0(3);
        }
        if (url == null) {
            DefaultBranchConfigInitializer.$$$reportNull$$$0(4);
        }
        SvnBranchConfigurationNew result = new SvnBranchConfigurationNew();
        result.setTrunk(url);
        Url branchLocationsParent = DefaultBranchConfigInitializer.getBranchLocationsParent(url);
        if (branchLocationsParent != null) {
            Target target = Target.on(branchLocationsParent);
            vcs.getFactory(target).createBrowseClient().list(target, Revision.HEAD, Depth.IMMEDIATES, DefaultBranchConfigInitializer.createHandler(result, target.getUrl()));
        }
        SvnBranchConfigurationNew svnBranchConfigurationNew = result;
        if (svnBranchConfigurationNew == null) {
            DefaultBranchConfigInitializer.$$$reportNull$$$0(5);
        }
        return svnBranchConfigurationNew;
    }

    @Nullable
    private static Url getBranchLocationsParent(@NotNull Url url) throws SvnBindException {
        if (url == null) {
            DefaultBranchConfigInitializer.$$$reportNull$$$0(6);
        }
        while (!DefaultBranchConfigInitializer.hasEmptyName(url) && !DefaultBranchConfigInitializer.hasDefaultName(url)) {
            url = SvnUtil.removePathTail(url);
        }
        return DefaultBranchConfigInitializer.hasDefaultName(url) ? SvnUtil.removePathTail(url) : null;
    }

    private static boolean hasEmptyName(@NotNull Url url) {
        if (url == null) {
            DefaultBranchConfigInitializer.$$$reportNull$$$0(7);
        }
        return StringUtil.isEmpty((String)url.getTail());
    }

    private static boolean hasDefaultName(@NotNull Url url) {
        String name;
        if (url == null) {
            DefaultBranchConfigInitializer.$$$reportNull$$$0(8);
        }
        return (name = url.getTail()).equalsIgnoreCase(DEFAULT_TRUNK_NAME) || name.equalsIgnoreCase(DEFAULT_BRANCHES_NAME) || name.equalsIgnoreCase(DEFAULT_TAGS_NAME);
    }

    @NotNull
    private static DirectoryEntryConsumer createHandler(@NotNull SvnBranchConfigurationNew result, @NotNull Url rootPath) {
        if (result == null) {
            DefaultBranchConfigInitializer.$$$reportNull$$$0(9);
        }
        if (rootPath == null) {
            DefaultBranchConfigInitializer.$$$reportNull$$$0(10);
        }
        DirectoryEntryConsumer directoryEntryConsumer = entry -> {
            if (rootPath == null) {
                DefaultBranchConfigInitializer.$$$reportNull$$$0(12);
            }
            if (result == null) {
                DefaultBranchConfigInitializer.$$$reportNull$$$0(13);
            }
            if (entry.isDirectory()) {
                Url childUrl = SvnUtil.append(rootPath, entry.getName());
                if (StringUtil.endsWithIgnoreCase((String)entry.getName(), (String)DEFAULT_TRUNK_NAME)) {
                    result.setTrunk(childUrl);
                } else {
                    result.addBranches(childUrl, new InfoStorage<List<SvnBranchItem>>(new ArrayList(0), InfoReliability.defaultValues));
                }
            }
        };
        if (directoryEntryConsumer == null) {
            DefaultBranchConfigInitializer.$$$reportNull$$$0(11);
        }
        return directoryEntryConsumer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bunch";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/branchConfig/DefaultBranchConfigInitializer";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/branchConfig/DefaultBranchConfigInitializer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfiguration";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfiguration";
                break;
            }
            case 5: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBranchLocationsParent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasEmptyName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasDefaultName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createHandler$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

