/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.BarContainer;
import com.intellij.ui.mac.touchbar.BuildUtils;
import com.intellij.ui.mac.touchbar.ItemListener;
import com.intellij.ui.mac.touchbar.ItemsContainer;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.NSTLibrary;
import com.intellij.ui.mac.touchbar.SpacingItem;
import com.intellij.ui.mac.touchbar.TBItem;
import com.intellij.ui.mac.touchbar.TBItemAnActionButton;
import com.intellij.ui.mac.touchbar.TBItemButton;
import com.intellij.ui.mac.touchbar.TBItemGroup;
import com.intellij.ui.mac.touchbar.TBItemPopover;
import com.intellij.ui.mac.touchbar.TBItemScrubber;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.ui.mac.touchbar.Utils;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Robot;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TouchBar
implements NSTLibrary.ItemCreator {
    private static final Logger LOG = Logger.getInstance(TouchBar.class);
    private final ItemsContainer myItems;
    private final ItemListener myItemListener;
    private final TBItemButton myCustomEsc;
    @NotNull
    private final UpdateTimerWrapper myUpdateTimer;
    private long myStartShowNs;
    private ID myNativePeer;
    private String myDefaultOptionalContextName;
    private BarContainer myBarContainer;
    public static final TouchBar EMPTY = new TouchBar();

    private TouchBar() {
        this.myUpdateTimer = new UpdateTimerWrapper(500);
        this.myStartShowNs = 0L;
        this.myItems = new ItemsContainer("EMPTY_STUB_TOUCHBAR", null);
        this.myCustomEsc = null;
        this.myNativePeer = ID.NIL;
        this.myItemListener = null;
    }

    TouchBar(@NotNull String touchbarName, boolean replaceEsc) {
        if (touchbarName == null) {
            TouchBar.$$$reportNull$$$0(0);
        }
        this(touchbarName, replaceEsc, false, false);
    }

    TouchBar(@NotNull String touchbarName, boolean replaceEsc, boolean autoClose, boolean emulateESC) {
        if (touchbarName == null) {
            TouchBar.$$$reportNull$$$0(1);
        }
        this.myUpdateTimer = new UpdateTimerWrapper(500);
        this.myStartShowNs = 0L;
        this.myItemListener = autoClose ? (src, evcode) -> this._closeSelf() : null;
        this.myItems = new ItemsContainer(touchbarName, this.myItemListener);
        if (replaceEsc) {
            Icon ic = IconLoader.getIcon((String)"/mac/touchbar/popoverClose_dark.svg");
            this.myCustomEsc = new TBItemButton(touchbarName + "_custom_esc_button", this.myItemListener).setIcon(ic).setWidth(64).setTransparentBg(true).setThreadSafeAction(() -> {
                this._closeSelf();
                if (emulateESC) {
                    try {
                        Robot robot = new Robot();
                        robot.keyPress(27);
                        robot.keyRelease(27);
                    }
                    catch (AWTException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
        } else {
            this.myCustomEsc = null;
        }
        this.myNativePeer = NST.createTouchBar(touchbarName, this, this.myCustomEsc != null ? this.myCustomEsc.myUid : null);
    }

    static TouchBar buildFromCustomizedGroup(@NotNull String touchbarName, @NotNull ActionGroup customizedGroup, boolean replaceEsc) {
        if (touchbarName == null) {
            TouchBar.$$$reportNull$$$0(2);
        }
        if (customizedGroup == null) {
            TouchBar.$$$reportNull$$$0(3);
        }
        final TouchBar result2 = new TouchBar(touchbarName, replaceEsc);
        String groupId = BuildUtils.getActionId((AnAction)customizedGroup);
        if (groupId == null) {
            LOG.error("unregistered customized group: " + customizedGroup);
            return result2;
        }
        String filterPrefix = groupId + "_";
        result2.myDefaultOptionalContextName = groupId + "OptionalGroup";
        BuildUtils.Customizer customizer = new BuildUtils.Customizer(){

            @Override
            public void process(@NotNull BuildUtils.INodeInfo ni, @NotNull TBItemAnActionButton butt) {
                if (ni == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (butt == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.process(ni, butt);
                if (result2.myDefaultOptionalContextName.equals(ni.getParentGroupID())) {
                    butt.myOptionalContextName = result2.myDefaultOptionalContextName;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "ni";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "butt";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/mac/touchbar/TouchBar$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        BuildUtils.addActionGroupButtons(result2, customizedGroup, filterPrefix, customizer);
        result2.selectVisibleItemsToShow();
        return result2;
    }

    static TouchBar buildFromGroup(@NotNull String touchbarName, @NotNull ActionGroup actions, boolean replaceEsc, boolean emulateESC) {
        TouchbarDataKeys.ActionDesc groupDesc;
        if (touchbarName == null) {
            TouchBar.$$$reportNull$$$0(4);
        }
        if (actions == null) {
            TouchBar.$$$reportNull$$$0(5);
        }
        if ((groupDesc = (TouchbarDataKeys.ActionDesc)actions.getTemplatePresentation().getClientProperty(TouchbarDataKeys.ACTIONS_DESCRIPTOR_KEY)) != null && !groupDesc.isReplaceEsc()) {
            replaceEsc = false;
        }
        TouchBar result2 = new TouchBar(touchbarName, replaceEsc, false, emulateESC);
        TouchBar.addActionGroup(result2, actions);
        return result2;
    }

    static void addActionGroup(TouchBar result2, @NotNull ActionGroup actions) {
        if (actions == null) {
            TouchBar.$$$reportNull$$$0(6);
        }
        ModalityState ms = Utils.getCurrentModalityState();
        TouchbarDataKeys.ActionDesc groupDesc = (TouchbarDataKeys.ActionDesc)actions.getTemplatePresentation().getClientProperty(TouchbarDataKeys.ACTIONS_DESCRIPTOR_KEY);
        BuildUtils.Customizer customizer = new BuildUtils.Customizer(groupDesc, ms);
        TouchBar.addActionGroup(result2, actions, customizer);
    }

    static void addActionGroup(TouchBar result2, @NotNull ActionGroup actions, @NotNull BuildUtils.Customizer customizer) {
        if (actions == null) {
            TouchBar.$$$reportNull$$$0(7);
        }
        if (customizer == null) {
            TouchBar.$$$reportNull$$$0(8);
        }
        BuildUtils.addActionGroupButtons(result2, actions, null, customizer);
        result2.selectVisibleItemsToShow();
    }

    boolean isManualClose() {
        return this.myCustomEsc != null;
    }

    boolean isEmpty() {
        return this.myItems.isEmpty() || !this.myItems.anyMatchDeep(item -> item != null && !(item instanceof SpacingItem));
    }

    public String toString() {
        return this.myItems.toString() + "_" + this.myNativePeer;
    }

    @Override
    public ID createItem(@NotNull String uid) {
        if (uid == null) {
            TouchBar.$$$reportNull$$$0(9);
        }
        if (this.myCustomEsc != null && this.myCustomEsc.myUid.equals(uid)) {
            return this.myCustomEsc.getNativePeer();
        }
        TBItem item = this.myItems.findItem(uid);
        if (item == null) {
            LOG.error("can't find TBItem with uid '" + uid + "'");
            return ID.NIL;
        }
        return item.getNativePeer();
    }

    ID getNativePeer() {
        return this.myNativePeer;
    }

    ItemsContainer getItemsContainer() {
        return this.myItems;
    }

    void release() {
        this.myItems.releaseAll();
        if (!this.myNativePeer.equals((Object)ID.NIL)) {
            NST.releaseTouchBar(this.myNativePeer);
            this.myNativePeer = ID.NIL;
        }
        this.myUpdateTimer.stop();
    }

    void clear() {
        this.myItems.releaseAll();
    }

    @NotNull
    TBItemButton addButton() {
        TBItemButton tBItemButton = this.myItems.addButton();
        if (tBItemButton == null) {
            TouchBar.$$$reportNull$$$0(10);
        }
        return tBItemButton;
    }

    @NotNull
    TBItemAnActionButton addAnActionButton(@NotNull AnAction act) {
        if (act == null) {
            TouchBar.$$$reportNull$$$0(11);
        }
        TBItemAnActionButton tBItemAnActionButton = this.myItems.addAnActionButton(act);
        if (tBItemAnActionButton == null) {
            TouchBar.$$$reportNull$$$0(12);
        }
        return tBItemAnActionButton;
    }

    @NotNull
    TBItemAnActionButton addAnActionButton(@NotNull AnAction act, @Nullable TBItem positionAnchor) {
        if (act == null) {
            TouchBar.$$$reportNull$$$0(13);
        }
        TBItemAnActionButton tBItemAnActionButton = this.myItems.addAnActionButton(act, positionAnchor);
        if (tBItemAnActionButton == null) {
            TouchBar.$$$reportNull$$$0(14);
        }
        return tBItemAnActionButton;
    }

    @NotNull
    TBItemGroup addGroup() {
        TBItemGroup tBItemGroup = this.myItems.addGroup();
        if (tBItemGroup == null) {
            TouchBar.$$$reportNull$$$0(15);
        }
        return tBItemGroup;
    }

    @NotNull
    TBItemScrubber addScrubber() {
        TBItemScrubber tBItemScrubber = this.myItems.addScrubber();
        if (tBItemScrubber == null) {
            TouchBar.$$$reportNull$$$0(16);
        }
        return tBItemScrubber;
    }

    @NotNull
    TBItemPopover addPopover(Icon icon, String text, int width, TouchBar expandTB, TouchBar tapAndHoldTB) {
        TBItemPopover tBItemPopover = this.myItems.addPopover(icon, text, width, expandTB, tapAndHoldTB);
        if (tBItemPopover == null) {
            TouchBar.$$$reportNull$$$0(17);
        }
        return tBItemPopover;
    }

    @NotNull
    void addSpacing(boolean large) {
        this.myItems.addSpacing(large);
    }

    @NotNull
    void addFlexibleSpacing() {
        this.myItems.addFlexibleSpacing();
    }

    void setBarContainer(BarContainer barContainer) {
        this.myBarContainer = barContainer;
    }

    void setDefaultOptionalContextName(@NotNull String defaultCtxName) {
        if (defaultCtxName == null) {
            TouchBar.$$$reportNull$$$0(18);
        }
        this.myDefaultOptionalContextName = defaultCtxName;
    }

    void setOptionalContextItems(@NotNull ActionGroup actions, final @NotNull String contextName) {
        if (actions == null) {
            TouchBar.$$$reportNull$$$0(19);
        }
        if (contextName == null) {
            TouchBar.$$$reportNull$$$0(20);
        }
        this.myItems.releaseItems(tbi -> {
            if (contextName == null) {
                TouchBar.$$$reportNull$$$0(24);
            }
            return contextName.equals(tbi.myOptionalContextName);
        });
        BuildUtils.addActionGroupButtons(this, actions, null, new BuildUtils.Customizer(){

            @Override
            public void process(@NotNull BuildUtils.INodeInfo ni, @NotNull TBItemAnActionButton butt) {
                if (ni == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (butt == null) {
                    2.$$$reportNull$$$0(1);
                }
                super.process(ni, butt);
                butt.myOptionalContextName = contextName;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "ni";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "butt";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/mac/touchbar/TouchBar$2";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.selectVisibleItemsToShow();
    }

    void removeOptionalContextItems(@NotNull String contextName) {
        if (contextName == null) {
            TouchBar.$$$reportNull$$$0(21);
        }
        this.myItems.releaseItems(tbi -> {
            if (contextName == null) {
                TouchBar.$$$reportNull$$$0(23);
            }
            return contextName.equals(tbi.myOptionalContextName);
        });
        this.selectVisibleItemsToShow();
    }

    void setOptionalContextVisible(@Nullable String contextName) {
        String ctx = contextName == null ? this.myDefaultOptionalContextName : contextName;
        boolean[] visibilityChanged = new boolean[]{false};
        this.myItems.forEachDeep(tbi -> {
            if (tbi.myOptionalContextName == null) {
                return;
            }
            boolean newVisible = tbi.myOptionalContextName.equals(ctx);
            if (tbi.myIsVisible != newVisible) {
                if (tbi instanceof TBItemAnActionButton) {
                    ((TBItemAnActionButton)tbi).setAutoVisibility(newVisible);
                }
                tbi.myIsVisible = newVisible;
                visibilityChanged[0] = true;
            }
        });
        if (visibilityChanged[0]) {
            this.selectVisibleItemsToShow();
        }
    }

    void selectVisibleItemsToShow() {
        if (this.myItems.isEmpty()) {
            return;
        }
        String[] ids = this.myItems.getVisibleIds();
        NST.selectItemsToShow(this.myNativePeer, ids, ids.length);
    }

    void setPrincipal(@NotNull TBItem item) {
        if (item == null) {
            TouchBar.$$$reportNull$$$0(22);
        }
        NST.setPrincipal(this.myNativePeer, item.myUid);
    }

    void onBeforeShow() {
        this.myStartShowNs = System.nanoTime();
        this.updateActionItems();
        this.myUpdateTimer.start();
    }

    void onHide() {
        this.myUpdateTimer.stop();
    }

    void forEachDeep(Consumer<? super TBItem> proc) {
        this.myItems.forEachDeep(proc);
    }

    void updateActionItems() {
        long elapsedFromStartShowNs = System.nanoTime() - this.myStartShowNs;
        boolean forceUseCached = elapsedFromStartShowNs < 500000000L;
        boolean[] layoutChanged = new boolean[]{false};
        this.forEachDeep(tbitem -> {
            if (!(tbitem instanceof TBItemAnActionButton)) {
                return;
            }
            TBItemAnActionButton item = (TBItemAnActionButton)tbitem;
            Presentation presentation = item.updateAnAction(forceUseCached);
            boolean itemVisibilityChanged = item.updateVisibility(presentation);
            if (itemVisibilityChanged) {
                layoutChanged[0] = true;
            }
            item.updateView(presentation);
        });
        if (layoutChanged[0]) {
            this.selectVisibleItemsToShow();
        }
    }

    void setComponent(Component component) {
        this.myItems.forEachDeep(item -> {
            if (item instanceof TBItemAnActionButton) {
                ((TBItemAnActionButton)item).setComponent(component);
            }
        });
    }

    private void _closeSelf() {
        if (this.myBarContainer == null) {
            LOG.error("can't perform _closeSelf for touchbar '" + this.toString() + "' because parent container wasn't set");
            return;
        }
        TouchBarsManager.hideContainer(this.myBarContainer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "touchbarName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customizedGroup";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customizer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uid";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/touchbar/TouchBar";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "act";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCtxName";
                break;
            }
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/touchbar/TouchBar";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "addButton";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "addAnActionButton";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "addGroup";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addScrubber";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "addPopover";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildFromCustomizedGroup";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildFromGroup";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addActionGroup";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createItem";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addAnActionButton";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultOptionalContextName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setOptionalContextItems";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeOptionalContextItems";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setPrincipal";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeOptionalContextItems$4";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setOptionalContextItems$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class UpdateTimerWrapper {
        final int myDelay;
        Object myTimerImpl;

        UpdateTimerWrapper(int delay) {
            this.myDelay = delay;
        }

        void start() {
            if (this.myTimerImpl != null) {
                this.stop();
            }
            if (ApplicationManager.getApplication() == null) {
                Timer t = new Timer(this.myDelay, event -> TouchBar.this.updateActionItems());
                this.myTimerImpl = t;
                t.setRepeats(true);
                t.start();
                return;
            }
            TimerListener t = new TimerListener(){

                public ModalityState getModalityState() {
                    return ModalityState.current();
                }

                public void run() {
                    TouchBar.this.updateActionItems();
                }
            };
            this.myTimerImpl = t;
            ActionManager.getInstance().addTransparentTimerListener(this.myDelay, t);
        }

        void stop() {
            if (this.myTimerImpl == null) {
                return;
            }
            if (this.myTimerImpl instanceof Timer) {
                ((Timer)this.myTimerImpl).stop();
            } else if (this.myTimerImpl instanceof TimerListener) {
                ActionManager.getInstance().removeTransparentTimerListener((TimerListener)this.myTimerImpl);
            }
            this.myTimerImpl = null;
        }
    }
}

