/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.util.LineSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineSeparatorPanel
extends EditorBasedStatusBarPopup {
    public LineSeparatorPanel(@NotNull Project project) {
        if (project == null) {
            LineSeparatorPanel.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @Override
    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file2) {
        String panelText;
        String toolTipText;
        if (file2 == null) {
            EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.HIDDEN;
            if (widgetState == null) {
                LineSeparatorPanel.$$$reportNull$$$0(1);
            }
            return widgetState;
        }
        String lineSeparator = LoadTextUtil.detectLineSeparator(file2, true);
        if (lineSeparator != null) {
            toolTipText = String.format("Line separator: %s", StringUtil.escapeLineBreak((String)lineSeparator));
            panelText = LineSeparator.fromString((String)lineSeparator).toString();
        } else {
            toolTipText = "No line separator";
            panelText = "n/a";
        }
        EditorBasedStatusBarPopup.WidgetState widgetState = new EditorBasedStatusBarPopup.WidgetState(toolTipText, panelText, lineSeparator != null);
        if (widgetState == null) {
            LineSeparatorPanel.$$$reportNull$$$0(2);
        }
        return widgetState;
    }

    @Override
    @Nullable
    protected ListPopup createPopup(DataContext context) {
        AnAction group = ActionManager.getInstance().getAction("ChangeLineSeparators");
        if (!(group instanceof ActionGroup)) {
            return null;
        }
        return JBPopupFactory.getInstance().createActionGroupPopup("Line Separator", (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
    }

    @Override
    protected void registerCustomListeners() {
    }

    @Override
    @NotNull
    protected StatusBarWidget createInstance(Project project) {
        LineSeparatorPanel lineSeparatorPanel = new LineSeparatorPanel(project);
        if (lineSeparatorPanel == null) {
            LineSeparatorPanel.$$$reportNull$$$0(3);
        }
        return lineSeparatorPanel;
    }

    @NotNull
    public String ID() {
        if ("LineSeparator" == null) {
            LineSeparatorPanel.$$$reportNull$$$0(4);
        }
        return "LineSeparator";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/LineSeparatorPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/LineSeparatorPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "ID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

