/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class VfsDependentEnum<T> {
    private static final String DEPENDENT_PERSISTENT_LIST_START_PREFIX = "vfs_enum_";
    private final File myFile;
    private final DataExternalizer<T> myKeyDescriptor;
    private final int myVersion;
    private boolean myMarkedForInvalidation;
    private final ConcurrentList<T> myInstances = ContainerUtil.createConcurrentList();
    private final ConcurrentMap<T, Integer> myInstanceToId = ContainerUtil.newConcurrentMap();
    private final Object myLock = new Object();
    private boolean myTriedToLoadFile;

    public VfsDependentEnum(String fileName, KeyDescriptor<T> descriptor, int version) {
        this.myFile = new File(FSRecords.basePath(), DEPENDENT_PERSISTENT_LIST_START_PREFIX + fileName + FSRecords.VFS_FILES_EXTENSION);
        this.myKeyDescriptor = descriptor;
        this.myVersion = version;
    }

    static File getBaseFile() {
        return new File(FSRecords.basePath(), DEPENDENT_PERSISTENT_LIST_START_PREFIX);
    }

    public int getId(@NotNull T s) throws IOException {
        Integer integer;
        if (s == null) {
            VfsDependentEnum.$$$reportNull$$$0(0);
        }
        if ((integer = (Integer)this.myInstanceToId.get(s)) != null) {
            return integer;
        }
        Object object = this.myLock;
        synchronized (object) {
            integer = (Integer)this.myInstanceToId.get(s);
            if (integer != null) {
                return integer;
            }
            try {
                boolean loaded = this.loadFromFile();
                if (loaded && (integer = (Integer)this.myInstanceToId.get(s)) != null) {
                    return integer;
                }
                int enumerated = this.myInstances.size() + 1;
                this.register(s, enumerated);
                this.saveToFile(s);
                return enumerated;
            }
            catch (IOException e) {
                this.invalidate(e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile(@NotNull T instance) throws IOException {
        if (instance == null) {
            VfsDependentEnum.$$$reportNull$$$0(1);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.myFile, true);
        try (DataOutputStream output = new DataOutputStream(new BufferedOutputStream(fileOutputStream));){
            if (this.myFile.length() == 0L) {
                DataInputOutputUtil.writeTIME((DataOutput)output, (long)FSRecords.getCreationTimestamp());
                DataInputOutputUtil.writeINT((DataOutput)output, (int)this.myVersion);
            }
            this.myKeyDescriptor.save((DataOutput)output, instance);
        }
        finally {
            try {
                fileOutputStream.getFD().sync();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadFromFile() throws IOException {
        THashMap elementToIdMap;
        ArrayList<Object> elements;
        DataInputStream input;
        block27: {
            if (this.myTriedToLoadFile) return false;
            if (!this.myInstances.isEmpty()) return false;
            if (!this.myFile.exists()) return false;
            this.myTriedToLoadFile = true;
            boolean deleteFile2 = false;
            input = new DataInputStream(new BufferedInputStream(new FileInputStream(this.myFile)));
            Throwable throwable = null;
            try {
                long vfsVersion = DataInputOutputUtil.readTIME((DataInput)input);
                if (vfsVersion != FSRecords.getCreationTimestamp()) {
                    deleteFile2 = true;
                    boolean bl = false;
                    return bl;
                }
                int savedVersion = DataInputOutputUtil.readINT((DataInput)input);
                if (savedVersion == this.myVersion) {
                    elements = new ArrayList<Object>();
                    elementToIdMap = new THashMap();
                    break block27;
                }
                throw new IOException("Version mismatch: current " + this.myVersion + ", previous:" + savedVersion + ", file:" + this.myFile);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (deleteFile2) {
                    FileUtil.deleteWithRenaming((File)this.myFile);
                }
            }
        }
        while (true) {
            if (input.available() <= 0) {
                this.myInstances.addAll(elements);
                this.myInstanceToId.putAll((Map<T, Integer>)elementToIdMap);
                boolean bl = true;
                return bl;
            }
            Object instance = this.myKeyDescriptor.read((DataInput)input);
            assert (instance != null);
            elements.add(instance);
            elementToIdMap.put(instance, elements.size());
        }
    }

    private void invalidate(@NotNull Throwable e) {
        if (e == null) {
            VfsDependentEnum.$$$reportNull$$$0(2);
        }
        if (!this.myMarkedForInvalidation) {
            this.myMarkedForInvalidation = true;
            this.doInvalidation(e);
        }
    }

    @Contract(value="_->fail")
    private void doInvalidation(@NotNull Throwable e) {
        if (e == null) {
            VfsDependentEnum.$$$reportNull$$$0(3);
        }
        FileUtil.deleteWithRenaming((File)this.myFile);
        FSRecords.requestVfsRebuild(e);
    }

    private void register(@NotNull T instance, int id) {
        if (instance == null) {
            VfsDependentEnum.$$$reportNull$$$0(4);
        }
        this.myInstanceToId.put(instance, id);
        assert (id == this.myInstances.size() + 1);
        this.myInstances.add(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public T getById(int id) throws IOException {
        boolean loaded;
        block10: {
            Object instance;
            assert (id > 0);
            if (--id < this.myInstances.size() && (instance = this.myInstances.get(id)) != null) {
                Object object = instance;
                if (object != null) return (T)object;
                VfsDependentEnum.$$$reportNull$$$0(5);
                return (T)object;
            }
            Object object = this.myLock;
            // MONITORENTER : object
            if (id < this.myInstances.size() && (instance = this.myInstances.get(id)) != null) {
                Object object2 = instance;
                // MONITOREXIT : object
                if (object2 != null) return (T)object2;
                VfsDependentEnum.$$$reportNull$$$0(6);
                return (T)object2;
            }
            loaded = this.loadFromFile();
            if (!loaded || (instance = this.myInstances.get(id)) == null) break block10;
            Object object3 = instance;
            // MONITOREXIT : object
            if (object3 != null) return (T)object3;
            VfsDependentEnum.$$$reportNull$$$0(7);
            return (T)object3;
        }
        try {
            assert (false) : "Reading nonexistent value:" + id + "," + this.myFile + ", loaded:" + loaded;
        }
        catch (IOException | AssertionError e) {
            this.invalidate((Throwable)e);
            throw e;
        }
        VfsDependentEnum.$$$reportNull$$$0(8);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/VfsDependentEnum";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/VfsDependentEnum";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getById";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "saveToFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInvalidation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

