/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.Kernel;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class GlassPanel
extends JComponent {
    private final Set<JComponent> myLightComponents = new HashSet<JComponent>();
    private final JComponent myPanel;
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);

    public GlassPanel(JComponent containingPanel) {
        this.myPanel = containingPanel;
        this.setVisible(false);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paintSpotlights(g);
    }

    protected void paintSpotlights(Graphics g) {
        this.paintSpotlight(g, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintSpotlight(Graphics g, JComponent surfaceComponent) {
        Dimension size = surfaceComponent.getSize();
        if (this.myLightComponents.size() > 0) {
            int stroke = 2;
            Rectangle visibleRect = this.myPanel.getVisibleRect();
            Point leftPoint = SwingUtilities.convertPoint(this.myPanel, new Point(visibleRect.x, visibleRect.y), surfaceComponent);
            Area innerPanel = new Area(new Rectangle2D.Double(leftPoint.x, leftPoint.y, visibleRect.width, visibleRect.height));
            Area mask = new Area(new Rectangle(-stroke, -stroke, 2 * stroke + size.width, 2 * stroke + size.height));
            for (JComponent lightComponent : this.myLightComponents) {
                Area labelForArea;
                JLabel label2;
                Component labelFor;
                Area area = this.getComponentArea(surfaceComponent, lightComponent, 1);
                if (area == null) continue;
                if (lightComponent instanceof JLabel && (labelFor = (label2 = (JLabel)lightComponent).getLabelFor()) instanceof JComponent && (labelForArea = this.getComponentArea(surfaceComponent, (JComponent)labelFor, 1)) != null) {
                    area.add(labelForArea);
                }
                area.intersect(innerPanel);
                mask.subtract(area);
            }
            Graphics clip = g.create(0, 0, size.width, size.height);
            try {
                Graphics2D g2 = (Graphics2D)clip;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                Color background = surfaceComponent.getBackground();
                g2.setColor(ColorUtil.toAlpha((Color)(background == null ? null : background.darker()), (int)100));
                g2.fill(mask);
                g2.setStroke(new BasicStroke(stroke));
                g2.setColor(ColorUtil.toAlpha((Color)JBColor.ORANGE, (int)100));
                g2.draw(mask);
            }
            finally {
                clip.dispose();
            }
        }
    }

    @Nullable
    private Area getComponentArea(JComponent surfaceComponent, JComponent lightComponent, int offset) {
        if (!lightComponent.isShowing()) {
            return null;
        }
        Point panelPoint = SwingUtilities.convertPoint(lightComponent, new Point(0, 0), surfaceComponent);
        int x = panelPoint.x;
        int y = panelPoint.y;
        Insets insetsToIgnore = lightComponent.getInsets();
        boolean isWithBorder = Boolean.TRUE.equals(lightComponent.getClientProperty("searchUtil.highlightWithBorder"));
        boolean isLabelFromTabbedPane = Boolean.TRUE.equals(lightComponent.getClientProperty("JBTabbedPane.labelFromTabbedPane"));
        if (insetsToIgnore == null || UIUtil.isUnderAquaLookAndFeel() && lightComponent instanceof JButton || isWithBorder) {
            insetsToIgnore = EMPTY_INSETS;
        }
        int hInset = this.getComponentHInset(isWithBorder, isLabelFromTabbedPane);
        int vInset = this.getComponentVInset(isWithBorder, isLabelFromTabbedPane);
        int xCoord = x - (hInset += offset) + insetsToIgnore.left;
        int yCoord = y - (vInset += offset) + insetsToIgnore.top;
        int width = lightComponent.getWidth() + hInset * 2 - insetsToIgnore.right - insetsToIgnore.left;
        int height = lightComponent.getHeight() + vInset * 2 - insetsToIgnore.top - insetsToIgnore.bottom;
        return new Area(new RoundRectangle2D.Double(xCoord, yCoord, width, height, Math.min(height, 30), Math.min(height, 30)));
    }

    protected int getComponentHInset(boolean isWithBorder, boolean isLabelFromTabbedPane) {
        return isWithBorder ? 7 : (isLabelFromTabbedPane ? 20 : 7);
    }

    protected int getComponentVInset(boolean isWithBorder, boolean isLabelFromTabbedPane) {
        return isWithBorder ? 1 : (isLabelFromTabbedPane ? 10 : 5);
    }

    protected static Kernel getBlurKernel(int blurSize) {
        if (blurSize <= 0) {
            return null;
        }
        int size = blurSize * blurSize;
        float coeff = 1.0f / (float)size;
        float[] kernelData = new float[size];
        for (int i = 0; i < size; ++i) {
            kernelData[i] = coeff;
        }
        return new Kernel(blurSize, blurSize, kernelData);
    }

    public static double getArea(JComponent component) {
        return Math.PI * (double)component.getWidth() * (double)component.getHeight() / 4.0;
    }

    public void addSpotlight(JComponent component) {
        this.myLightComponents.add(component);
        this.setVisible(true);
    }

    public void removeSpotlight(JComponent component) {
        this.myLightComponents.remove(component);
        if (this.myLightComponents.isEmpty()) {
            this.setVisible(false);
        }
    }

    public void clear() {
        this.myLightComponents.clear();
        this.setVisible(false);
    }
}

