/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolderImpl;
import com.intellij.configurationStore.SchemeExtensionProvider;
import com.intellij.configurationStore.SchemeManagerImpl$deleteFiles$;
import com.intellij.configurationStore.SchemeManagerImpl$removeDirectoryIfEmpty$;
import com.intellij.configurationStore.SchemeManagerImpl$saveScheme$;
import com.intellij.configurationStore.SchemeManagerImplKt;
import com.intellij.configurationStore.SchemeNameToFileName;
import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.schemeManager.ExternalInfo;
import com.intellij.configurationStore.schemeManager.SchemeListManager;
import com.intellij.configurationStore.schemeManager.SchemeLoaderKt;
import com.intellij.configurationStore.schemeManager.SchemeManagerBase;
import com.intellij.ide.ui.UITheme;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.options.NonLazySchemeProcessor;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.JdomKt;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashSet;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0003\n\u0002\b\f\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u0002H\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00042\u00020\u0005B\u0082\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012-\b\u0002\u0010\u0013\u001a'\u0012\u001b\u0012\u0019\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0000\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010S\u001a\u00020\u00182\u0006\u0010T\u001a\u00028\u00002\u0006\u0010U\u001a\u000203H\u0016\u00a2\u0006\u0002\u0010VJ\u000e\u0010W\u001a\u0002032\u0006\u0010\u0016\u001a\u00020XJ$\u0010Y\u001a\u00020\u00182\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\\0[2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00070+H\u0002J\u0017\u0010]\u001a\u0004\u0018\u00018\u00002\u0006\u0010^\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010_J\u0018\u0010`\u001a\u00020\u00072\u0006\u0010a\u001a\u00020X2\u0006\u0010b\u001a\u000203H\u0002J\u0019\u0010c\u001a\u0004\u0018\u00010\u00072\u0006\u0010T\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\bd\u0010eJ'\u0010f\u001a\u0002032\b\u0010g\u001a\u0004\u0018\u00010I2\u0006\u0010h\u001a\u00020i2\u0006\u0010T\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010jJ\u0015\u0010k\u001a\u0002032\u0006\u0010T\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010lJ\u0015\u0010m\u001a\u0002032\u0006\u0010n\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010lJ\u0015\u0010o\u001a\u0002032\u0006\u0010T\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010lJ\u0018\u0010p\u001a\u00020\u00182\u0006\u0010q\u001a\u00020\u00072\u0006\u0010r\u001a\u00020\u0002H\u0016JA\u0010s\u001a\u0004\u0018\u00018\u00012\u0006\u0010a\u001a\u00020\u00072\u0006\u0010t\u001a\u00020u2\f\u0010L\u001a\b\u0012\u0004\u0012\u00028\u00000[2\u0010\b\u0002\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010+H\u0000\u00a2\u0006\u0004\bv\u0010wJ\u000e\u0010x\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0016J\b\u0010y\u001a\u00020\u0018H\u0002J\b\u0010z\u001a\u00020\u0018H\u0016J\u0016\u0010{\u001a\u00020\u00182\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\\0[H\u0002J\r\u0010|\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b}J\u0015\u0010~\u001a\u0002032\u0006\u0010T\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010lJ\u0017\u0010~\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0016\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010_J\u000e\u0010\u007f\u001a\u00020\u0018H\u0000\u00a2\u0006\u0003\b\u0080\u0001J\u0017\u0010\u0081\u0001\u001a\u00020\u00182\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\\0[H\u0016J!\u0010\u0082\u0001\u001a\u00020\u00182\u0006\u0010T\u001a\u00028\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0002\u00a2\u0006\u0003\u0010\u0085\u0001J\u0018\u0010\u0086\u0001\u001a\u00020\u00182\u0007\u0010\u0087\u0001\u001a\u00020IH\u0000\u00a2\u0006\u0003\b\u0088\u0001J;\u0010\u0089\u0001\u001a\u00020\u00182\r\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f2\t\u0010\u008b\u0001\u001a\u0004\u0018\u00018\u00002\u0010\u0010\u008c\u0001\u001a\u000b\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u008d\u0001H\u0016\u00a2\u0006\u0003\u0010\u008e\u0001J\t\u0010\u008f\u0001\u001a\u00020\u0007H\u0016J\r\u0010\u0086\u0001\u001a\u00020\u0018*\u00020IH\u0002R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R3\u0010\u0013\u001a'\u0012\u001b\u0012\u0019\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0000\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R6\u0010*\u001a$\u0012\f\u0012\n ,*\u0004\u0018\u00010\u00070\u0007 ,*\u0010\u0012\f\u0012\n ,*\u0004\u0018\u00010\u00070\u00070-0+X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0014\u00102\u001a\u0002038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00104R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\u000203X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00104R\u000e\u00109\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010)R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0014\u0010=\u001a\u00020>8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0014\u0010A\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010)R\u001a\u0010C\u001a\b\u0012\u0004\u0012\u00028\u00000DX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010G\u001a\u001e\u0012\f\u0012\n ,*\u0004\u0018\u00018\u00008\u0000\u0012\f\u0012\n ,*\u0004\u0018\u00010I0I0HX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010KR\u001a\u0010L\u001a\b\u0012\u0004\u0012\u00028\u00000M8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010OR\u000e\u0010P\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010Q\u001a\u0004\u0018\u00010#8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010%\u00a8\u0006\u0090\u0001"}, d2={"Lcom/intellij/configurationStore/SchemeManagerImpl;", "T", "", "MUTABLE_SCHEME", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerBase;", "Lcom/intellij/openapi/vfs/SafeWriteRequestor;", "fileSpec", "", "processor", "Lcom/intellij/openapi/options/SchemeProcessor;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "ioDirectory", "Ljava/nio/file/Path;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "presentableName", "schemeNameToFileName", "Lcom/intellij/configurationStore/SchemeNameToFileName;", "fileChangeSubscriber", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "schemeManager", "", "(Ljava/lang/String;Lcom/intellij/openapi/options/SchemeProcessor;Lcom/intellij/configurationStore/StreamProvider;Ljava/nio/file/Path;Lcom/intellij/openapi/components/RoamingType;Ljava/lang/String;Lcom/intellij/configurationStore/SchemeNameToFileName;Lkotlin/jvm/functions/Function1;)V", "allSchemeNames", "", "getAllSchemeNames", "()Ljava/util/Collection;", "allSchemes", "", "getAllSchemes", "()Ljava/util/List;", "cachedVirtualDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCachedVirtualDirectory$intellij_platform_configurationStore_impl", "()Lcom/intellij/openapi/vfs/VirtualFile;", "setCachedVirtualDirectory$intellij_platform_configurationStore_impl", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFileSpec", "()Ljava/lang/String;", "filesToDelete", "", "kotlin.jvm.PlatformType", "", "getFilesToDelete$intellij_platform_configurationStore_impl", "()Ljava/util/Set;", "getIoDirectory$intellij_platform_configurationStore_impl", "()Ljava/nio/file/Path;", "isEmpty", "", "()Z", "isLoadingSchemes", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isOldSchemeNaming", "isOldSchemeNaming$intellij_platform_configurationStore_impl", "isUseVfs", "getPresentableName", "getRoamingType", "()Lcom/intellij/openapi/components/RoamingType;", "rootDirectory", "Ljava/io/File;", "getRootDirectory", "()Ljava/io/File;", "schemeExtension", "getSchemeExtension$intellij_platform_configurationStore_impl", "schemeListManager", "Lcom/intellij/configurationStore/schemeManager/SchemeListManager;", "getSchemeListManager$intellij_platform_configurationStore_impl", "()Lcom/intellij/configurationStore/schemeManager/SchemeListManager;", "schemeToInfo", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/configurationStore/schemeManager/ExternalInfo;", "getSchemeToInfo$intellij_platform_configurationStore_impl", "()Ljava/util/concurrent/ConcurrentMap;", "schemes", "Lcom/intellij/util/containers/ConcurrentList;", "getSchemes$intellij_platform_configurationStore_impl", "()Lcom/intellij/util/containers/ConcurrentList;", "updateExtension", "virtualDirectory", "getVirtualDirectory$intellij_platform_configurationStore_impl", "addScheme", "scheme", "replaceExisting", "(Ljava/lang/Object;Z)V", "canRead", "", "deleteFiles", "errors", "", "", "findSchemeByName", "schemeName", "(Ljava/lang/String;)Ljava/lang/Object;", "getFileExtension", "fileName", "allowAny", "getFileName", "getFileName$intellij_platform_configurationStore_impl", "(Ljava/lang/Object;)Ljava/lang/String;", "isEqualToBundledScheme", "externalInfo", "newDigest", "", "(Lcom/intellij/configurationStore/schemeManager/ExternalInfo;[BLjava/lang/Object;)Z", "isMetadataEditable", "(Ljava/lang/Object;)Z", "isOverwriteOnLoad", "existingScheme", "isRenamed", "loadBundledScheme", "resourceName", "requestor", "loadScheme", "input", "Ljava/io/InputStream;", "loadScheme$intellij_platform_configurationStore_impl", "(Ljava/lang/String;Ljava/io/InputStream;Ljava/util/List;Ljava/util/Set;)Ljava/lang/Object;", "loadSchemes", "refreshVirtualDirectory", "reload", "removeDirectoryIfEmpty", "removeExternalizableSchemes", "removeExternalizableSchemes$intellij_platform_configurationStore_impl", "removeScheme", "retainExternalInfo", "retainExternalInfo$intellij_platform_configurationStore_impl", "save", "saveScheme", "nameGenerator", "Lcom/intellij/util/text/UniqueNameGenerator;", "(Ljava/lang/Object;Lcom/intellij/util/text/UniqueNameGenerator;)V", "scheduleDelete", "info", "scheduleDelete$intellij_platform_configurationStore_impl", "setSchemes", "newSchemes", "newCurrentScheme", "removeCondition", "Lcom/intellij/openapi/util/Condition;", "(Ljava/util/List;Ljava/lang/Object;Lcom/intellij/openapi/util/Condition;)V", "toString", "intellij.platform.configurationStore.impl"})
public final class SchemeManagerImpl<T, MUTABLE_SCHEME extends T>
extends SchemeManagerBase<T, MUTABLE_SCHEME>
implements SafeWriteRequestor {
    private final boolean isUseVfs;
    private final boolean isOldSchemeNaming;
    private final AtomicBoolean isLoadingSchemes;
    @NotNull
    private final SchemeListManager<T> schemeListManager;
    @Nullable
    private VirtualFile cachedVirtualDirectory;
    @NotNull
    private final String schemeExtension;
    private final boolean updateExtension;
    @NotNull
    private final Set<String> filesToDelete;
    @NotNull
    private final ConcurrentMap<T, ExternalInfo> schemeToInfo;
    @NotNull
    private final String fileSpec;
    private final StreamProvider provider;
    @NotNull
    private final Path ioDirectory;
    @NotNull
    private final RoamingType roamingType;
    @Nullable
    private final String presentableName;
    private final SchemeNameToFileName schemeNameToFileName;
    private final Function1<SchemeManagerImpl<?, ?>, Unit> fileChangeSubscriber;

    public final boolean isOldSchemeNaming$intellij_platform_configurationStore_impl() {
        return this.isOldSchemeNaming;
    }

    @NotNull
    public final SchemeListManager<T> getSchemeListManager$intellij_platform_configurationStore_impl() {
        return this.schemeListManager;
    }

    @NotNull
    public final ConcurrentList<T> getSchemes$intellij_platform_configurationStore_impl() {
        return this.schemeListManager.getSchemes();
    }

    @Nullable
    public final VirtualFile getCachedVirtualDirectory$intellij_platform_configurationStore_impl() {
        return this.cachedVirtualDirectory;
    }

    public final void setCachedVirtualDirectory$intellij_platform_configurationStore_impl(@Nullable VirtualFile virtualFile) {
        this.cachedVirtualDirectory = virtualFile;
    }

    @NotNull
    public final String getSchemeExtension$intellij_platform_configurationStore_impl() {
        return this.schemeExtension;
    }

    @NotNull
    public final Set<String> getFilesToDelete$intellij_platform_configurationStore_impl() {
        return this.filesToDelete;
    }

    @NotNull
    public final ConcurrentMap<T, ExternalInfo> getSchemeToInfo$intellij_platform_configurationStore_impl() {
        return this.schemeToInfo;
    }

    @Override
    @NotNull
    public File getRootDirectory() {
        File file2 = this.ioDirectory.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"ioDirectory.toFile()");
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<String> getAllSchemeNames() {
        List list2;
        Collection $receiver$iv = (Collection)this.getSchemes$intellij_platform_configurationStore_impl();
        int size$iv = $receiver$iv.size();
        switch (size$iv) {
            case 1: {
                void it;
                SmartList smartList;
                Object object = CollectionsKt.first((Iterable)$receiver$iv);
                SmartList smartList2 = smartList;
                SmartList smartList3 = smartList;
                SchemeProcessor schemeProcessor = this.getProcessor$intellij_platform_configurationStore_impl();
                void v2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                String string = schemeProcessor.getSchemeKey(v2);
                smartList2((Object)string);
                list2 = (List)smartList3;
                break;
            }
            case 0: {
                list2 = CollectionsKt.emptyList();
                break;
            }
            default: {
                void $receiver$iv$iv;
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(size$iv);
                Iterator iterator = $receiver$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object item$iv$iv;
                    Object it = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    SchemeProcessor schemeProcessor = this.getProcessor$intellij_platform_configurationStore_impl();
                    Object t = it;
                    Intrinsics.checkExpressionValueIsNotNull(t, (String)"it");
                    String string = schemeProcessor.getSchemeKey(t);
                    collection.add(string);
                }
                list2 = (List)destination$iv$iv;
            }
        }
        return list2;
    }

    @Override
    @NotNull
    public List<T> getAllSchemes() {
        List list2 = Collections.unmodifiableList((List)this.getSchemes$intellij_platform_configurationStore_impl());
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Collections.unmodifiableList(schemes)");
        return list2;
    }

    @Override
    public boolean isEmpty() {
        return this.getSchemes$intellij_platform_configurationStore_impl().isEmpty();
    }

    private final void refreshVirtualDirectory() {
        VirtualFile directory;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(PathKt.getSystemIndependentPath((Path)this.ioDirectory));
        if (virtualFile == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026ndependentPath) ?: return");
        this.cachedVirtualDirectory = directory = virtualFile;
        directory.getChildren();
        if (directory instanceof NewVirtualFile) {
            ((NewVirtualFile)directory).markDirty();
        }
        directory.refresh(true, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void loadBundledScheme(@NotNull String resourceName, @NotNull Object requestor) {
        Intrinsics.checkParameterIsNotNull((Object)resourceName, (String)"resourceName");
        Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
        try {
            ExternalInfo externalInfo;
            void parser;
            URL url;
            Object object = requestor;
            URL uRL = object instanceof AbstractExtensionPointBean ? ((AbstractExtensionPointBean)requestor).getLoaderForClass().getResource(resourceName) : (url = object instanceof UITheme ? DecodeDefaultsUtil.getDefaults(((UITheme)requestor).getProviderClassLoader(), resourceName) : DecodeDefaultsUtil.getDefaults(requestor, resourceName));
            if (url == null) {
                ComponentStoreImplKt.getLOG().error("Cannot read scheme from " + resourceName);
                return;
            }
            InputStream inputStream = URLUtil.openStream((URL)url);
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"URLUtil.openStream(url)");
            byte[] bytes = ByteStreamsKt.readBytes$default((InputStream)inputStream, (int)0, (int)1, null);
            boolean isOldSchemeNaming$iv = this.isOldSchemeNaming;
            MXParser parser$iv = new MXParser();
            Object object2 = bytes;
            MXParser mXParser = parser$iv;
            Closeable closeable = new ByteArrayInputStream((byte[])object2);
            object2 = closeable;
            Charset charset = Charsets.UTF_8;
            closeable = new InputStreamReader((InputStream)object2, charset);
            mXParser.setInput((Reader)closeable);
            XmlPullParser xmlPullParser = (XmlPullParser)parser$iv;
            String name = SchemeLoaderKt.access$preload(isOldSchemeNaming$iv, parser$iv);
            Function attributeProvider2 = new Function<String, String>((XmlPullParser)parser){
                final /* synthetic */ XmlPullParser $parser;

                public final String apply(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.$parser.getAttributeValue(null, it);
                }
                {
                    this.$parser = xmlPullParser;
                }
            };
            String string = PathUtilRt.getFileName((String)url.getPath());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtilRt.getFileName(url.path)");
            String fileName = string;
            String extension = this.getFileExtension(fileName, true);
            String string2 = fileName;
            int n = 0;
            int n2 = fileName.length() - extension.length();
            ExternalInfo externalInfo2 = externalInfo;
            ExternalInfo externalInfo3 = externalInfo;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string5 = string4;
            externalInfo2(string5, extension);
            ExternalInfo externalInfo4 = externalInfo3;
            String string6 = name;
            if (string6 == null) {
                SchemeProcessor schemeProcessor = this.getProcessor$intellij_platform_configurationStore_impl();
                if (schemeProcessor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.LazySchemeProcessor<T, MUTABLE_SCHEME>");
                }
                string6 = ((LazySchemeProcessor)schemeProcessor).getSchemeKey(attributeProvider2, externalInfo4.getFileNameWithoutExtension());
            }
            if (string6 == null) {
                throw (Throwable)SchemeManagerImplKt.nameIsMissed(bytes);
            }
            String schemeKey = string6;
            externalInfo4.setSchemeKey(schemeKey);
            SchemeProcessor schemeProcessor = this.getProcessor$intellij_platform_configurationStore_impl();
            if (schemeProcessor == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.LazySchemeProcessor<T, MUTABLE_SCHEME>");
            }
            Object scheme2 = ((LazySchemeProcessor)schemeProcessor).createScheme(new SchemeDataHolderImpl(this.getProcessor$intellij_platform_configurationStore_impl(), bytes, externalInfo4), schemeKey, attributeProvider2, true);
            ExternalInfo oldInfo = this.schemeToInfo.put(scheme2, externalInfo4);
            ComponentStoreImplKt.getLOG().assertTrue(oldInfo == null);
            Object oldScheme = this.schemeListManager.getReadOnlyExternalizableSchemes().put(schemeKey, scheme2);
            if (oldScheme != null) {
                ComponentStoreImplKt.getLOG().warn("Duplicated scheme " + schemeKey + " - old: " + oldScheme + ", new " + scheme2);
            }
            this.getSchemes$intellij_platform_configurationStore_impl().add(scheme2);
            if (requestor instanceof UITheme) {
                ((UITheme)requestor).setEditorSchemeName(schemeKey);
            }
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error("Cannot read scheme from " + resourceName, e);
        }
    }

    private final String getFileExtension(CharSequence fileName, boolean allowAny) {
        String string;
        if (StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)this.schemeExtension)) {
            string = this.schemeExtension;
        } else if (StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".xml")) {
            string = ".xml";
        } else if (allowAny) {
            String string2 = PathUtil.getFileExtension((String)((Object)fileName).toString());
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PathUtil.getFileExtension(fileName.toString())!!");
        } else {
            throw (Throwable)new IllegalStateException("Scheme file extension " + fileName + " is unknown, must be filtered out");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<T> loadSchemes() {
        if (!this.isLoadingSchemes.compareAndSet(false, true)) {
            throw (Throwable)new IllegalStateException("loadSchemes is already called");
        }
        try {
            THashSet filesToDelete = new THashSet();
            ConcurrentList<T> oldSchemes = this.getSchemes$intellij_platform_configurationStore_impl();
            List schemes = CollectionsKt.toMutableList((Collection)((Collection)oldSchemes));
            int newSchemesOffset = schemes.size();
            if (this.provider == null || !this.provider.processChildren(this.fileSpec, this.roamingType, (Function1)new Function1<String, Boolean>(this){
                final /* synthetic */ SchemeManagerImpl this$0;

                public final boolean invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.this$0.canRead(it);
                }
                {
                    this.this$0 = schemeManagerImpl;
                    super(1);
                }
            }, (Function3)new Function3<String, InputStream, Boolean, Boolean>(this, schemes, filesToDelete){
                final /* synthetic */ SchemeManagerImpl this$0;
                final /* synthetic */ List $schemes;
                final /* synthetic */ THashSet $filesToDelete;

                public final boolean invoke(@NotNull String name, @NotNull InputStream input, boolean readOnly) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                    try {
                        String it = name;
                        MUTABLE_SCHEME scheme2 = this.this$0.loadScheme$intellij_platform_configurationStore_impl(name, input, this.$schemes, (Set)this.$filesToDelete);
                        if (readOnly && scheme2 != null) {
                            this.this$0.getSchemeListManager$intellij_platform_configurationStore_impl().getReadOnlyExternalizableSchemes().put(this.this$0.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(scheme2), scheme2);
                        }
                    }
                    catch (Throwable e$iv) {
                        ComponentStoreImplKt.getLOG().error("Cannot read scheme " + name, e$iv);
                    }
                    return true;
                }
                {
                    this.this$0 = schemeManagerImpl;
                    this.$schemes = list2;
                    this.$filesToDelete = tHashSet;
                    super(3);
                }
            })) {
                Path path = this.ioDirectory;
                Function1 filter$iv = (Function1)new Function1<Path, Boolean>(this){
                    final /* synthetic */ SchemeManagerImpl this$0;

                    public final boolean invoke(@NotNull Path it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return this.this$0.canRead(((Object)it.getFileName()).toString());
                    }
                    {
                        this.this$0 = schemeManagerImpl;
                        super(1);
                    }
                };
                try {
                    void $receiver$iv;
                    Closeable closeable = Files.newDirectoryStream((Path)$receiver$iv, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(filter$iv){
                        final /* synthetic */ Function1 $filter;
                        {
                            this.$filter = function1;
                        }

                        public final boolean accept(Path it) {
                            Path path = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it");
                            return (Boolean)this.$filter.invoke((Object)path);
                        }
                    });
                    Throwable throwable = null;
                    try {
                        DirectoryStream directoryStream = (DirectoryStream)closeable;
                        Iterator iterator = directoryStream.iterator();
                        while (iterator.hasNext()) {
                            Path file2;
                            Path path2 = file2 = (Path)iterator.next();
                            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file");
                            if (PathKt.isDirectory((Path)path2)) continue;
                            String fileName$iv = ((Object)file2.getFileName()).toString();
                            try {
                                String filename = fileName$iv;
                                Closeable closeable2 = PathKt.inputStream((Path)file2);
                                Throwable throwable2 = null;
                                try {
                                    InputStream it = (InputStream)closeable2;
                                    MUTABLE_SCHEME MUTABLE_SCHEME = this.loadScheme$intellij_platform_configurationStore_impl(filename, it, schemes, (Set)filesToDelete);
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                                }
                            }
                            catch (Throwable e$iv) {
                                ComponentStoreImplKt.getLOG().error("Cannot read scheme " + fileName$iv, e$iv);
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (NoSuchFileException noSuchFileException) {
                }
            }
            this.filesToDelete.addAll((Collection)filesToDelete);
            this.schemeListManager.replaceSchemeList(oldSchemes, schemes);
            int $receiver$iv = newSchemesOffset;
            int n = schemes.size();
            while ($receiver$iv < n) {
                Object scheme2;
                void i;
                if (schemes.get((int)i) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type MUTABLE_SCHEME");
                }
                this.getProcessor$intellij_platform_configurationStore_impl().initScheme(scheme2);
                this.processPendingCurrentSchemeName$intellij_platform_configurationStore_impl(scheme2);
                ++i;
            }
            Function1<SchemeManagerImpl<?, ?>, Unit> function1 = this.fileChangeSubscriber;
            if (function1 != null) {
                Unit cfr_ignored_0 = (Unit)function1.invoke((Object)this);
            }
            Collection collection = schemes.subList(newSchemesOffset, schemes.size());
            return collection;
        }
        finally {
            this.isLoadingSchemes.set(false);
        }
    }

    @Override
    public void reload() {
        this.getProcessor$intellij_platform_configurationStore_impl().beforeReloaded(this);
        this.removeExternalizableSchemes$intellij_platform_configurationStore_impl();
        this.getProcessor$intellij_platform_configurationStore_impl().reloaded(this, this.loadSchemes());
    }

    public final void removeExternalizableSchemes$intellij_platform_configurationStore_impl() {
        Iterator iterator;
        Iterator<Object> iterator2;
        Iterator iterator3 = iterator2 = (iterator = this.getSchemes$intellij_platform_configurationStore_impl().iterator());
        while (iterator3.hasNext()) {
            Iterator<Object> it;
            Object object;
            Object scheme2 = iterator3.next();
            Object e = scheme2;
            if (!(e instanceof SerializableScheme)) {
                e = null;
            }
            if ((object = (SerializableScheme)e) == null || (object = object.getSchemeState()) == null) {
                SchemeProcessor schemeProcessor = this.getProcessor$intellij_platform_configurationStore_impl();
                Object e2 = scheme2;
                Intrinsics.checkExpressionValueIsNotNull(e2, (String)"scheme");
                object = schemeProcessor.getState(e2);
            }
            if (object == SchemeState.NON_PERSISTENT) continue;
            if (this.getActiveScheme() != null && scheme2 == (it = iterator2)) {
                this.setCurrentPendingSchemeName$intellij_platform_configurationStore_impl(this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(it));
                this.setActiveScheme$intellij_platform_configurationStore_impl(null);
            }
            iterator.remove();
            Object e3 = scheme2;
            if (e3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type MUTABLE_SCHEME");
            }
            this.getProcessor$intellij_platform_configurationStore_impl().onSchemeDeleted(e3);
        }
        this.retainExternalInfo$intellij_platform_configurationStore_impl();
    }

    private final boolean isOverwriteOnLoad(T existingScheme) {
        ExternalInfo info = (ExternalInfo)this.schemeToInfo.get(existingScheme);
        return info != null && Intrinsics.areEqual((Object)this.schemeExtension, (Object)info.getFileExtension()) ^ true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MUTABLE_SCHEME loadScheme$intellij_platform_configurationStore_impl(@NotNull String fileName, @NotNull InputStream input, @NotNull List<T> schemes, @Nullable Set<String> filesToDelete) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull(schemes, (String)"schemes");
        String extension = this.getFileExtension(fileName, false);
        if (filesToDelete != null && filesToDelete.contains(fileName)) {
            ComponentStoreImplKt.getLOG().warn("Scheme file \"" + fileName + "\" is not loaded because marked to delete");
            return null;
        }
        String string = fileName;
        int n = 0;
        int n2 = fileName.length() - extension.length();
        String string2 = string.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String fileNameWithoutExtension = string2;
        Function1<String, Boolean> checkExisting$ = new Function1<String, Boolean>(this, filesToDelete, schemes, extension, fileNameWithoutExtension, fileName){
            final /* synthetic */ SchemeManagerImpl this$0;
            final /* synthetic */ Set $filesToDelete;
            final /* synthetic */ List $schemes;
            final /* synthetic */ String $extension;
            final /* synthetic */ String $fileNameWithoutExtension;
            final /* synthetic */ String $fileName;

            /*
             * Enabled aggressive block sorting
             */
            public final boolean invoke(@NotNull String schemeName) {
                SCHEME SCHEME;
                SCHEME SCHEME2;
                block6: {
                    Intrinsics.checkParameterIsNotNull((Object)schemeName, (String)"schemeName");
                    if (this.$filesToDelete == null) {
                        return true;
                    }
                    Iterable $receiver$iv = this.$schemes;
                    Iterator<T> iterator = $receiver$iv.iterator();
                    while (iterator.hasNext()) {
                        T element$iv;
                        T it = element$iv = iterator.next();
                        if (!Intrinsics.areEqual((Object)this.this$0.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(it), (Object)schemeName)) continue;
                        SCHEME2 = (SCHEME)element$iv;
                        break block6;
                    }
                    SCHEME2 = null;
                }
                if (SCHEME2 == null) return true;
                SCHEME existingScheme = SCHEME = SCHEME2;
                if (this.this$0.getSchemeListManager$intellij_platform_configurationStore_impl().getReadOnlyExternalizableSchemes().get(this.this$0.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(existingScheme)) == existingScheme) {
                    this.this$0.getSchemeListManager$intellij_platform_configurationStore_impl().removeFirstScheme(this.$schemes, false, (Function1)new Function1<T, Boolean>(existingScheme){
                        final /* synthetic */ Object $existingScheme;

                        public final boolean invoke(@NotNull T it) {
                            Intrinsics.checkParameterIsNotNull(it, (String)"it");
                            return it == this.$existingScheme;
                        }
                        {
                            this.$existingScheme = object;
                            super(1);
                        }
                    });
                    return true;
                }
                if (this.this$0.getProcessor$intellij_platform_configurationStore_impl().isExternalizable(existingScheme) && SchemeManagerImpl.access$isOverwriteOnLoad(this.this$0, existingScheme)) {
                    SchemeListManager.removeFirstScheme$default(this.this$0.getSchemeListManager$intellij_platform_configurationStore_impl(), this.$schemes, false, (Function1)new Function1<T, Boolean>(existingScheme){
                        final /* synthetic */ Object $existingScheme;

                        public final boolean invoke(@NotNull T it) {
                            Intrinsics.checkParameterIsNotNull(it, (String)"it");
                            return it == this.$existingScheme;
                        }
                        {
                            this.$existingScheme = object;
                            super(1);
                        }
                    }, 2, null);
                    return true;
                }
                if (Intrinsics.areEqual((Object)this.this$0.getSchemeExtension$intellij_platform_configurationStore_impl(), (Object)this.$extension) ^ true) {
                    ExternalInfo externalInfo = (ExternalInfo)this.this$0.getSchemeToInfo$intellij_platform_configurationStore_impl().get(existingScheme);
                    if (Intrinsics.areEqual((Object)(externalInfo != null ? externalInfo.getFileNameWithoutExtension() : null), (Object)this.$fileNameWithoutExtension)) {
                        this.$filesToDelete.add(this.$fileName);
                        return false;
                    }
                }
                ComponentStoreImplKt.getLOG().warn("Scheme file \"" + this.$fileName + "\" is not loaded because defines duplicated name \"" + schemeName + '\"');
                return false;
            }
            {
                this.this$0 = schemeManagerImpl;
                this.$filesToDelete = set;
                this.$schemes = list2;
                this.$extension = string;
                this.$fileNameWithoutExtension = string2;
                this.$fileName = string3;
                super(1);
            }
        };
        Function2<String, Element, ExternalInfo> createInfo$ = new Function2<String, Element, ExternalInfo>(fileNameWithoutExtension, extension){
            final /* synthetic */ String $fileNameWithoutExtension;
            final /* synthetic */ String $extension;

            @NotNull
            public final ExternalInfo invoke(@NotNull String schemeName, @Nullable Element element) {
                Intrinsics.checkParameterIsNotNull((Object)schemeName, (String)"schemeName");
                ExternalInfo info = new ExternalInfo(this.$fileNameWithoutExtension, this.$extension);
                Element element2 = element;
                if (element2 != null) {
                    Element element3;
                    Element it = element3 = element2;
                    info.setDigest(Scheme_implKt.digest(it));
                }
                info.setSchemeKey(schemeName);
                return info;
            }
            {
                this.$fileNameWithoutExtension = string;
                this.$extension = string2;
                super(2);
            }
        };
        boolean duringLoad = filesToDelete != null;
        Object scheme2 = null;
        if (this.getProcessor$intellij_platform_configurationStore_impl() instanceof LazySchemeProcessor) {
            void parser;
            byte[] bytes = ByteStreamsKt.readBytes$default((InputStream)input, (int)0, (int)1, null);
            boolean isOldSchemeNaming$iv = this.isOldSchemeNaming;
            MXParser parser$iv = new MXParser();
            Object object = bytes;
            MXParser mXParser = parser$iv;
            Closeable closeable = new ByteArrayInputStream((byte[])object);
            object = closeable;
            Charset charset = Charsets.UTF_8;
            closeable = new InputStreamReader((InputStream)object, charset);
            mXParser.setInput((Reader)closeable);
            XmlPullParser xmlPullParser = (XmlPullParser)parser$iv;
            String name = SchemeLoaderKt.access$preload(isOldSchemeNaming$iv, parser$iv);
            Function attributeProvider2 = new Function<String, String>((XmlPullParser)parser){
                final /* synthetic */ XmlPullParser $parser;

                @Nullable
                public final String apply(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.$parser.getEventType() == 2 ? this.$parser.getAttributeValue(null, it) : null;
                }
                {
                    this.$parser = xmlPullParser;
                }
            };
            String string3 = name;
            if (string3 == null) {
                string3 = ((LazySchemeProcessor)this.getProcessor$intellij_platform_configurationStore_impl()).getSchemeKey(attributeProvider2, fileNameWithoutExtension);
            }
            if (string3 == null) {
                throw (Throwable)SchemeManagerImplKt.nameIsMissed(bytes);
            }
            String schemeName = string3;
            if (!checkExisting$.invoke(schemeName)) {
                return null;
            }
            ExternalInfo externalInfo = createInfo$.invoke(schemeName, null);
            scheme2 = LazySchemeProcessor.createScheme$default((LazySchemeProcessor)this.getProcessor$intellij_platform_configurationStore_impl(), new SchemeDataHolderImpl(this.getProcessor$intellij_platform_configurationStore_impl(), bytes, externalInfo), schemeName, attributeProvider2, false, 8, null);
            this.schemeToInfo.put(scheme2, externalInfo);
            this.filesToDelete.remove(fileName);
        } else {
            String schemeKey;
            Element element = JdomKt.loadElement((InputStream)input);
            SchemeProcessor schemeProcessor = this.getProcessor$intellij_platform_configurationStore_impl();
            if (schemeProcessor == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.options.NonLazySchemeProcessor<T, MUTABLE_SCHEME>");
            }
            Object MUTABLE_SCHEME = ((NonLazySchemeProcessor)schemeProcessor).readScheme(element, duringLoad);
            if (MUTABLE_SCHEME == null) {
                return null;
            }
            scheme2 = MUTABLE_SCHEME;
            SchemeProcessor schemeProcessor2 = this.getProcessor$intellij_platform_configurationStore_impl();
            Object object = scheme2;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            if (!checkExisting$.invoke(schemeKey = schemeProcessor2.getSchemeKey(object))) {
                return null;
            }
            this.schemeToInfo.put(scheme2, createInfo$.invoke(schemeKey, element));
            this.filesToDelete.remove(fileName);
        }
        if (schemes == this.getSchemes$intellij_platform_configurationStore_impl()) {
            Object object = scheme2;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            this.addScheme(object, true);
        } else {
            Object object = scheme2;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            schemes.add(object);
        }
        return (MUTABLE_SCHEME)scheme2;
    }

    @Nullable
    public static /* synthetic */ Object loadScheme$intellij_platform_configurationStore_impl$default(SchemeManagerImpl schemeManagerImpl, String string, InputStream inputStream, List list2, Set set, int n, Object object) {
        if ((n & 8) != 0) {
            set = null;
        }
        return schemeManagerImpl.loadScheme$intellij_platform_configurationStore_impl(string, inputStream, list2, set);
    }

    @Nullable
    public final String getFileName$intellij_platform_configurationStore_impl(@NotNull T scheme2) {
        Intrinsics.checkParameterIsNotNull(scheme2, (String)"scheme");
        ExternalInfo externalInfo = (ExternalInfo)this.schemeToInfo.get(scheme2);
        return externalInfo != null ? externalInfo.getFileNameWithoutExtension() : null;
    }

    public final boolean canRead(@NotNull CharSequence name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return (this.updateExtension && StringsKt.endsWith((CharSequence)name, (CharSequence)".xml", (boolean)true) || StringsKt.endsWith((CharSequence)name, (CharSequence)this.schemeExtension, (boolean)true)) && (!(this.getProcessor$intellij_platform_configurationStore_impl() instanceof LazySchemeProcessor) || ((LazySchemeProcessor)this.getProcessor$intellij_platform_configurationStore_impl()).isSchemeFile(name));
    }

    @Override
    public void save(@NotNull List<Throwable> errors) {
        Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
        if (this.isLoadingSchemes.get()) {
            ComponentStoreImplKt.getLOG().warn("Skip save - schemes are loading");
        }
        boolean hasSchemes = false;
        UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
        SmartList changedSchemes = new SmartList();
        for (Object scheme2 : this.getSchemes$intellij_platform_configurationStore_impl()) {
            Object object;
            Object e = scheme2;
            if (!(e instanceof SerializableScheme)) {
                e = null;
            }
            if ((object = (SerializableScheme)e) == null || (object = object.getSchemeState()) == null) {
                SchemeProcessor schemeProcessor = this.getProcessor$intellij_platform_configurationStore_impl();
                Object e2 = scheme2;
                Intrinsics.checkExpressionValueIsNotNull(e2, (String)"scheme");
                object = schemeProcessor.getState(e2);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"(scheme as? Serializable\u2026rocessor.getState(scheme)");
            Object state = object;
            if (state == SchemeState.NON_PERSISTENT) continue;
            hasSchemes = true;
            if (state != SchemeState.UNCHANGED) {
                Object e3 = scheme2;
                if (e3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type MUTABLE_SCHEME");
                }
                changedSchemes.add(e3);
            }
            Object e4 = scheme2;
            Intrinsics.checkExpressionValueIsNotNull(e4, (String)"scheme");
            String fileName = this.getFileName$intellij_platform_configurationStore_impl(e4);
            if (fileName == null || this.isRenamed(scheme2)) continue;
            nameGenerator.addExistingName(fileName);
        }
        for (Object scheme2 : changedSchemes) {
            try {
                Object e = scheme2;
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"scheme");
                this.saveScheme(e, nameGenerator);
            }
            catch (Throwable e) {
                errors.add(new RuntimeException("Cannot save scheme " + this.fileSpec + '/' + scheme2, e));
            }
        }
        THashSet filesToDelete = new THashSet((Collection)this.filesToDelete);
        if (!filesToDelete.isEmpty()) {
            this.filesToDelete.removeAll((Collection)filesToDelete);
            this.deleteFiles(errors, (Set)filesToDelete);
            if (!(hasSchemes || this.provider != null && this.provider.isApplicable(this.fileSpec, this.roamingType))) {
                this.removeDirectoryIfEmpty(errors);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void removeDirectoryIfEmpty(List<Throwable> errors) {
        void deleteUsingIo;
        DirectoryStream it;
        Closeable closeable;
        Path $receiver$iv = this.ioDirectory;
        try {
            closeable = Files.newDirectoryStream($receiver$iv);
            Throwable throwable = null;
            try {
                it = (DirectoryStream)closeable;
                Iterator iterator = it.iterator();
                while (iterator.hasNext()) {
                    Path file2;
                    Path path = file2 = (Path)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
                    if (PathKt.isHidden((Path)path)) continue;
                    ComponentStoreImplKt.getLOG().info("Directory " + this.ioDirectory.getFileName() + " is not deleted: at least one file " + file2.getFileName() + " exists");
                    return;
                }
                it = Unit.INSTANCE;
            }
            catch (Throwable it2) {
                throwable = it2;
                throw it2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        ComponentStoreImplKt.getLOG().info("Remove schemes directory " + this.ioDirectory.getFileName());
        this.cachedVirtualDirectory = null;
        $receiver$iv = new Ref.BooleanRef();
        boolean bl = ((Ref.BooleanRef)$receiver$iv).element = !this.isUseVfs;
        if (!deleteUsingIo.element) {
            VirtualFile virtualFile = this.getVirtualDirectory$intellij_platform_configurationStore_impl();
            if (virtualFile != null) {
                void result$iv;
                Closeable it3 = closeable = virtualFile;
                it = new Ref.ObjectRef();
                ((Ref.ObjectRef)it).element = null;
                CommandProcessor.getInstance().runUndoTransparentAction(new Runnable((Ref.ObjectRef)result$iv, (VirtualFile)it3, this, (Ref.BooleanRef)deleteUsingIo, errors){
                    final /* synthetic */ Ref.ObjectRef $result;
                    final /* synthetic */ VirtualFile $it$inlined;
                    final /* synthetic */ SchemeManagerImpl this$0;
                    final /* synthetic */ Ref.BooleanRef $deleteUsingIo$inlined;
                    final /* synthetic */ List $errors$inlined;
                    {
                        this.$result = objectRef;
                        this.$it$inlined = virtualFile;
                        this.this$0 = schemeManagerImpl;
                        this.$deleteUsingIo$inlined = booleanRef;
                        this.$errors$inlined = list2;
                    }

                    public final void run() {
                        this.$result.element = ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(this){
                            final /* synthetic */ removeDirectoryIfEmpty$$inlined$let$lambda$1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final T compute() {
                                Object object;
                                try {
                                    this.this$0.$it$inlined.delete((Object)this.this$0.this$0);
                                    object = Unit.INSTANCE;
                                }
                                catch (IOException e) {
                                    this.this$0.$deleteUsingIo$inlined.element = true;
                                    object = this.this$0.$errors$inlined.add(e);
                                }
                                return (T)object;
                            }
                        });
                    }
                });
                Object cfr_ignored_0 = result$iv.element;
            }
        }
        if (deleteUsingIo.element) {
            List<Throwable> $receiver$iv2 = errors;
            try {
                PathKt.delete((Path)this.ioDirectory);
            }
            catch (Throwable e$iv) {
                $receiver$iv2.add(e$iv);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void saveScheme(MUTABLE_SCHEME scheme2, UniqueNameGenerator nameGenerator) {
        boolean renamed;
        String providerPath;
        Element element;
        Element element2;
        ExternalInfo externalInfo;
        ExternalInfo externalInfo2 = externalInfo = (ExternalInfo)this.schemeToInfo.get(scheme2);
        String currentFileNameWithoutExtension = externalInfo2 != null ? externalInfo2.getFileNameWithoutExtension() : null;
        Parent parent = this.getProcessor$intellij_platform_configurationStore_impl().writeScheme(scheme2);
        if (parent != null) {
            Parent parent2 = parent;
            Parent it = parent2;
            Parent parent3 = it;
            if (!(parent3 instanceof Element)) {
                parent3 = null;
            }
            if ((element2 = (Element)parent3) == null) {
                Parent parent4 = it;
                if (parent4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jdom.Document");
                }
                element2 = ((Document)parent4).detachRootElement();
            }
        } else {
            element2 = element = null;
        }
        if (JdomKt.isEmpty(element)) {
            ExternalInfo externalInfo3 = externalInfo;
            if (externalInfo3 != null) {
                this.scheduleDelete(externalInfo3);
            }
            return;
        }
        String fileNameWithoutExtension = currentFileNameWithoutExtension;
        if (fileNameWithoutExtension == null || this.isRenamed(scheme2)) {
            fileNameWithoutExtension = nameGenerator.generateUniqueName(this.schemeNameToFileName.schemeNameToFileName(this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(scheme2)));
        }
        Element element3 = element;
        if (element3 == null) {
            Intrinsics.throwNpe();
        }
        byte[] newDigest = Scheme_implKt.digest(element3);
        if (externalInfo != null && currentFileNameWithoutExtension == fileNameWithoutExtension && externalInfo.isDigestEquals(newDigest)) {
            return;
        }
        if (this.isEqualToBundledScheme(externalInfo, newDigest, scheme2)) {
            return;
        }
        if (this.getProcessor$intellij_platform_configurationStore_impl() instanceof LazySchemeProcessor && ((LazySchemeProcessor)this.getProcessor$intellij_platform_configurationStore_impl()).isSchemeDefault(scheme2, newDigest)) {
            ExternalInfo externalInfo4 = externalInfo;
            if (externalInfo4 != null) {
                this.scheduleDelete(externalInfo4);
            }
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = fileNameWithoutExtension;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String fileName = stringBuilder.append(string).append(this.schemeExtension).toString();
        this.filesToDelete.remove(fileName);
        BufferExposingByteArrayOutputStream byteOut = JdomKt.toBufferExposingByteArray$default((Element)element, null, (int)1, null);
        if (this.provider != null && this.provider.getEnabled()) {
            providerPath = this.fileSpec + '/' + fileName;
            if (!this.provider.isApplicable(providerPath, this.roamingType)) {
                providerPath = null;
            }
        } else {
            providerPath = null;
        }
        boolean bl = renamed = externalInfo != null && fileNameWithoutExtension != currentFileNameWithoutExtension && currentFileNameWithoutExtension != null && nameGenerator.isUnique(currentFileNameWithoutExtension);
        if (providerPath == null) {
            if (this.isUseVfs) {
                void result$iv;
                void file2;
                VirtualFile oldFile;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                VirtualFile dir = this.getVirtualDirectory$intellij_platform_configurationStore_impl();
                if (dir == null || !dir.isValid()) {
                    this.cachedVirtualDirectory = dir = SchemeLoaderKt.createDir(this.ioDirectory, this);
                }
                if (renamed) {
                    ExternalInfo externalInfo5 = externalInfo;
                    if (externalInfo5 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((oldFile = dir.findChild(externalInfo5.getFileName())) != null) {
                        if (dir.findChild(fileName) == null) {
                            void result$iv2;
                            Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
                            objectRef2.element = null;
                            CommandProcessor.getInstance().runUndoTransparentAction(new Runnable((Ref.ObjectRef)result$iv2, this, oldFile, fileName){
                                final /* synthetic */ Ref.ObjectRef $result;
                                final /* synthetic */ SchemeManagerImpl this$0;
                                final /* synthetic */ VirtualFile $oldFile$inlined;
                                final /* synthetic */ String $fileName$inlined;
                                {
                                    this.$result = objectRef;
                                    this.this$0 = schemeManagerImpl;
                                    this.$oldFile$inlined = virtualFile;
                                    this.$fileName$inlined = string;
                                }

                                public final void run() {
                                    this.$result.element = ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(this){
                                        final /* synthetic */ saveScheme$$inlined$runUndoTransparentWriteAction$1 this$0;
                                        {
                                            this.this$0 = var1_1;
                                        }

                                        public final T compute() {
                                            this.this$0.$oldFile$inlined.rename((Object)this.this$0.this$0, this.this$0.$fileName$inlined);
                                            return (T)Unit.INSTANCE;
                                        }
                                    });
                                }
                            });
                            Object cfr_ignored_0 = result$iv2.element;
                            file2.element = oldFile;
                        } else {
                            this.scheduleDelete(externalInfo);
                        }
                    }
                }
                if ((VirtualFile)file2.element == null) {
                    file2.element = SchemeLoaderKt.getOrCreateChild(dir, fileName, this);
                }
                oldFile = new Ref.ObjectRef();
                oldFile.element = null;
                CommandProcessor.getInstance().runUndoTransparentAction(new Runnable((Ref.ObjectRef)result$iv, this, (Ref.ObjectRef)file2, byteOut){
                    final /* synthetic */ Ref.ObjectRef $result;
                    final /* synthetic */ SchemeManagerImpl this$0;
                    final /* synthetic */ Ref.ObjectRef $file$inlined;
                    final /* synthetic */ BufferExposingByteArrayOutputStream $byteOut$inlined;
                    {
                        this.$result = objectRef;
                        this.this$0 = schemeManagerImpl;
                        this.$file$inlined = objectRef2;
                        this.$byteOut$inlined = bufferExposingByteArrayOutputStream;
                    }

                    public final void run() {
                        this.$result.element = ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(this){
                            final /* synthetic */ saveScheme$$inlined$runUndoTransparentWriteAction$2 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final T compute() {
                                Closeable closeable = ((VirtualFile)this.this$0.$file$inlined.element).getOutputStream((Object)this.this$0.this$0);
                                Throwable throwable = null;
                                try {
                                    OutputStream it = (OutputStream)closeable;
                                    this.this$0.$byteOut$inlined.writeTo(it);
                                    Unit unit = Unit.INSTANCE;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                }
                                return (T)Unit.INSTANCE;
                            }
                        });
                    }
                });
                Object cfr_ignored_1 = result$iv.element;
            } else {
                if (renamed) {
                    ExternalInfo externalInfo6 = externalInfo;
                    if (externalInfo6 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.scheduleDelete(externalInfo6);
                }
                Path path = this.ioDirectory.resolve(fileName);
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"ioDirectory.resolve(fileName)");
                byte[] byArray = byteOut.getInternalBuffer();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"byteOut.internalBuffer");
                PathKt.write((Path)path, (byte[])byArray, (int)0, (int)byteOut.size());
            }
        } else {
            if (renamed) {
                ExternalInfo externalInfo7 = externalInfo;
                if (externalInfo7 == null) {
                    Intrinsics.throwNpe();
                }
                this.scheduleDelete(externalInfo7);
            }
            StreamProvider streamProvider = this.provider;
            if (streamProvider == null) {
                Intrinsics.throwNpe();
            }
            byte[] byArray = byteOut.getInternalBuffer();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"byteOut.internalBuffer");
            streamProvider.write(providerPath, byArray, byteOut.size(), this.roamingType);
        }
        if (externalInfo == null) {
            externalInfo = new ExternalInfo(fileNameWithoutExtension, this.schemeExtension);
            this.schemeToInfo.put(scheme2, externalInfo);
        } else {
            externalInfo.setFileNameWithoutExtension(fileNameWithoutExtension, this.schemeExtension);
        }
        externalInfo.setDigest(newDigest);
        externalInfo.setSchemeKey(this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(scheme2));
    }

    private final boolean isEqualToBundledScheme(ExternalInfo externalInfo, byte[] newDigest, MUTABLE_SCHEME scheme2) {
        Function1 serializeIfPossible$ = new Function1<T, Element>(this){
            final /* synthetic */ SchemeManagerImpl this$0;

            @Nullable
            public final Element invoke(@NotNull T scheme2) {
                Intrinsics.checkParameterIsNotNull(scheme2, (String)"scheme");
                Logger $receiver$iv = ComponentStoreImplKt.getLOG();
                try {
                    T t = scheme2;
                    if (t == null) {
                        return null;
                    }
                    T bundledAsMutable = t;
                    Parent parent = this.this$0.getProcessor$intellij_platform_configurationStore_impl().writeScheme(bundledAsMutable);
                    if (parent == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jdom.Element");
                    }
                    return (Element)parent;
                }
                catch (ProcessCanceledException e$iv) {
                }
                catch (Throwable e$iv) {
                    $receiver$iv.error(e$iv);
                }
                return null;
            }
            {
                this.this$0 = schemeManagerImpl;
                super(1);
            }
        };
        Object bundledScheme = this.schemeListManager.getReadOnlyExternalizableSchemes().get(this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(scheme2));
        if (bundledScheme == null) {
            SchemeProcessor schemeProcessor = this.getProcessor$intellij_platform_configurationStore_impl();
            if (!(schemeProcessor instanceof LazySchemeProcessor)) {
                schemeProcessor = null;
            }
            LazySchemeProcessor lazySchemeProcessor = (LazySchemeProcessor)schemeProcessor;
            if (lazySchemeProcessor != null) {
                if (lazySchemeProcessor.isSchemeEqualToBundled(scheme2)) {
                    ExternalInfo externalInfo2 = externalInfo;
                    if (externalInfo2 != null) {
                        this.scheduleDelete(externalInfo2);
                    }
                    return true;
                }
            }
            return false;
        }
        ExternalInfo externalInfo3 = (ExternalInfo)this.schemeToInfo.get(bundledScheme);
        if (externalInfo3 == null) {
            return false;
        }
        ExternalInfo bundledExternalInfo = externalInfo3;
        if (bundledExternalInfo.getDigest() == null) {
            Element element = serializeIfPossible$.invoke(bundledScheme);
            if (element != null) {
                Element element2;
                Element it = element2 = element;
                bundledExternalInfo.setDigest(Scheme_implKt.digest(it));
            } else {
                return false;
            }
        }
        if (bundledExternalInfo.isDigestEquals(newDigest)) {
            ExternalInfo externalInfo4 = externalInfo;
            if (externalInfo4 != null) {
                this.scheduleDelete(externalInfo4);
            }
            return true;
        }
        return false;
    }

    private final void scheduleDelete(@NotNull ExternalInfo $receiver) {
        this.filesToDelete.add($receiver.getFileName());
    }

    public final void scheduleDelete$intellij_platform_configurationStore_impl(@NotNull ExternalInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        this.scheduleDelete(info);
    }

    private final boolean isRenamed(T scheme2) {
        ExternalInfo info = (ExternalInfo)this.schemeToInfo.get(scheme2);
        return info != null && Intrinsics.areEqual((Object)this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(scheme2), (Object)info.getSchemeKey()) ^ true;
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteFiles(List<Throwable> errors, Set<String> filesToDelete) {
        Object $receiver$iv;
        VirtualFile[] $receiver$iv2;
        VirtualFile iterator;
        if (this.provider != null) {
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = virtualFile = (iterator = filesToDelete.iterator());
            while (virtualFile2.hasNext()) {
                String name = (String)virtualFile2.next();
                $receiver$iv2 = errors;
                try {
                    String spec = this.fileSpec + '/' + name;
                    if (!this.provider.delete(spec, this.roamingType)) continue;
                    iterator.remove();
                }
                catch (Throwable e$iv) {
                    $receiver$iv2.add(e$iv);
                }
            }
        }
        if (filesToDelete.isEmpty()) {
            return;
        }
        if (this.isUseVfs) {
            VirtualFile virtualFile = this.getVirtualDirectory$intellij_platform_configurationStore_impl();
            if (virtualFile != null) {
                void $receiver$iv$iv;
                VirtualFile virtualDir = iterator = virtualFile;
                VirtualFile[] virtualFileArray = virtualDir.getChildren();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"virtualDir.children");
                $receiver$iv = virtualFileArray;
                $receiver$iv2 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                void $i$a$1$catch = $receiver$iv$iv;
                int n = ((void)$i$a$1$catch).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it;
                    void v2 = it = (element$iv$iv = $i$a$1$catch[i]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                    if (!filesToDelete.contains(v2.getName())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List childrenToDelete = (List)destination$iv$iv;
                $receiver$iv = childrenToDelete;
                if (!$receiver$iv.isEmpty()) {
                    void result$iv;
                    $receiver$iv = new Ref.ObjectRef();
                    ((Ref.ObjectRef)$receiver$iv).element = null;
                    CommandProcessor.getInstance().runUndoTransparentAction(new Runnable((Ref.ObjectRef)result$iv, childrenToDelete, this, filesToDelete, (List)errors){
                        final /* synthetic */ Ref.ObjectRef $result;
                        final /* synthetic */ List $childrenToDelete$inlined;
                        final /* synthetic */ SchemeManagerImpl this$0;
                        final /* synthetic */ Set $filesToDelete$inlined;
                        final /* synthetic */ List $errors$inlined;
                        {
                            this.$result = objectRef;
                            this.$childrenToDelete$inlined = list2;
                            this.this$0 = schemeManagerImpl;
                            this.$filesToDelete$inlined = set;
                            this.$errors$inlined = list3;
                        }

                        public final void run() {
                            this.$result.element = ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(this){
                                final /* synthetic */ deleteFiles$$inlined$let$lambda$1 this$0;
                                {
                                    this.this$0 = var1_1;
                                }

                                public final T compute() {
                                    Iterable $receiver$iv = this.this$0.$childrenToDelete$inlined;
                                    for (T element$iv : $receiver$iv) {
                                        VirtualFile file2 = (VirtualFile)element$iv;
                                        List $receiver$iv2 = this.this$0.$errors$inlined;
                                        try {
                                            file2.delete((Object)this.this$0.this$0);
                                        }
                                        catch (Throwable e$iv) {
                                            $receiver$iv2.add(e$iv);
                                        }
                                    }
                                    return (T)Unit.INSTANCE;
                                }
                            });
                        }
                    });
                    Object cfr_ignored_0 = result$iv.element;
                }
                return;
            }
        }
        for (String name : filesToDelete) {
            $receiver$iv = errors;
            try {
                Path path = this.ioDirectory.resolve(name);
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"ioDirectory.resolve(name)");
                PathKt.delete((Path)path);
            }
            catch (Throwable e$iv) {
                $receiver$iv.add(e$iv);
            }
        }
    }

    @Nullable
    public final VirtualFile getVirtualDirectory$intellij_platform_configurationStore_impl() {
        VirtualFile result2 = this.cachedVirtualDirectory;
        if (result2 == null) {
            this.cachedVirtualDirectory = result2 = LocalFileSystem.getInstance().findFileByPath(PathKt.getSystemIndependentPath((Path)this.ioDirectory));
        }
        return result2;
    }

    @Override
    public void setSchemes(@NotNull List<? extends T> newSchemes, @Nullable T newCurrentScheme, @Nullable Condition<T> removeCondition) {
        Intrinsics.checkParameterIsNotNull(newSchemes, (String)"newSchemes");
        this.schemeListManager.setSchemes(newSchemes, (T)newCurrentScheme, (Condition<? extends T>)removeCondition);
    }

    public final void retainExternalInfo$intellij_platform_configurationStore_impl() {
        Iterator iterator;
        Iterator iterator2;
        if (this.schemeToInfo.isEmpty()) {
            return;
        }
        Iterator iterator3 = iterator2 = (iterator = this.schemeToInfo.entrySet().iterator());
        block0: while (iterator3.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator3.next();
            Object scheme2 = entry2.getKey();
            entry2 = entry;
            ExternalInfo info = (ExternalInfo)entry2.getValue();
            ConcurrentMap<String, T> concurrentMap = this.schemeListManager.getReadOnlyExternalizableSchemes();
            SchemeProcessor schemeProcessor = this.getProcessor$intellij_platform_configurationStore_impl();
            Object k = scheme2;
            Intrinsics.checkExpressionValueIsNotNull(k, (String)"scheme");
            if (Intrinsics.areEqual(concurrentMap.get(schemeProcessor.getSchemeKey(k)), scheme2)) continue;
            for (Object s : this.getSchemes$intellij_platform_configurationStore_impl()) {
                if (s != scheme2) continue;
                this.filesToDelete.remove(info.getFileName());
                continue block0;
            }
            iterator.remove();
            ExternalInfo externalInfo = info;
            Intrinsics.checkExpressionValueIsNotNull((Object)externalInfo, (String)"info");
            this.scheduleDelete(externalInfo);
        }
    }

    @Override
    public void addScheme(@NotNull T scheme2, boolean replaceExisting) {
        Intrinsics.checkParameterIsNotNull(scheme2, (String)"scheme");
        this.schemeListManager.addScheme(scheme2, replaceExisting);
    }

    @Override
    @Nullable
    public T findSchemeByName(@NotNull String schemeName) {
        T t;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)schemeName, (String)"schemeName");
            Iterable $receiver$iv = (Iterable)this.getSchemes$intellij_platform_configurationStore_impl();
            Iterator iterator = $receiver$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                SchemeProcessor schemeProcessor = this.getProcessor$intellij_platform_configurationStore_impl();
                Object t2 = it;
                Intrinsics.checkExpressionValueIsNotNull(t2, (String)"it");
                if (!Intrinsics.areEqual((Object)schemeProcessor.getSchemeKey(t2), (Object)schemeName)) continue;
                t = element$iv;
                break block1;
            }
            t = null;
        }
        return t;
    }

    @Override
    @Nullable
    public T removeScheme(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return (T)SchemeListManager.removeFirstScheme$default(this.schemeListManager, (List)this.getSchemes$intellij_platform_configurationStore_impl(), false, new Function1<T, Boolean>(this, name){
            final /* synthetic */ SchemeManagerImpl this$0;
            final /* synthetic */ String $name;

            public final boolean invoke(@NotNull T it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return Intrinsics.areEqual((Object)this.this$0.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(it), (Object)this.$name);
            }
            {
                this.this$0 = schemeManagerImpl;
                this.$name = string;
                super(1);
            }
        }, 2, null);
    }

    @Override
    public boolean removeScheme(@NotNull T scheme2) {
        Intrinsics.checkParameterIsNotNull(scheme2, (String)"scheme");
        return SchemeListManager.removeFirstScheme$default(this.schemeListManager, (List)this.getSchemes$intellij_platform_configurationStore_impl(), false, new Function1<T, Boolean>(scheme2){
            final /* synthetic */ Object $scheme;

            public final boolean invoke(@NotNull T it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return Intrinsics.areEqual(it, (Object)this.$scheme);
            }
            {
                this.$scheme = object;
                super(1);
            }
        }, 2, null) != null;
    }

    @Override
    public boolean isMetadataEditable(@NotNull T scheme2) {
        Intrinsics.checkParameterIsNotNull(scheme2, (String)"scheme");
        return !this.schemeListManager.getReadOnlyExternalizableSchemes().containsKey(this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(scheme2));
    }

    @NotNull
    public String toString() {
        return this.fileSpec;
    }

    @NotNull
    public final String getFileSpec() {
        return this.fileSpec;
    }

    @NotNull
    public final Path getIoDirectory$intellij_platform_configurationStore_impl() {
        return this.ioDirectory;
    }

    @NotNull
    public final RoamingType getRoamingType() {
        return this.roamingType;
    }

    @Nullable
    public final String getPresentableName() {
        return this.presentableName;
    }

    public SchemeManagerImpl(@NotNull String fileSpec, @NotNull SchemeProcessor<T, ? super MUTABLE_SCHEME> processor2, @Nullable StreamProvider provider, @NotNull Path ioDirectory, @NotNull RoamingType roamingType, @Nullable String presentableName, @NotNull SchemeNameToFileName schemeNameToFileName, @Nullable Function1<? super SchemeManagerImpl<?, ?>, Unit> fileChangeSubscriber) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)ioDirectory, (String)"ioDirectory");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        Intrinsics.checkParameterIsNotNull((Object)schemeNameToFileName, (String)"schemeNameToFileName");
        super(processor2);
        this.fileSpec = fileSpec;
        this.provider = provider;
        this.ioDirectory = ioDirectory;
        this.roamingType = roamingType;
        this.presentableName = presentableName;
        this.schemeNameToFileName = schemeNameToFileName;
        this.fileChangeSubscriber = fileChangeSubscriber;
        this.isUseVfs = this.fileChangeSubscriber != null;
        this.isOldSchemeNaming = Intrinsics.areEqual((Object)this.schemeNameToFileName, (Object)Scheme_implKt.getOLD_NAME_CONVERTER());
        this.isLoadingSchemes = new AtomicBoolean();
        this.schemeListManager = new SchemeListManager(this);
        Set set = ContainerUtil.newConcurrentSet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"ContainerUtil.newConcurrentSet<String>()");
        this.filesToDelete = set;
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createMap(ContainerUtil.identityStrategy());
        Intrinsics.checkExpressionValueIsNotNull(concurrentMap, (String)"ConcurrentCollectionFact\u2026rUtil.identityStrategy())");
        this.schemeToInfo = concurrentMap;
        if (processor2 instanceof SchemeExtensionProvider) {
            this.schemeExtension = ((SchemeExtensionProvider)((Object)processor2)).getSchemeExtension();
            this.updateExtension = true;
        } else {
            this.schemeExtension = ".xml";
            this.updateExtension = false;
        }
        if (this.isUseVfs) {
            Logger $receiver$iv = ComponentStoreImplKt.getLOG();
            try {
                this.refreshVirtualDirectory();
            }
            catch (ProcessCanceledException e$iv) {
            }
            catch (Throwable e$iv) {
                $receiver$iv.error(e$iv);
            }
        }
    }

    public /* synthetic */ SchemeManagerImpl(String string, SchemeProcessor schemeProcessor, StreamProvider streamProvider, Path path, RoamingType roamingType, String string2, SchemeNameToFileName schemeNameToFileName, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            roamingType = RoamingType.DEFAULT;
        }
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        if ((n & 0x40) != 0) {
            schemeNameToFileName = Scheme_implKt.getCURRENT_NAME_CONVERTER();
        }
        if ((n & 0x80) != 0) {
            function1 = null;
        }
        this(string, schemeProcessor, streamProvider, path, roamingType, string2, schemeNameToFileName, function1);
    }

    public static final /* synthetic */ boolean access$isOverwriteOnLoad(SchemeManagerImpl $this, @NotNull Object existingScheme) {
        return $this.isOverwriteOnLoad(existingScheme);
    }
}

