/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.uml.providers;

import com.intellij.diagram.extras.providers.SupersProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class PhpSupersProvider
extends SupersProvider<PsiElement> {
    public PsiElement[] getElements(PsiElement element, Project project) {
        HashSet<PhpClass> classes = new HashSet<PhpClass>();
        if (element instanceof PhpClass) {
            PhpSupersProvider.collectAllSupers((PhpClass)element, classes);
        }
        return classes.toArray(PsiElement.EMPTY_ARRAY);
    }

    public String getHeaderName(PsiElement element, Project project) {
        return "Show super types for " + (element instanceof PhpClass ? ((PhpClass)element).getName() : "");
    }

    public Comparator<? super PsiElement> getComparator() {
        return PSI_COMPARATOR;
    }

    public static void collectAllSupers(PhpClass cls, Set<PhpClass> result) {
        if (cls == null) {
            return;
        }
        PhpClassHierarchyUtils.processSuperClasses((PhpClass)cls, (boolean)false, (boolean)true, (Processor)new CommonProcessors.CollectProcessor(result));
    }

    public boolean isEnabledOn(PsiElement element) {
        return element instanceof PhpClass;
    }
}

