/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.member;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.DependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.impl.ClassConstImpl;
import com.jetbrains.php.refactoring.PhpDependencyMemberInfoModel;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.PhpMemberInfoStorage;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberConflicts;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberDelegate;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberProcessor;
import com.jetbrains.php.refactoring.ui.PhpMemberSelectionPanel;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveMemberDialog
extends RefactoringDialog {
    public static final String HELP_ID = "refactoring.moveStaticMember";
    private static final String DIMENSION_SERVICE_KEY_BASE = "#com.jetbrains.php.refactoring.move.member.PhpMoveMemberDialog#";
    private final EditorTextField destClassTextField;
    private final JBLabel myDestClassHintLabel;
    private final JLabel myTextFieldLabel;
    protected List<PhpMemberInfo> myMemberInfos;
    protected DependencyMemberInfoModel<PhpClassMember, PhpMemberInfo> myMemberInfoModel;
    @Nullable
    protected PhpMemberSelectionPanel memberSelectionPanel;
    protected PhpClass myFromClass;
    private final Alarm myAlarm;
    protected Editor myEditor;

    public PhpMoveMemberDialog(@NotNull Project project, PhpClass fromClazz, PhpMemberInfoStorage storage, Editor editor) {
        if (project == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(0);
        }
        super(project, true);
        this.myEditor = editor;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)new Disposable(){

            public void dispose() {
                PhpMoveMemberDialog.this.myAlarm.cancelAllRequests();
            }
        });
        this.myFromClass = fromClazz;
        List infoList = storage.getClassMemberInfos((PsiElement)fromClazz);
        this.myMemberInfos = new ArrayList<PhpMemberInfo>();
        for (PhpMemberInfo it : infoList) {
            PhpClassMember element = (PhpClassMember)it.getMember();
            if (!element.getModifier().isStatic()) continue;
            this.myMemberInfos.add(it);
        }
        this.destClassTextField = new EditorTextField("", this.getProject(), (FileType)FileTypes.PLAIN_TEXT);
        this.myTextFieldLabel = new JLabel(PhpBundle.message("refactoring.move.method.label.text.field", new Object[0]));
        this.myDestClassHintLabel = new JBLabel(PhpBundle.message("0.completion.shortcut", "class reference", PhpUiUtil.getShortcutTextByActionName("CodeCompletion")));
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)this.myDestClassHintLabel);
        this.setTitle(PhpBundle.message("refactoring.move.member.title", new Object[0]));
        PhpCompletionUtil.installClassInterfaceCompletion(this.destClassTextField, null, this.getDisposable(), (Condition<? super PhpClass>)((Condition)aClass -> !aClass.isInterface() || PhpMoveMemberDialog.constantsOnly(this.getSelectedMembers())), new String[0]);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myAlarm);
        this.init();
    }

    public static boolean constantsOnly(Collection<? extends PhpClassMember> members) {
        for (PhpClassMember phpClassMember : members) {
            if (phpClassMember instanceof ClassConstImpl) continue;
            return false;
        }
        return true;
    }

    public String getDimensionServiceKey() {
        return DIMENSION_SERVICE_KEY_BASE;
    }

    public String getHelpId() {
        return HELP_ID;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.getInfo(this.getProject(), this.destClassTextField.getText());
    }

    private ValidationInfo getInfo(Project project, String destClass) {
        Collection<PhpClass> classes = PhpMoveMemberDialog.getClasses(project, destClass);
        String message = this.validateAllInfo(classes, true);
        if (message != null) {
            return new ValidationInfo(message);
        }
        return super.doValidate();
    }

    @Nullable
    protected String validateAllInfo(Collection<PhpClass> classes, boolean inTimeValidation) {
        return PhpMoveMemberConflicts.getValidationResult(classes, this.destClassTextField.getText(), this.myFromClass, this.getSelectedMembers(), inTimeValidation);
    }

    @Nullable
    protected static String validateClassNames(PhpClass fromClass, String destClassText, @NotNull Collection<? extends PhpClass> classes) {
        if (classes == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(1);
        }
        if (classes.size() > 1) {
            return PhpBundle.message("refactoring.move.members.there.are.several.classes.with.specified.name", destClassText);
        }
        if (classes.size() == 0) {
            if (destClassText.length() != 0) {
                return PhpBundle.message("refactoring.move.members.cannot.find.target.class", destClassText);
            }
            return null;
        }
        if (PhpLangUtil.equalsClassNames(classes.iterator().next().getFQN(), fromClass.getFQN())) {
            return RefactoringBundle.message((String)"source.and.destination.classes.should.be.different");
        }
        return null;
    }

    protected void doAction() {
        Collection<PhpClass> classesForFQN = PhpMoveMemberDialog.getClasses(this.getProject(), this.destClassTextField.getText());
        String message = this.validateAllInfo(classesForFQN, false);
        if (message != null) {
            CommonRefactoringUtil.showErrorMessage((String)PhpMoveMemberDelegate.REFACTORING_NAME, (String)message, (String)HELP_ID, (Project)this.myProject);
            return;
        }
        if (this.destClassTextField.getText().isEmpty()) {
            CommonRefactoringUtil.showErrorMessage((String)PhpMoveMemberDelegate.REFACTORING_NAME, (String)PhpBundle.message("refactoring.move.members.is.not.a.valid.class.name", ""), (String)HELP_ID, (Project)this.myProject);
            return;
        }
        PhpClass targetClass = classesForFQN.iterator().next();
        assert (targetClass != null);
        PhpMoveMemberProcessor processor = new PhpMoveMemberProcessor(this.getProject(), this.myFromClass, targetClass, this.myEditor, this.getSelectedMembers());
        this.invokeRefactoring(processor);
    }

    @NotNull
    public Collection<PhpClassMember> getSelectedMembers() {
        ArrayList<PhpClassMember> list = new ArrayList<PhpClassMember>(this.myMemberInfos.size());
        for (PhpMemberInfo info : this.myMemberInfos) {
            if (!info.isChecked() || !this.myMemberInfoModel.isMemberEnabled((MemberInfoBase)info)) continue;
            list.add((PhpClassMember)info.getMember());
        }
        ArrayList<PhpClassMember> arrayList = list;
        if (arrayList == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    protected DependencyMemberInfoModel<PhpClassMember, PhpMemberInfo> createMemberInfoModel() {
        PhpDependencyMemberInfoModel phpDependencyMemberInfoModel = new PhpDependencyMemberInfoModel(this.myFromClass);
        if (phpDependencyMemberInfoModel == null) {
            PhpMoveMemberDialog.$$$reportNull$$$0(3);
        }
        return phpDependencyMemberInfoModel;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.myTextFieldLabel, "North");
        panel.add((Component)this.destClassTextField, "Center");
        this.myTextFieldLabel.setLabelFor((Component)this.destClassTextField);
        panel.add((Component)this.myDestClassHintLabel, "South");
        return panel;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.memberSelectionPanel = new PhpMemberSelectionPanel(this.getMembersBorderTitle(), this.myMemberInfos, null);
        this.myMemberInfoModel = this.createMemberInfoModel();
        this.myMemberInfoModel.memberInfoChanged(new MemberInfoChange(this.myMemberInfos));
        this.memberSelectionPanel.getTable().setMemberInfoModel((MemberInfoModel)this.myMemberInfoModel);
        this.memberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)this.myMemberInfoModel);
        panel.add((Component)this.memberSelectionPanel, "Center");
        return panel;
    }

    private static Collection<PhpClass> getClasses(Project project, String text) {
        PhpIndex instance = PhpIndex.getInstance((Project)project);
        ArrayList<PhpClass> classesByFQN = new ArrayList<PhpClass>();
        classesByFQN.addAll(instance.getClassesByFQN(text));
        classesByFQN.addAll(instance.getInterfacesByFQN(text));
        return classesByFQN;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.destClassTextField;
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected String getMembersBorderTitle() {
        return PhpBundle.message("refactoring.move.members.to.be.moved", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/member/PhpMoveMemberDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/member/PhpMoveMemberDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedMembers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createMemberInfoModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "validateClassNames";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

