/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconDeferrer;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpClassMemberIconProvider;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeInfo;
import com.jetbrains.php.lang.psi.stubs.PhpMethodStub;
import com.jetbrains.php.lang.psi.stubs.PhpNamedStub;
import com.jetbrains.php.lang.psi.stubs.PhpTypedStub;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodImpl
extends FunctionImpl
implements Method,
StubBasedPsiElement<NamedStub> {
    private static final Function<Method, Icon> METHOD_ICON_EVALUATOR = method -> PhpClassMemberIconProvider.getMethodIcon(method);

    public MethodImpl(ASTNode node) {
        super(node);
    }

    public static Icon getIcon(Method method) {
        return IconDeferrer.getInstance().defer(PhpIcons.METHOD, (Object)method, METHOD_ICON_EVALUATOR);
    }

    @Override
    public void processDocs(Processor<PhpDocComment> processor) {
        processor.process((Object)this.getDocComment());
        PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)this, (method, subClass, baseClass) -> !processor.process((Object)method.getDocComment()));
    }

    public MethodImpl(PhpMethodStub stub) {
        super((PhpNamedStub)stub, (IStubElementType)PhpStubElementTypes.CLASS_METHOD);
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            MethodImpl.$$$reportNull$$$0(0);
        }
        ASTNode nameNode = this.getNameNode();
        String oldName = this.getName();
        if (nameNode != null && !PhpLangUtil.isNewStyleConstructor(oldName) && !oldName.equals(name)) {
            Method method = PhpPsiElementFactory.createMethod(this.getProject(), "function " + name + "(){}");
            ASTNode newChild = method.getNameNode();
            assert (newChild != null);
            nameNode.getTreeParent().replaceChild(nameNode, newChild);
        }
        return this;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return MethodImpl.getIcon(this);
    }

    @Override
    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getMethodPresentation(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor psiElementVisitor) {
        if (psiElementVisitor == null) {
            MethodImpl.$$$reportNull$$$0(1);
        }
        if (psiElementVisitor instanceof PhpElementVisitor) {
            ((PhpElementVisitor)psiElementVisitor).visitPhpMethod((Method)this);
        } else {
            super.accept(psiElementVisitor);
        }
    }

    @NotNull
    public PhpModifier getModifier() {
        PhpModifier.Abstractness abstractness = PhpModifier.Abstractness.IMPLEMENTED;
        PhpModifier.State state = PhpModifier.State.DYNAMIC;
        if (this.isStatic()) {
            state = PhpModifier.State.STATIC;
        }
        if (this.isAbstract()) {
            abstractness = PhpModifier.Abstractness.ABSTRACT;
        } else if (this.isFinal()) {
            abstractness = PhpModifier.Abstractness.FINAL;
        }
        PhpModifier phpModifier = PhpModifier.instance((PhpModifier.Access)this.getAccess(), (PhpModifier.Abstractness)abstractness, (PhpModifier.State)state);
        if (phpModifier == null) {
            MethodImpl.$$$reportNull$$$0(2);
        }
        return phpModifier;
    }

    public boolean isFinal() {
        ASTNode[] nodes;
        PhpTypedStub stub = (PhpTypedStub)this.getGreenStub();
        if (stub != null) {
            return ((PhpMethodStub)stub).isFinal();
        }
        PhpPsiElement modifierList = this.getFirstPsiChild();
        for (ASTNode node : nodes = modifierList.getNode().getChildren(PhpTokenTypes.tsMODIFIERS)) {
            if (node.getElementType() != PhpTokenTypes.kwFINAL) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        ASTNode next = this.getNode().findChildByType(PhpTokenTypes.kwFUNCTION).getTreeNext();
        while (PhpPsiUtil.isOfType(next, PhpTokenTypes.opBIT_AND) || next instanceof PsiWhiteSpace || next instanceof PsiComment) {
            next = next.getTreeNext();
        }
        return PhpPsiUtil.isOfType(next, TokenType.ERROR_ELEMENT) ? null : next;
    }

    public boolean isAbstract() {
        ASTNode[] nodes;
        PhpMethodStub stub = (PhpMethodStub)this.getGreenStub();
        if (stub != null) {
            return stub.isAbstract();
        }
        PhpPsiElement modifierList = this.getFirstPsiChild();
        for (ASTNode node : nodes = modifierList.getNode().getChildren(PhpTokenTypes.tsMODIFIERS)) {
            if (node.getElementType() != PhpTokenTypes.kwABSTACT) continue;
            return true;
        }
        PhpClass phpInterface = (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)this, PhpClass.class);
        return phpInterface != null && phpInterface.isInterface();
    }

    public boolean isReturningByReference() {
        PhpMethodStub stub = (PhpMethodStub)this.getGreenStub();
        if (stub != null) {
            return stub.isReturningByReference();
        }
        ASTNode nameNode = this.getNameNode();
        return nameNode != null && PhpPsiUtil.findPrevSiblingOfAnyType(nameNode.getPsi(), PhpTokenTypes.opBIT_AND) != null;
    }

    public PhpModifier.Access getAccess() {
        PhpTypedStub stub = (PhpTypedStub)this.getGreenStub();
        if (stub != null) {
            if (((PhpMethodStub)stub).isPrivate()) {
                return PhpModifier.Access.PRIVATE;
            }
            if (((PhpMethodStub)stub).isProtected()) {
                return PhpModifier.Access.PROTECTED;
            }
            return PhpModifier.Access.PUBLIC;
        }
        PhpPsiElement modifierList = this.getFirstPsiChild();
        return MethodImpl.getAccess(modifierList.getNode());
    }

    @NotNull
    public static PhpModifier.Access getAccess(ASTNode astNode) {
        ASTNode[] nodes;
        for (ASTNode node : nodes = astNode.getChildren(PhpTokenTypes.tsMODIFIERS)) {
            if (node.getElementType() == PhpTokenTypes.kwPRIVATE) {
                PhpModifier.Access access = PhpModifier.Access.PRIVATE;
                if (access == null) {
                    MethodImpl.$$$reportNull$$$0(3);
                }
                return access;
            }
            if (node.getElementType() == PhpTokenTypes.kwPROTECTED) {
                PhpModifier.Access access = PhpModifier.Access.PROTECTED;
                if (access == null) {
                    MethodImpl.$$$reportNull$$$0(4);
                }
                return access;
            }
            if (node.getElementType() != PhpTokenTypes.kwPUBLIC) continue;
            PhpModifier.Access access = PhpModifier.Access.PUBLIC;
            if (access == null) {
                MethodImpl.$$$reportNull$$$0(5);
            }
            return access;
        }
        PhpModifier.Access access = PhpModifier.Access.PUBLIC;
        if (access == null) {
            MethodImpl.$$$reportNull$$$0(6);
        }
        return access;
    }

    @Nullable
    public Method.MethodType getMethodType(boolean allowAmbiguity) {
        CharSequence methodName = this.getNameCS();
        if (PhpLangUtil.isNewStyleConstructor(methodName)) {
            return Method.MethodType.CONSTRUCTOR;
        }
        PhpClass clazz = this.getContainingClass();
        if (clazz == null || !"\\".equals(clazz.getNamespaceName()) || !PhpLangUtil.equalsMethodNames(methodName, clazz.getNameCS())) {
            return Method.MethodType.REGULAR_METHOD;
        }
        return allowAmbiguity ? Method.MethodType.UNDEFINED : (clazz.findOwnMethodByName((CharSequence)"__construct") == null ? Method.MethodType.CONSTRUCTOR : Method.MethodType.REGULAR_METHOD);
    }

    public boolean isStatic() {
        PhpTypedStub stub = (PhpTypedStub)this.getGreenStub();
        if (stub != null) {
            return ((PhpMethodStub)stub).isStatic();
        }
        PhpModifierList modifierList = (PhpModifierList)PhpPsiUtil.getChildByCondition((PsiElement)this, (Condition<? super PsiElement>)PhpModifierList.INSTANCEOF);
        if (modifierList != null) {
            return PhpPsiUtil.getChildOfType((PsiElement)modifierList, PhpTokenTypes.kwSTATIC) != null;
        }
        return false;
    }

    @Nullable
    public PhpClass getContainingClass() {
        PsiElement stub = this.getParent();
        return stub instanceof PhpClass ? (PhpClass)stub : null;
    }

    @Override
    @NotNull
    public String getFQN() {
        PhpClass containingClass = this.getContainingClass();
        String string = containingClass != null ? containingClass.getFQN() + "." + this.getName() : "";
        if (string == null) {
            MethodImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public PhpType getLocalType(boolean interactive) {
        PhpTypedStub stub = (PhpTypedStub)this.getGreenStub();
        if (stub != null) {
            PhpType phpType = stub.getType();
            if (phpType == null) {
                MethodImpl.$$$reportNull$$$0(8);
            }
            return phpType;
        }
        if (this.getMethodType(false) == Method.MethodType.CONSTRUCTOR) {
            PhpType phpType = new PhpType().add((PsiElement)this.getContainingClass());
            if (phpType == null) {
                MethodImpl.$$$reportNull$$$0(9);
            }
            return phpType;
        }
        PhpType type = super.getLocalType(interactive);
        PhpDocComment comment = this.getDocComment();
        PhpDocReturnTag returnTag = comment != null ? comment.getReturnTag() : null;
        PhpReturnType returnType = this.getReturnType();
        if ((returnTag == null || returnTag.getType().isEmpty()) && PhpTypeInfo.getType((PsiElement)returnType).isEmpty()) {
            PhpClass aClass = this.getContainingClass();
            assert (aClass != null);
            List names = Lists.asList((Object)aClass.getSuperFQN(), (Object[])aClass.getInterfaceNames());
            for (String superFQN : names) {
                if (superFQN == null) continue;
                String sig = "#M#C" + superFQN + "." + this.getName();
                type.add(sig);
            }
        }
        PhpType phpType = type;
        if (phpType == null) {
            MethodImpl.$$$reportNull$$$0(10);
        }
        return phpType;
    }

    @Override
    @NotNull
    public PhpType getDeclaredType() {
        PhpNamedStub stub = (PhpNamedStub)this.getGreenStub();
        if (stub != null) {
            PhpType phpType = stub.getDeclaredType();
            if (phpType == null) {
                MethodImpl.$$$reportNull$$$0(11);
            }
            return phpType;
        }
        PhpReturnType returnTypeElement = this.getReturnType();
        if (returnTypeElement != null) {
            PhpType phpType = returnTypeElement.getType();
            if (phpType == null) {
                MethodImpl.$$$reportNull$$$0(12);
            }
            return phpType;
        }
        PhpType phpType = PhpType.EMPTY;
        if (phpType == null) {
            MethodImpl.$$$reportNull$$$0(13);
        }
        return phpType;
    }

    @Override
    public boolean isClosure() {
        return false;
    }

    @Override
    @NotNull
    public Set<CharSequence> getPredefinedVariables() {
        if (!this.isStatic()) {
            Set<CharSequence> set = PhpLangUtil.PREDEFINED_DYNAMIC_FIELDS_SET;
            if (set == null) {
                MethodImpl.$$$reportNull$$$0(14);
            }
            return set;
        }
        Set<CharSequence> set = Collections.emptySet();
        if (set == null) {
            MethodImpl.$$$reportNull$$$0(15);
        }
        return set;
    }

    @Override
    public Collection<String> getDocExceptions() {
        PhpTypedStub stub = (PhpTypedStub)this.getGreenStub();
        if (stub instanceof PhpMethodStub) {
            return ((PhpMethodStub)stub).getDocExceptions();
        }
        return MethodImpl.getDocExceptions(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/MethodImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/MethodImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifier";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccess";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

