/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class PhpParamsInspection
extends PhpInspection {
    private static final Comparator<Pair<List<Parameter>, Map<PsiElement, String>>> COMPARATOR = (o1, o2) -> {
        int i = ((List)o1.getFirst()).size() - ((List)o2.getFirst()).size();
        return i != 0 ? i : ((Map)o1.second).size() - ((Map)o2.second).size();
    };

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpParamsInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){
            final Set<VirtualFile> extensionRoots;
            {
                this.extensionRoots = PhpRuntimeLibraryRootsProvider.getLibraryRoots(holder.getProject());
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                if (reference.getParent() instanceof PhpUse) {
                    return;
                }
                ResolveResult[] results = reference.multiResolve(false);
                PhpParamsInspection.checkCall((PhpPsiElement)reference, results, reference.getParameters(), this.extensionRoots, holder);
            }

            public void visitPhpMethodReference(MethodReference call) {
                if (call.getNameNode() != null) {
                    if (call.getParent() instanceof PhpTraitUseRule) {
                        return;
                    }
                    ResolveResult[] results = ((PsiPolyVariantReference)call.getReference()).multiResolve(false);
                    if (results.length > 0 && results[0].getElement() instanceof PhpDocMethod) {
                        results = ((PsiPolyVariantReference)call.getReference()).multiResolve(true);
                    }
                    PhpParamsInspection.checkCall((PhpPsiElement)call, results, call.getParameters(), this.extensionRoots, holder);
                }
            }

            public void visitPhpNewExpression(NewExpression expression) {
                ClassReference classReference = expression.getClassReference();
                if (classReference != null) {
                    Method constructor;
                    ResolveResult[] results = classReference.multiResolve(false);
                    if (results.length == 1 && results[0].getElement() instanceof Method) {
                        PhpParamsInspection.checkCall((PhpPsiElement)expression, results, expression.getParameters(), this.extensionRoots, holder);
                    } else if (results.length == 1 && results[0].getElement() instanceof PhpClass && (constructor = ((PhpClass)results[0].getElement()).getConstructor()) != null) {
                        PhpParamsInspection.checkCall((PhpPsiElement)expression, PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{constructor}), expression.getParameters(), this.extensionRoots, holder);
                    }
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpParamsInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static void checkCall(PhpPsiElement call, ResolveResult[] results, PsiElement[] callParams, Set<VirtualFile> extensionRoots, ProblemsHolder holder) {
        if (results.length > 0) {
            PhpType[] callTypes = new PhpType[callParams.length];
            int paramsLength = callParams.length;
            for (int i = 0; i < paramsLength; ++i) {
                callTypes[i] = new PhpType().add(callParams[i]).globalLocationAware(callParams[i]).filterNull().filterUnknown();
            }
            ArrayList<Pair<List<Parameter>, Map<PsiElement, String>>> warnings = new ArrayList<Pair<List<Parameter>, Map<PsiElement, String>>>();
            boolean onTheFly = holder.isOnTheFly();
            if (PhpParamsInspection.processSignatures(results, extensionRoots, (Processor<List<Parameter>>)((Processor)declParams -> {
                boolean unpackedArgument;
                HashMap<PsiElement, String> problems = new HashMap<PsiElement, String>();
                warnings.add(new Pair(declParams, problems));
                boolean bl = unpackedArgument = callParams.length > 0 && PhpCodeInsightUtil.isUnpackedArgument(callParams[callParams.length - 1]);
                if (PhpParamsInspection.checkMissingParameter(call, callParams, declParams, problems, onTheFly, unpackedArgument)) {
                    return false;
                }
                return PhpParamsInspection.checkParametersTypes(call, callParams, callTypes, declParams, problems, onTheFly, unpackedArgument);
            }))) {
                return;
            }
            PhpParamsInspection.registerProblems(holder, warnings);
        }
    }

    private static void registerProblems(ProblemsHolder holder, List<Pair<List<Parameter>, Map<PsiElement, String>>> warnings) {
        Collections.sort(warnings, COMPARATOR);
        for (Pair<List<Parameter>, Map<PsiElement, String>> warning : warnings) {
            if (((Map)warning.getSecond()).size() <= 0) break;
            if (((Map)warning.getSecond()).values().contains(null)) continue;
            ((Map)warning.getSecond()).forEach((key, value) -> holder.registerProblem(key, value, new LocalQuickFix[0]));
            break;
        }
    }

    private static boolean checkParametersTypes(PhpPsiElement call, PsiElement[] callParams, PhpType[] callTypes, List<Parameter> declParams, HashMap<PsiElement, String> problems, boolean isOnTheFly, boolean unpackedArgument) {
        boolean result = true;
        PhpNamedElement pos = (PhpNamedElement)PsiTreeUtil.getParentOfType((PsiElement)call, PhpNamedElement.class);
        String ns = pos != null ? pos.getNamespaceName() : "\\";
        PhpIndex phpIndex = PhpIndex.getInstance((Project)call.getProject());
        for (int i = 0; !(i >= declParams.size() || callParams.length - 1 == i && unpackedArgument); ++i) {
            result = PhpParamsInspection.checkDeclType(callParams, isOnTheFly, callTypes, ns, phpIndex, problems, result, i, declParams.get(i));
        }
        return result;
    }

    @NotNull
    private static PhpType getParameterType(Parameter declParameter) {
        PhpType declType = new PhpType().add(declParameter.getType()).globalLocationAware((PsiElement)declParameter).filterNull();
        if (declParameter.isVariadic()) {
            declType.add(declType.unpluralize());
        }
        if (declParameter.isOptional() && !declType.isEmpty()) {
            declType = PhpType.builder().add(declType).add(PhpType.VOID).build();
        }
        PhpType phpType = declType;
        if (phpType == null) {
            PhpParamsInspection.$$$reportNull$$$0(2);
        }
        return phpType;
    }

    private static boolean checkMissingParameter(PhpPsiElement call, PsiElement[] callParams, List<Parameter> declParams, HashMap<PsiElement, String> problems, boolean isOnTheFly, boolean unpackedArgument) {
        int lastRequired = ContainerUtil.lastIndexOf(declParams, p -> PhpParamsInspection.required(p));
        if (lastRequired < 0) {
            lastRequired = 0;
        }
        long notRequiredCount = IntStream.range(lastRequired, declParams.size()).filter(i -> !PhpParamsInspection.required((Parameter)declParams.get(i))).count();
        if ((long)callParams.length < (long)declParams.size() - notRequiredCount && !unpackedArgument) {
            problems.put((PsiElement)call, isOnTheFly ? PhpBundle.message("inspection.missing_param", declParams.get(callParams.length).getName()) : "Required parameter missing");
            return true;
        }
        return false;
    }

    private static boolean checkDeclType(PsiElement[] callParams, boolean isOnTheFly, PhpType[] callTypes, String ns, PhpIndex phpIndex, HashMap<PsiElement, String> problems, boolean result, int from, Parameter declParameter) {
        if (!declParameter.isOptional() || !declParameter.getDeclaredType().isEmpty()) {
            PhpType declType = PhpParamsInspection.getParameterType(declParameter);
            int to = declParameter.isVariadic() ? callParams.length : from + 1;
            for (int i = from; i < to; ++i) {
                if (callTypes.length <= i || callTypes[i].isUndefined() || declType.isConvertibleFrom(callTypes[i], phpIndex)) continue;
                problems.put(callParams[i], isOnTheFly ? PhpBundle.message("inspection.wrong_param_type", callTypes[i].toStringRelativized(ns), declType.toStringRelativized(ns)) : "Parameter '#ref' type is not compatible with declaration");
                result = false;
            }
        }
        return result;
    }

    private static boolean required(Parameter p) {
        return !p.isOptional() && !p.isVariadic();
    }

    private static boolean processSignatures(ResolveResult[] results, Set<VirtualFile> extensionRoots, Processor<List<Parameter>> processor) {
        for (ResolveResult result : results) {
            Function f;
            Parameter[] declParams;
            PsiElement element = result.getElement();
            if (!(element instanceof Function) || !result.isValidResult() || (declParams = (f = (Function)element).getParameters()).length > 10 || !(PhpParamsInspection.belongToExtensions(element, extensionRoots) ? PhpParamsInspection.collectSignatureVariants(declParams, processor) : processor.process(Arrays.asList(declParams)))) continue;
            return true;
        }
        return false;
    }

    private static boolean belongToExtensions(PsiElement element, @NotNull Set<VirtualFile> extensionRoots) {
        if (extensionRoots == null) {
            PhpParamsInspection.$$$reportNull$$$0(3);
        }
        return VfsUtilCore.isUnder((VirtualFile)element.getContainingFile().getVirtualFile(), extensionRoots);
    }

    private static boolean collectSignatureVariants(Parameter[] declParams, Processor<List<Parameter>> processor) {
        ArrayList sigs = new ArrayList();
        sigs.add(new ArrayList());
        for (Parameter declParam : declParams) {
            int sigsSize = sigs.size();
            for (int i1 = 0; i1 < sigsSize; ++i1) {
                List sig = (List)sigs.get(i1);
                if (!PhpParamsInspection.required(declParam)) {
                    sigs.add(new ArrayList(sig));
                }
                sig.add(declParam);
            }
        }
        return sigs.stream().anyMatch(arg_0 -> processor.process(arg_0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpParamsInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpParamsInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "belongToExtensions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

