/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix.type;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpChangeParameterTypeQuickFix
extends PhpQuickFixBase {
    private final int myIndex;
    private final PhpType myCurrentType;
    private final PhpType myNewType;

    public PhpChangeParameterTypeQuickFix(int index, @NotNull PhpType currentType, @NotNull PhpType newType) {
        if (currentType == null) {
            PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(0);
        }
        if (newType == null) {
            PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(1);
        }
        this.myIndex = index;
        this.myCurrentType = currentType;
        this.myNewType = newType;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = PhpBundle.message("quickfix.strict.type.checking.change.parameter.type.name", this.myIndex + 1, this.myCurrentType, this.myNewType);
        if (string == null) {
            PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.strict.type.checking.change.parameter.type.family", new Object[0]);
        if (string == null) {
            PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Parameter[] parameters;
        PsiElement element;
        NewExpression newExpression;
        if (project == null) {
            PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            PhpChangeParameterTypeQuickFix.$$$reportNull$$$0(5);
        }
        Object reference = (newExpression = (NewExpression)PhpPsiUtil.getParentByCondition(element = descriptor.getPsiElement(), true, (Condition<? super PsiElement>)NewExpression.INSTANCEOF, (Condition<? super PsiElement>)FunctionReference.INSTANCEOF)) != null ? newExpression.getClassReference() : (PhpReference)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)FunctionReference.INSTANCEOF);
        assert (reference != null);
        Function function = (Function)reference.resolve();
        assert (function != null);
        Parameter parameter = parameters[this.myIndex < (parameters = function.getParameters()).length ? this.myIndex : parameters.length - 1];
        assert (this.myIndex < parameters.length || parameter.isVariadic());
        parameter.getFirstChild().replace((PsiElement)PhpPsiElementFactory.createClassReference(project, this.myNewType.toString()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/type/PhpChangeParameterTypeQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/type/PhpChangeParameterTypeQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

