/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.classes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.actions.generation.PhpDocCreationOption;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.classes.PhpImplementCallMagicMethodsHandler;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAddMethodStubsQuickFix
extends PhpQuickFixBase {
    public static final String FIX_NAME = "Add method stubs";

    @NotNull
    public String getName() {
        if (FIX_NAME == null) {
            PhpAddMethodStubsQuickFix.$$$reportNull$$$0(0);
        }
        return FIX_NAME;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            PhpAddMethodStubsQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        if (project == null) {
            PhpAddMethodStubsQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            PhpAddMethodStubsQuickFix.$$$reportNull$$$0(3);
        }
        if (!((element = descriptor.getPsiElement()) instanceof PhpClass)) {
            return;
        }
        String error = PhpAddMethodStubsQuickFix.validateClass(project, (PhpClass)element);
        if (StringUtil.isNotEmpty((String)error)) {
            PhpAddMethodStubsQuickFix.showErrorMessage(project, error, element);
            return;
        }
        PhpAddMethodStubsQuickFix.addAbstractMethodsFromSuperclass((PhpClass)element, project);
    }

    private static void addAbstractMethodsFromSuperclass(PhpClass klass, @NotNull Project project) {
        if (project == null) {
            PhpAddMethodStubsQuickFix.$$$reportNull$$$0(4);
        }
        HashMap<String, Method> methodsToImplement = new HashMap<String, Method>();
        Collection methods = klass.getMethods();
        for (Method method : methods) {
            if (!method.isAbstract()) continue;
            methodsToImplement.put(method.getName(), method);
        }
        PhpClassReferenceResolver referenceResolver = new PhpClassReferenceResolver();
        referenceResolver.processElements(methodsToImplement.values());
        ArrayList<PsiElement> insertedStubs = new ArrayList<PsiElement>();
        PhpImplementCallMagicMethodsHandler magicMethodsHandler = null;
        for (Method m : PhpAddMethodStubsQuickFix.orderMethodsAsInOriginalFiles(methodsToImplement.values())) {
            if (m instanceof PhpDocMethod) {
                if (magicMethodsHandler == null) {
                    magicMethodsHandler = new PhpImplementCallMagicMethodsHandler(project, klass);
                }
                magicMethodsHandler.addDocMethod((PhpDocMethod)m);
                continue;
            }
            PsiElement inserted = PhpAddMethodStubsQuickFix.addMethodStub(klass, m);
            if (inserted == null) continue;
            insertedStubs.add(inserted);
        }
        if (magicMethodsHandler != null) {
            PsiElement overridenMethodCall;
            PsiElement docComment = magicMethodsHandler.updateClassDoc();
            if (docComment != null) {
                insertedStubs.add(docComment);
            }
            if ((overridenMethodCall = magicMethodsHandler.overrideCallMethodIfNeeded()) != null) {
                insertedStubs.add(overridenMethodCall);
            }
        }
        PhpPsiElement scopeHolder = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)klass);
        assert (scopeHolder != null);
        referenceResolver.importReferences(scopeHolder, insertedStubs);
    }

    @Nullable
    private static PsiElement addMethodStub(PhpClass klass, Method method) {
        PsiElement insertedMethod = null;
        String template = PhpCodeUtil.createOverridingMethodText(klass, method, PhpDocCreationOption.COPY_IF_ABSTRACT);
        PhpClass container = PhpCodeUtil.createClassFromMethodTemplate(klass, klass.getProject(), template);
        if (container != null) {
            for (PhpPsiElement childElement = container.getFirstPsiChild(); childElement != null; childElement = childElement.getNextSibling()) {
                ASTNode childNode = childElement.getNode();
                if (childNode == null) continue;
                if (childElement instanceof PhpDocComment) {
                    klass.addBefore((PsiElement)childElement, klass.getLastChild());
                }
                if (childNode.getElementType() != PhpStubElementTypes.CLASS_METHOD) continue;
                insertedMethod = klass.addBefore((PsiElement)childElement, klass.getLastChild());
            }
        }
        return insertedMethod;
    }

    public static Collection<Method> orderMethodsAsInOriginalFiles(Collection<Method> members) {
        members = new ArrayList<Method>(members);
        Collections.sort((List)members, (o1, o2) -> {
            PsiFile containingFile2;
            PsiElement psiElement = o1.getOriginalElement();
            PsiElement psiElement2 = o2.getOriginalElement();
            PsiFile containingFile = psiElement.getContainingFile();
            if (containingFile == (containingFile2 = psiElement2.getContainingFile())) {
                return psiElement.getTextOffset() - psiElement2.getTextOffset();
            }
            return containingFile.getName().compareTo(containingFile2.getName());
        });
        return members;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/classes/PhpAddMethodStubsQuickFix";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/classes/PhpAddMethodStubsQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAbstractMethodsFromSuperclass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

