/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.zend.messages;

import com.jetbrains.php.debug.zend.ZendDebugUtil;
import com.jetbrains.php.debug.zend.messages.GetStackVarResponse;
import com.jetbrains.php.debug.zend.messages.ZendDebugRequest;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class GetStackVarRequest
extends ZendDebugRequest<GetStackVarResponse> {
    private static final int DEFAULT_DEPTH = 1;
    private final int myStackDepth;
    private final String myVariableName;
    private final int myDepth;
    private final String[] myPath;

    public GetStackVarRequest(int stackDepth, String variableName, int depth, String[] path) {
        this.myStackDepth = stackDepth;
        this.myVariableName = variableName;
        this.myDepth = depth;
        this.myPath = path;
    }

    public GetStackVarRequest(int stackDepth, String[] path) {
        this(stackDepth, path[0], 1, new String[path.length - 1]);
        System.arraycopy(path, 1, this.myPath, 0, path.length - 1);
    }

    @Override
    public short getMessageId() {
        return 35;
    }

    @Override
    public void serialize(DataOutputStream out) throws IOException {
        super.serialize(out);
        out.writeInt(this.myStackDepth);
        ZendDebugUtil.writeString(out, this.myVariableName);
        out.writeInt(this.myDepth);
        out.writeInt(this.myPath.length);
        for (String pathElement : this.myPath) {
            ZendDebugUtil.writeString(out, pathElement);
        }
    }

    @Override
    protected void appendParameters(Map<String, String> parameters) {
        super.appendParameters(parameters);
        GetStackVarRequest.appendParameters(parameters, "stack_depth", this.myStackDepth);
        GetStackVarRequest.appendParameters(parameters, "var_name", this.myVariableName);
        GetStackVarRequest.appendParameters(parameters, "depth", this.myDepth);
        GetStackVarRequest.appendParameters(parameters, "path_length", this.myPath.length);
        GetStackVarRequest.appendParameters(parameters, "path", this.myPath);
    }
}

