/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.validation;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ResourceUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpInfoValidationMessage;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.validation.PhpDebugConfiguration;
import com.jetbrains.php.debug.validation.PhpWebServerEnvironmentConfiguration;
import com.jetbrains.php.debug.validation.PhpWebServerValidationException;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

public abstract class PhpWebServerValidator {
    private static final Logger LOG = Logger.getInstance(PhpWebServerValidator.class);
    public static final String SCRIPT_FILE = "_intellij_phpdebug_validator.php";
    private static final int RUN_HTTP_RESPONSE_TIMEOUT = 30000;
    protected static final int TEST_PERMISSIONS = 420;
    protected Project myProject;

    public PhpWebServerValidator(@NotNull Project project) {
        if (project == null) {
            PhpWebServerValidator.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public List<PhpInfoValidationMessage> validate(final @NotNull VirtualFile baseDir, @NotNull JComponent parentComponent) {
        String validationError;
        if (baseDir == null) {
            PhpWebServerValidator.$$$reportNull$$$0(1);
        }
        if (parentComponent == null) {
            PhpWebServerValidator.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        FileDocumentManager.getInstance().saveAllDocuments();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deploying validation script");
        }
        if (StringUtil.isNotEmpty((String)(validationError = this.validateWebServerConfiguration(baseDir, parentComponent)))) {
            List list = ContainerUtil.newSmartList((Object)PhpInfoValidationMessage.failed(validationError, null));
            if (list == null) {
                PhpWebServerValidator.$$$reportNull$$$0(3);
            }
            return list;
        }
        final String webPath = this.getWebPathToValidationDir(baseDir);
        if (webPath == null) {
            List list = ContainerUtil.newSmartList((Object)PhpInfoValidationMessage.failed(PhpBundle.message("php.web.server.validation.failed.to.map.deployment.folder.to.web", new Object[0]), null));
            if (list == null) {
                PhpWebServerValidator.$$$reportNull$$$0(4);
            }
            return list;
        }
        String errorMessage = this.doTestConnection();
        if (StringUtil.isNotEmpty((String)errorMessage)) {
            List list = ContainerUtil.newSmartList((Object)PhpInfoValidationMessage.failed(errorMessage, null));
            if (list == null) {
                PhpWebServerValidator.$$$reportNull$$$0(5);
            }
            return list;
        }
        final ArrayList<PhpInfoValidationMessage> messages = new ArrayList<PhpInfoValidationMessage>();
        Runnable runnable = () -> {
            if (baseDir == null) {
                PhpWebServerValidator.$$$reportNull$$$0(20);
            }
            Ref script = new Ref();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deploying validation script");
            }
            if (!this.uploadScript(baseDir, (Ref<WebServerConfig.RemotePath>)script, messages)) {
                return;
            }
            final String agentPath = PhpWebServerValidator.joinWebPath(webPath, SCRIPT_FILE);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Retrieving test results from: " + agentPath);
            }
            try {
                HttpRequests.request((String)agentPath).connectTimeout(30000).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Void process(@NotNull HttpRequests.Request request) throws IOException {
                        if (request == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        BufferedReader reader = request.getReader();
                        try {
                            String allPhpIni;
                            PhpWebServerEnvironmentConfiguration configuration = PhpWebServerEnvironmentConfiguration.parse(reader);
                            String serverName = configuration.getServerName();
                            if (StringUtil.isEmpty((String)serverName)) {
                                messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.server.name.is.empty", new Object[0]), PhpBundle.message("php.web.server.validation.server.name.is.empty.description", new Object[0])));
                            } else {
                                messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.server.name", serverName), null));
                            }
                            String phpIni = configuration.getConfigurationFile();
                            String string = allPhpIni = StringUtil.isEmptyOrSpaces((String)configuration.getAdditionalPhpIni()) ? null : PhpBundle.message("php.web.server.validation.additional.configuration.files", configuration.getAdditionalPhpIni());
                            if (StringUtil.isNotEmpty((String)phpIni)) {
                                messages.add(PhpInfoValidationMessage.info(PhpBundle.message("php.web.server.validation.configuration.files", phpIni), allPhpIni));
                            } else {
                                messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.no.configuration.files", new Object[0]), allPhpIni));
                            }
                            List<PhpDebugConfiguration> debugger = configuration.getDebugConfigurations();
                            if (debugger.isEmpty()) {
                                String description = "Follow this links to install and configure <a href=\"https://confluence.jetbrains.com/display/PhpStorm/Xdebug+Installation+Guide\">Xdebug</a> or <a href=\"https://confluence.jetbrains.com/display/PhpStorm/Zend+Debugger+Installation+Guide\">Zend Debugger</a>.<br><br>If you have already configured debug extension in php.ini file, check possible reasons why it was not loaded:<br><ol><li>You did not reload web server after changes in php.ini file.</li><li>You are configuring debug extension in the wrong php.ini (see the loaded php.ini files below).</li><li>There are errors on attempt to load debug extension, e.g. version incompatibility.</li></ol>";
                                messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.no.debugger.extension", new Object[0]), "Follow this links to install and configure <a href=\"https://confluence.jetbrains.com/display/PhpStorm/Xdebug+Installation+Guide\">Xdebug</a> or <a href=\"https://confluence.jetbrains.com/display/PhpStorm/Zend+Debugger+Installation+Guide\">Zend Debugger</a>.<br><br>If you have already configured debug extension in php.ini file, check possible reasons why it was not loaded:<br><ol><li>You did not reload web server after changes in php.ini file.</li><li>You are configuring debug extension in the wrong php.ini (see the loaded php.ini files below).</li><li>There are errors on attempt to load debug extension, e.g. version incompatibility.</li></ol>"));
                            } else if (debugger.size() > 1) {
                                String description = PhpBundle.message("php.web.server.validation.multi.debugger.extension.description", new Object[0]);
                                messages.add(PhpInfoValidationMessage.error(PhpBundle.message("php.web.server.validation.multi.debugger.extension", new Object[0]), description));
                            } else {
                                PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(PhpWebServerValidator.this.myProject).getState();
                                debugger.get(0).validate(messages, state, new URL(agentPath).getHost(), configuration.getRemoteAddr());
                            }
                        }
                        catch (PhpWebServerValidationException e) {
                            LOG.warn((Throwable)e);
                            messages.add(PhpInfoValidationMessage.failed(e.getShortMessage(), e.getDescription()));
                            messages.add(PhpWebServerValidator.this.getMessageForNotAFileException(baseDir.getPresentableUrl(), webPath, null));
                        }
                        finally {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                        return null;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/jetbrains/php/debug/validation/PhpWebServerValidator$1", "process"));
                    }
                });
            }
            catch (HttpRequests.HttpStatusException e) {
                String responseMessage = e.getMessage();
                LOG.warn("Web server validation failed due to: '" + responseMessage + "'");
                if (PhpWebServerValidator.isNotAFileException(responseMessage)) {
                    messages.add(this.getMessageForNotAFileException(baseDir.getPresentableUrl(), webPath, responseMessage));
                } else {
                    messages.add(PhpInfoValidationMessage.failed(PhpBundle.message("php.web.server.validation.failed.to.execute.script", responseMessage), null));
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                String description = "Validation script was created but it cannot be executed, check possible reasons:<br><ul><li>Configured <i>'Url to validation script'</i> is incorrect</li><li>Validated Web Server is not running.</li><li>Target directory for validation script is not public.</li></ul>";
                String message = PhpBundle.message("php.web.server.validation.failed.to.execute.script", this.getMessage(e, false));
                messages.add(PhpInfoValidationMessage.failed(message, "Validation script was created but it cannot be executed, check possible reasons:<br><ul><li>Configured <i>'Url to validation script'</i> is incorrect</li><li>Validated Web Server is not running.</li><li>Target directory for validation script is not public.</li></ul>"));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cleaning up");
            }
            this.cleanup(baseDir, (Ref<WebServerConfig.RemotePath>)script);
        };
        String title = PhpBundle.message("php.web.server.validation.process.title", new Object[0]);
        boolean complete = ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, title, true, null, parentComponent);
        if (!complete) {
            throw new ProcessCanceledException();
        }
        ArrayList<PhpInfoValidationMessage> arrayList = messages;
        if (arrayList == null) {
            PhpWebServerValidator.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    protected String getMessage(Throwable throwable, boolean full) {
        return throwable.getMessage();
    }

    @NonNls
    private static String joinWebPath(@NotNull String url, @NotNull String path) {
        if (url == null) {
            PhpWebServerValidator.$$$reportNull$$$0(7);
        }
        if (path == null) {
            PhpWebServerValidator.$$$reportNull$$$0(8);
        }
        if (!url.contains(":")) {
            url = "http://" + url;
        }
        if (url.length() > 0 && url.charAt(url.length() - 1) == '/') {
            url = url.substring(0, url.length() - 1);
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return PhpWebServerValidator.signUrlIfNecessary(url + '/' + path);
    }

    @NotNull
    private static String signUrlIfNecessary(@NotNull String fullUrl) {
        Url url;
        if (fullUrl == null) {
            PhpWebServerValidator.$$$reportNull$$$0(9);
        }
        if ((url = Urls.parseEncoded((String)fullUrl)) == null || !BuiltInServerManager.getInstance().isOnBuiltInWebServer(url)) {
            String string = fullUrl;
            if (string == null) {
                PhpWebServerValidator.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = BuiltInServerManager.getInstance().addAuthToken(url).toExternalForm();
        if (string == null) {
            PhpWebServerValidator.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    protected String doTestConnection() {
        return null;
    }

    @NotNull
    protected abstract PhpInfoValidationMessage getMessageForNotAFileException(@NotNull String var1, @NotNull String var2, @Nullable String var3);

    private static boolean isNotAFileException(@NotNull String message) {
        if (message == null) {
            PhpWebServerValidator.$$$reportNull$$$0(12);
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)message, (CharSequence)"not found")) {
            return true;
        }
        return StringUtil.endsWith((CharSequence)message, (CharSequence)"because it is a not a file.") || StringUtil.endsWith((CharSequence)message, (CharSequence)"because it is not a file.");
    }

    @Nullable
    protected abstract String validateWebServerConfiguration(@NotNull VirtualFile var1, @NotNull JComponent var2);

    protected abstract String getWebPathToValidationDir(@NotNull VirtualFile var1);

    protected boolean uploadScript(@NotNull VirtualFile baseDir, @NotNull Ref<WebServerConfig.RemotePath> script, @NotNull List<PhpInfoValidationMessage> messages) {
        if (baseDir == null) {
            PhpWebServerValidator.$$$reportNull$$$0(13);
        }
        if (script == null) {
            PhpWebServerValidator.$$$reportNull$$$0(14);
        }
        if (messages == null) {
            PhpWebServerValidator.$$$reportNull$$$0(15);
        }
        try {
            PhpWebServerValidator.execute((ThrowableRunnable<IOException>)((ThrowableRunnable)() -> {
                VirtualFile launcher;
                if (baseDir == null) {
                    PhpWebServerValidator.$$$reportNull$$$0(19);
                }
                if ((launcher = baseDir.findChild(SCRIPT_FILE)) == null) {
                    launcher = baseDir.createChildData(PhpWebServerValidator.class, SCRIPT_FILE);
                }
                String fileContent = PhpWebServerValidator.getLauncherText();
                VfsUtil.saveText((VirtualFile)launcher, (String)fileContent);
            }), true);
        }
        catch (IOException e) {
            messages.add(PhpInfoValidationMessage.failed(StringUtil.notNullize((String)this.getMessage(e, false)), null));
            LOG.warn((Throwable)e);
            return false;
        }
        return true;
    }

    protected void cleanup(@NotNull VirtualFile baseDir, @NotNull Ref<WebServerConfig.RemotePath> script) {
        if (baseDir == null) {
            PhpWebServerValidator.$$$reportNull$$$0(16);
        }
        if (script == null) {
            PhpWebServerValidator.$$$reportNull$$$0(17);
        }
        try {
            PhpWebServerValidator.execute((ThrowableRunnable<IOException>)((ThrowableRunnable)() -> {
                VirtualFile launcher;
                if (baseDir == null) {
                    PhpWebServerValidator.$$$reportNull$$$0(18);
                }
                if ((launcher = baseDir.findChild(SCRIPT_FILE)) != null) {
                    launcher.delete(PhpWebServerValidator.class);
                }
            }), false);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static void execute(ThrowableRunnable<IOException> runnable, boolean wait) throws IOException {
        Ref error = new Ref();
        Runnable r = () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                runnable.run();
            }
            catch (IOException ex) {
                error.set((Object)ex);
            }
        });
        if (wait) {
            ApplicationManager.getApplication().invokeAndWait(r);
        } else {
            ApplicationManager.getApplication().invokeLater(r);
        }
        if (!error.isNull()) {
            throw (IOException)error.get();
        }
    }

    public static String getLauncherText() {
        try {
            return ResourceUtil.loadText((URL)PhpWebServerValidator.class.getResource("/scripts/phpdebugger-validator.php"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/validation/PhpWebServerValidator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullUrl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/validation/PhpWebServerValidator";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "signUrlIfNecessary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "joinWebPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "signUrlIfNecessary";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isNotAFileException";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "uploadScript";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$cleanup$2";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$uploadScript$1";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$validate$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

