/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion.insert;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.completion.autoImport.PhpAutoImportConfiguration;
import com.jetbrains.php.completion.insert.PhpInsertHandlerUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragment;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.refactoring.PhpAliasImporter;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PhpReferenceInsertHandler
implements InsertHandler<LookupElement> {
    public static final Set<String> SPECIAL_REFERENCES = ContainerUtil.newTreeSet(String::compareToIgnoreCase);
    private static final PhpReferenceInsertHandler instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement lookupElement) {
        if (context == null) {
            PhpReferenceInsertHandler.$$$reportNull$$$0(0);
        }
        if (lookupElement == null) {
            PhpReferenceInsertHandler.$$$reportNull$$$0(1);
        }
        Object object = lookupElement.getObject();
        Project project = context.getProject();
        try {
            if (object instanceof PhpNamedElement && !(object instanceof PhpUse)) {
                PsiElement parent;
                boolean hasQualifier;
                boolean importSupported;
                PhpNamedElement aClass = (PhpNamedElement)object;
                String fqn = aClass.getFQN();
                if ("\\iterable".equals(fqn) && aClass instanceof PhpClass) {
                    return;
                }
                PsiElement element = PsiUtilCore.getElementAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset());
                PhpReference reference = (PhpReference)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)PhpReference.INSTANCEOF);
                boolean insertRootNs = true;
                if (reference != null) {
                    PhpUseList useList;
                    importSupported = PhpCodeInsightUtil.isImportSupported(reference);
                    hasQualifier = PhpCodeInsightUtil.hasQualifier(reference) ? !(element.getParent() instanceof PhpNamespaceReference) || !reference.getText().contains("\n") : (useList = PhpUseImpl.getUseList((PsiElement)reference)) != null && useList.getNamespaceReference() != null;
                } else {
                    importSupported = true;
                    PsiElement parent2 = element.getParent();
                    boolean bl = hasQualifier = parent2 instanceof PhpDocRef && parent2.getFirstChild() instanceof PhpNamespaceReference;
                }
                if (object instanceof Function || object instanceof Constant) {
                    insertRootNs = PhpReferenceInsertHandler.isPrependGlobalFunctionsAndConstants(aClass) && !SPECIAL_REFERENCES.contains(lookupElement.getLookupString());
                    importSupported = PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel().hasFeature(PhpLanguageFeature.USE_FUNCTION_AND_CONST);
                }
                if (object instanceof Constant) {
                    PhpReferenceInsertHandler.adjustConstFormat(context, (Constant)object);
                }
                String qualifiedName = fqn;
                PsiElement elementParent = element.getParent();
                boolean phpDocUseFqcn = (PhpPsiUtil.isOfType(element, PhpDocTokenTypes.DOC_IDENTIFIER) || elementParent != null && PhpPsiUtil.isOfType(elementParent.getParent(), (IElementType)PhpDocElementTypes.phpDocMethodType) || PhpCompletionContributor.isSuitableForPhpDocMethodType(elementParent)) && PhpReferenceInsertHandler.isPhpDocUseFqcn(context.getFile());
                PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator(element);
                if (scopeForUseOperator instanceof PhpExpressionCodeFragment) {
                    importSupported = false;
                }
                if (scopeForUseOperator != null && !phpDocUseFqcn) {
                    qualifiedName = PhpCodeInsightUtil.createQualifiedName(scopeForUseOperator, fqn, reference, false, false);
                    boolean hasNameConflicts = PhpCodeInsightUtil.hasNameConflicts(scopeForUseOperator, aClass);
                    if (!hasNameConflicts && PhpLangUtil.isFqn(qualifiedName) && !hasQualifier && importSupported) {
                        boolean insertImport;
                        boolean bl = insertImport = PhpCodeInsightUtil.isAutoImportEnabled(scopeForUseOperator) && (!PhpLangUtil.isGlobalNamespaceFQN(PhpLangUtil.getParentNamespaceFQN(fqn)) || PhpReferenceInsertHandler.isAutoImportFromGlobalSpace(aClass) && !SPECIAL_REFERENCES.contains(lookupElement.getLookupString()));
                        if (insertImport) {
                            PhpReferenceInsertHandler.insertImport(context, scopeForUseOperator, fqn, object);
                            qualifiedName = PhpLangUtil.toShortName(fqn);
                        }
                    }
                    if (hasNameConflicts) {
                        insertRootNs = true;
                    }
                }
                if (!hasQualifier && PhpCodeInsightUtil.hasQualifier(qualifiedName) && (insertRootNs || !PhpReferenceInsertHandler.isRootNamespace(qualifiedName) || phpDocUseFqcn)) {
                    PhpReferenceInsertHandler.insertQualifier(context, qualifiedName);
                }
                if (reference instanceof ClassReference && ((parent = reference.getParent()) instanceof ExtendsList || parent instanceof ImplementsList)) {
                    Condition[] conditionArray = new Condition[1];
                    conditionArray[0] = ImplementsList.class::isInstance;
                    if (PhpPsiUtil.isOfType(PhpPsiUtil.getNextSibling(parent, conditionArray), PhpTokenTypes.chLBRACE) && CodeStyle.getLanguageSettings((PsiFile)context.getFile(), (Language)PhpLanguage.INSTANCE).SPACE_BEFORE_CLASS_LBRACE) {
                        PhpInsertHandlerUtil.insertStringAtCaret(context, " ");
                    }
                }
            }
        }
        finally {
            PsiDocumentManager.getInstance((Project)project).commitDocument(context.getDocument());
        }
    }

    private static boolean isPrependGlobalFunctionsAndConstants(PhpNamedElement element) {
        return PhpReferenceInsertHandler.getGlobalSymbolBehavior(element) == PhpAutoImportConfiguration.GlobalSymbolBehavior.PREFER_FQN;
    }

    private static boolean isAutoImportFromGlobalSpace(PhpNamedElement element) {
        return PhpReferenceInsertHandler.getGlobalSymbolBehavior(element) == PhpAutoImportConfiguration.GlobalSymbolBehavior.PREFER_IMPORT;
    }

    private static PhpAutoImportConfiguration.GlobalSymbolBehavior getGlobalSymbolBehavior(PhpNamedElement element) {
        PhpAutoImportConfiguration.State config = PhpAutoImportConfiguration.getInstance().getState();
        if (element instanceof PhpClass) {
            return config.getGlobalClassBehavior();
        }
        if (element instanceof Function) {
            return config.getGlobalFunctionBehavior();
        }
        if (element instanceof Constant) {
            return config.getGlobalConstantBehavior();
        }
        return PhpAutoImportConfiguration.GlobalSymbolBehavior.PREFER_FALLBACK;
    }

    private static void adjustConstFormat(@NotNull InsertionContext context, @NotNull Constant constant) {
        if (context == null) {
            PhpReferenceInsertHandler.$$$reportNull$$$0(2);
        }
        if (constant == null) {
            PhpReferenceInsertHandler.$$$reportNull$$$0(3);
        }
        PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)context.getFile(), PhpCodeStyleSettings.class);
        String name = constant.getName();
        if (("true".equalsIgnoreCase(name) || "false".equalsIgnoreCase(name)) && phpSettings.UPPER_CASE_BOOLEAN_CONST || "null".equalsIgnoreCase(name) && phpSettings.UPPER_CASE_NULL_CONST) {
            int startOffset = context.getStartOffset();
            int endOffset = context.getStartOffset() + name.length();
            context.getDocument().replaceString(startOffset, endOffset, (CharSequence)name.toUpperCase());
        }
    }

    private static boolean isPhpDocUseFqcn(@NotNull PsiFile file) {
        if (file == null) {
            PhpReferenceInsertHandler.$$$reportNull$$$0(4);
        }
        return ((PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PhpCodeStyleSettings.class)).PHPDOC_USE_FQCN;
    }

    public static boolean isRootNamespace(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PhpReferenceInsertHandler.$$$reportNull$$$0(5);
        }
        return PhpLangUtil.isFqn(qualifiedName) && qualifiedName.lastIndexOf(92) == qualifiedName.indexOf(92);
    }

    private static void insertImport(@NotNull InsertionContext context, @NotNull PhpPsiElement scopeForUseOperator, @NotNull String fqn, @NotNull Object object) {
        if (context == null) {
            PhpReferenceInsertHandler.$$$reportNull$$$0(6);
        }
        if (scopeForUseOperator == null) {
            PhpReferenceInsertHandler.$$$reportNull$$$0(7);
        }
        if (fqn == null) {
            PhpReferenceInsertHandler.$$$reportNull$$$0(8);
        }
        if (object == null) {
            PhpReferenceInsertHandler.$$$reportNull$$$0(9);
        }
        Project project = context.getProject();
        PsiDocumentManager.getInstance((Project)project).commitDocument(context.getDocument());
        String keyword = object instanceof Function ? "function" : (object instanceof Constant ? "const" : null);
        PhpAliasImporter.insertUseStatementWithKeyword(keyword, fqn, null, scopeForUseOperator);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(context.getDocument());
    }

    public static void insertQualifier(@NotNull InsertionContext context, @NotNull String qualifier) {
        if (context == null) {
            PhpReferenceInsertHandler.$$$reportNull$$$0(10);
        }
        if (qualifier == null) {
            PhpReferenceInsertHandler.$$$reportNull$$$0(11);
        }
        StringBuilder textToInsertBuilder = new StringBuilder();
        String parentNamespace = PhpLangUtil.getParentQualifiedName(qualifier);
        textToInsertBuilder.append(parentNamespace);
        textToInsertBuilder.append("\\");
        context.getDocument().insertString(context.getStartOffset(), (CharSequence)textToInsertBuilder);
    }

    protected static void possiblyInsertThis(@NotNull InsertionContext context, @NotNull LookupElement lookupElement) {
        if (context == null) {
            PhpReferenceInsertHandler.$$$reportNull$$$0(12);
        }
        if (lookupElement == null) {
            PhpReferenceInsertHandler.$$$reportNull$$$0(13);
        }
        Editor editor = context.getEditor();
        int length = lookupElement.getLookupString().length();
        int startOffset = editor.getCaretModel().getOffset() - length;
        PsiElement element = context.getFile().findElementAt(startOffset);
        if (element == null || !element.isValid() || !(element.getContainingFile() instanceof PhpFile)) {
            return;
        }
        if ((element = element.getParent()) instanceof MemberReference || element instanceof PhpClassMember || element.getParent() instanceof MemberReference || element instanceof PhpDocRef) {
            return;
        }
        editor.getCaretModel().moveCaretRelatively(-length, 0, false, false, true);
        PhpClassMember classMember = (PhpClassMember)ObjectUtils.tryCast((Object)lookupElement.getObject(), PhpClassMember.class);
        if (classMember == null) {
            return;
        }
        if (classMember.getModifier().isStatic()) {
            PhpInsertHandlerUtil.insertStringAtCaret(editor, classMember instanceof Field && !((Field)classMember).isConstant() ? "self::$" : "self::");
        } else {
            PhpInsertHandlerUtil.insertStringAtCaret(editor, "$this->");
        }
        editor.getCaretModel().moveCaretRelatively(length, 0, false, false, true);
    }

    public static PhpReferenceInsertHandler getInstance() {
        return instance;
    }

    protected PhpReferenceInsertHandler() {
    }

    static {
        SPECIAL_REFERENCES.add("__FILE__");
        SPECIAL_REFERENCES.add("__LINE__");
        SPECIAL_REFERENCES.add("__CLASS__");
        SPECIAL_REFERENCES.add("__FUNCTION__");
        SPECIAL_REFERENCES.add("__METHOD__");
        SPECIAL_REFERENCES.add("__TRAIT__");
        SPECIAL_REFERENCES.add("__DIR__");
        SPECIAL_REFERENCES.add("__NAMESPACE__");
        SPECIAL_REFERENCES.add("__COMPILER_HALT_OFFSET__");
        SPECIAL_REFERENCES.add("__halt_compiler");
        SPECIAL_REFERENCES.add("array");
        SPECIAL_REFERENCES.add("list");
        SPECIAL_REFERENCES.add("die");
        SPECIAL_REFERENCES.add("exit");
        SPECIAL_REFERENCES.add("empty");
        SPECIAL_REFERENCES.add("isset");
        SPECIAL_REFERENCES.add("unset");
        SPECIAL_REFERENCES.add("eval");
        SPECIAL_REFERENCES.add("true");
        SPECIAL_REFERENCES.add("false");
        SPECIAL_REFERENCES.add("null");
        instance = new PhpReferenceInsertHandler();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeForUseOperator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/completion/insert/PhpReferenceInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustConstFormat";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isPhpDocUseFqcn";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isRootNamespace";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "insertImport";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "insertQualifier";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "possiblyInsertThis";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

