/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRecursiveCallLineMarkerProvider
extends LineMarkerProviderDescriptor {
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            PhpRecursiveCallLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            PhpRecursiveCallLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            PhpRecursiveCallLineMarkerProvider.$$$reportNull$$$0(2);
        }
        THashSet visited = ContainerUtil.newTroveSet();
        for (PsiElement element : elements) {
            ProgressManager.checkCanceled();
            PsiElement parent = element.getParent();
            if (!(parent instanceof FunctionReference) || ((PhpReference)parent).getNameNode() != element) continue;
            FunctionReference functionReference = (FunctionReference)parent;
            Statement statement = (Statement)PhpPsiUtil.getParentByCondition(parent, true, (Condition<? super PsiElement>)Statement.INSTANCEOF, (Condition<? super PsiElement>)Function.INSTANCEOF);
            if (visited.contains(statement) || !PhpRecursiveCallLineMarkerProvider.isRecursiveMethodCall(functionReference)) continue;
            visited.add(statement);
            result.add(new PhpRecursiveMethodCallMarkerInfo(element));
        }
    }

    private static boolean isRecursiveMethodCall(@NotNull FunctionReference functionReference) {
        String name;
        if (functionReference == null) {
            PhpRecursiveCallLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)(name = functionReference.getName()))) {
            return false;
        }
        if (functionReference instanceof MethodReference && !PhpRecursiveCallLineMarkerProvider.isRecursionPossible((MethodReference)functionReference)) {
            return false;
        }
        Function function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)functionReference, true, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF);
        if (function == null || !PhpLangUtil.equalsFunctionNames(name, function.getName())) {
            return false;
        }
        return functionReference.resolve() == function;
    }

    private static boolean isRecursionPossible(@NotNull MethodReference methodReference) {
        PhpExpression expression;
        if (methodReference == null) {
            PhpRecursiveCallLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if ((expression = methodReference.getClassReference()) instanceof Variable) {
            if ("this".equals(expression.getName())) {
                return true;
            }
        } else if (expression instanceof ClassReference) {
            PhpClass phpClass;
            String name = expression.getName();
            if ("self".equals(name) || "static".equals(name)) {
                return true;
            }
            if (methodReference.getReferenceType() == PhpModifier.State.STATIC && (phpClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)methodReference, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF)) != null && PhpLangUtil.equalsClassNames(name, phpClass.getName())) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getName() {
        if ("Recursive call" == null) {
            PhpRecursiveCallLineMarkerProvider.$$$reportNull$$$0(5);
        }
        return "Recursive call";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Gutter.RecursiveMethod;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/PhpRecursiveCallLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/PhpRecursiveCallLineMarkerProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRecursiveMethodCall";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isRecursionPossible";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    public static class PhpRecursiveMethodCallMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private PhpRecursiveMethodCallMarkerInfo(@NotNull PsiElement functionReference) {
            if (functionReference == null) {
                PhpRecursiveMethodCallMarkerInfo.$$$reportNull$$$0(0);
            }
            super(functionReference, functionReference.getTextRange(), AllIcons.Gutter.RecursiveMethod, 11, reference -> "Recursive call", null, GutterIconRenderer.Alignment.RIGHT);
        }

        public GutterIconRenderer createGutterRenderer() {
            return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                public AnAction getClickAction() {
                    return null;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionReference", "com/jetbrains/php/codeInsight/PhpRecursiveCallLineMarkerProvider$PhpRecursiveMethodCallMarkerInfo", "<init>"));
        }
    }
}

