/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.associations.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.IconUtil;
import org.intellij.lang.xpath.xslt.associations.FileAssociationsManager;
import org.intellij.lang.xpath.xslt.associations.impl.AnyXMLDescriptor;
import org.intellij.lang.xpath.xslt.associations.impl.AssociationsGroup;
import org.jetbrains.annotations.NotNull;

class AddAssociationAction
extends AnAction {
    private final FileAssociationsManager myManager;

    AddAssociationAction(FileAssociationsManager manager) {
        super("Add...", "Add File Association", IconUtil.getAddIcon());
        this.myManager = manager;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiFile psiFile;
        if (e == null) {
            AddAssociationAction.$$$reportNull$$$0(0);
        }
        if ((psiFile = AssociationsGroup.getPsiFile(e)) == null) {
            return;
        }
        this.addAssociation(psiFile);
        DaemonCodeAnalyzer.getInstance((Project)psiFile.getProject()).restart(psiFile);
    }

    protected void addAssociation(PsiFile psiFile) {
        final VirtualFile virtualFile = psiFile.getVirtualFile();
        assert (virtualFile != null);
        AnyXMLDescriptor descriptor = new AnyXMLDescriptor(true){

            public boolean isFileSelectable(VirtualFile file) {
                return super.isFileSelectable(file) && !file.equals(virtualFile);
            }
        };
        VirtualFile[] virtualFiles = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)psiFile.getProject(), (VirtualFile)psiFile.getVirtualFile());
        if (virtualFiles.length == 0) {
            return;
        }
        for (VirtualFile file : virtualFiles) {
            assert (!virtualFile.equals(file));
            this.myManager.addAssociation(psiFile, file);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/lang/xpath/xslt/associations/impl/AddAssociationAction", "actionPerformed"));
    }
}

