/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.calculation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class V8LineReader {
    public static final String BUF_SIZE_KEY = "node.js.v8.cpu.profiling.line.buf.size";
    private final byte[] myBuf;
    private final InputStream myInputStream;

    public V8LineReader(@NotNull InputStream in) {
        if (in == null) {
            V8LineReader.$$$reportNull$$$0(0);
        }
        this.myBuf = new byte[Integer.getInteger(BUF_SIZE_KEY, 20000).intValue()];
        this.myInputStream = in;
    }

    public void readLines(@NotNull ThrowableConsumer<String, IOException> consumer, Charset charset) throws IOException {
        if (consumer == null) {
            V8LineReader.$$$reportNull$$$0(1);
        }
        int off = 0;
        int size = 0;
        while (size >= 0 && ((size = this.myInputStream.read(this.myBuf, off, this.myBuf.length - off)) >= 0 || off != 0)) {
            String str = new String(this.myBuf, 0, size < 0 ? off : size + off, charset);
            off = 0;
            String[] lines = StringUtil.splitByLines((String)str.trim(), (boolean)true);
            if (lines.length == 0) continue;
            String last = lines[lines.length - 1];
            int linesSize = lines.length - 1;
            if (str.endsWith("\n") || str.endsWith("\r") || lines.length <= 1) {
                ++linesSize;
                last = null;
            }
            for (int i = 0; i < linesSize; ++i) {
                consumer.consume((Object)lines[i]);
            }
            if (last == null) continue;
            if (size < 0) {
                if (StringUtil.isEmptyOrSpaces((String)last)) break;
                consumer.consume((Object)last);
                break;
            }
            byte[] lastBytes = last.getBytes(charset);
            off = lastBytes.length;
            System.arraycopy(lastBytes, 0, this.myBuf, 0, off);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8LineReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readLines";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

