/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.boilerplate.express;

import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.packageJson.NpmRegistryService;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.boilerplate.express.NodePackageVersion;
import com.jetbrains.nodejs.boilerplate.express.NodePackageVersionList;
import com.jetbrains.nodejs.boilerplate.express.NodePackageVersionListener;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageVersionView {
    private final String myPackageName;
    private final NodePackageVersionListener myListener;
    private final ComboBox<NodePackageVersion> myComboBox;
    private final JPanel myRefreshPanel;
    private Status myCurrentStatus;
    private final Ref<NodePackageVersion> myLastExpressVersionRef;
    private boolean myFirstUpdate;

    public NodePackageVersionView(@NotNull String packageName, @NotNull NodePackageVersionListener listener) {
        if (packageName == null) {
            NodePackageVersionView.$$$reportNull$$$0(0);
        }
        if (listener == null) {
            NodePackageVersionView.$$$reportNull$$$0(1);
        }
        this.myLastExpressVersionRef = Ref.create(null);
        this.myFirstUpdate = true;
        this.myPackageName = packageName;
        this.myListener = listener;
        this.myComboBox = this.createComboBox();
        this.myRefreshPanel = new JPanel(new CardLayout(0, 0));
        this.addRefreshCard(Status.READY_TO_REFRESH, this.createRefreshActionComponent());
        this.addRefreshCard(Status.REFRESHING, NodePackageVersionView.createRefreshingComponent(this.myPackageName));
        this.setStatus(Status.READY_TO_REFRESH);
        this.myComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NodePackageVersionView.this.fireSelectedVersionUpdatedEventIfNeeded();
            }
        });
    }

    @NotNull
    private ComboBox<NodePackageVersion> createComboBox() {
        ComboBox comboBox = new ComboBox();
        comboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<NodePackageVersion>(){

            public void customize(JList list, NodePackageVersion value, int index, boolean selected, boolean hasFocus) {
                String text = value != null ? value.getRawVersion() : (NodePackageVersionView.this.isLoadingVersions() ? "Loading..." : "Unavailable");
                this.setText(text);
            }
        });
        SwingHelper.setPreferredWidth((Component)comboBox, (int)JBUI.scale((int)120));
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            NodePackageVersionView.$$$reportNull$$$0(2);
        }
        return comboBox2;
    }

    private void addRefreshCard(@NotNull Status status, @NotNull Component child) {
        if (status == null) {
            NodePackageVersionView.$$$reportNull$$$0(3);
        }
        if (child == null) {
            NodePackageVersionView.$$$reportNull$$$0(4);
        }
        this.myRefreshPanel.add(child, status.name());
    }

    @NotNull
    private Component createRefreshActionComponent() {
        AnAction reloadAction = new AnAction("Reload " + this.myPackageName + " versions", null, AllIcons.Actions.Refresh){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                NodePackageVersionView.this.asyncUpdateVersions();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ActionButton actionButton = new ActionButton(reloadAction, reloadAction.getTemplatePresentation().clone(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        if (actionButton == null) {
            NodePackageVersionView.$$$reportNull$$$0(5);
        }
        return actionButton;
    }

    @NotNull
    private static Component createRefreshingComponent(@NotNull String packageName) {
        if (packageName == null) {
            NodePackageVersionView.$$$reportNull$$$0(6);
        }
        AsyncProcessIcon icon = new AsyncProcessIcon(packageName + " versions loading");
        icon.setToolTipText("Updating " + packageName + " package versions");
        AsyncProcessIcon asyncProcessIcon = icon;
        if (asyncProcessIcon == null) {
            NodePackageVersionView.$$$reportNull$$$0(7);
        }
        return asyncProcessIcon;
    }

    private void fireSelectedVersionUpdatedEventIfNeeded() {
        NodePackageVersion newVersion = this.getVersion();
        NodePackageVersion lastVersion = (NodePackageVersion)this.myLastExpressVersionRef.get();
        if (newVersion == null || !newVersion.equals(lastVersion)) {
            this.myListener.onVersionSelected(newVersion);
            this.myLastExpressVersionRef.set((Object)newVersion);
        }
    }

    private void setStatus(@NotNull Status status) {
        if (status == null) {
            NodePackageVersionView.$$$reportNull$$$0(8);
        }
        CardLayout layout = (CardLayout)this.myRefreshPanel.getLayout();
        layout.show(this.myRefreshPanel, status.name());
        if (this.myCurrentStatus != status) {
            this.myComboBox.repaint();
            this.myCurrentStatus = status;
        }
    }

    boolean isLoadingVersions() {
        return this.myCurrentStatus == Status.REFRESHING;
    }

    @Nullable
    public NodePackageVersion getVersion() {
        return (NodePackageVersion)ObjectUtils.tryCast((Object)this.myComboBox.getSelectedItem(), NodePackageVersion.class);
    }

    @NotNull
    public ComboBox getComboBox() {
        ComboBox<NodePackageVersion> comboBox = this.myComboBox;
        if (comboBox == null) {
            NodePackageVersionView.$$$reportNull$$$0(9);
        }
        return comboBox;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.add((Component)this.myComboBox);
        panel.add(Box.createHorizontalStrut(JBUI.scale((int)5)));
        panel.add(this.myRefreshPanel);
        JPanel jPanel = panel;
        if (jPanel == null) {
            NodePackageVersionView.$$$reportNull$$$0(10);
        }
        return jPanel;
    }

    public void update() {
        if (this.myFirstUpdate) {
            this.setStatus(Status.REFRESHING);
        }
        this.myFirstUpdate = false;
        this.asyncUpdateVersions();
    }

    private void asyncUpdateVersions() {
        this.setStatus(Status.REFRESHING);
        NpmRegistryService.getInstance().asyncUpdateAndGetPackageVersions(this.myPackageName).onProcessed(versions -> UIUtil.invokeLaterIfNeeded(() -> this.setVersions((AvailablePackageVersions)versions)));
    }

    private void setVersions(@Nullable AvailablePackageVersions versions) {
        if (versions != null) {
            List rawVersions = ContainerUtil.map((Collection)versions.getVersions(), ver -> ver.getRawVersion());
            SemVer latest = versions.findVersionByDistTag("latest");
            NodePackageVersionList versionList = NodePackageVersionList.create(rawVersions, latest != null ? latest.getRawVersion() : null);
            ImmutableList<NodePackageVersion> newSortedVersions = versionList.getVersionsInDecreasingOrder();
            NodePackageVersion newSelectedVersion = null;
            for (NodePackageVersion version : newSortedVersions) {
                if (!version.isStable()) continue;
                if (newSelectedVersion == null) {
                    newSelectedVersion = version;
                }
                if (!version.isSelectByDefault()) continue;
                newSelectedVersion = version;
                break;
            }
            SwingHelper.updateItems(this.myComboBox, newSortedVersions, newSelectedVersion);
        }
        this.setStatus(Status.READY_TO_REFRESH);
        this.fireSelectedVersionUpdatedEventIfNeeded();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createComboBox";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createRefreshActionComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createRefreshingComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComboBox";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addRefreshCard";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRefreshingComponent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setStatus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum Status {
        READY_TO_REFRESH,
        REFRESHING;

    }
}

