/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.ECMA6SyntaxHighlighterFactory;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        DialectOptionHolder optionHolder = (DialectOptionHolder)ObjectUtils.coalesce((Object)JSSyntaxHighlighterFactory.detectDialectFromVirtualFile(project, virtualFile), (Object)JavascriptLanguage.E4X_OPTION_HOLDER);
        JSHighlighter jSHighlighter = optionHolder.isECMA6 ? new ECMA6SyntaxHighlighterFactory.ECMA6SyntaxHighlighter(optionHolder, false) : new JSHighlighter(optionHolder, false);
        if (jSHighlighter == null) {
            JSSyntaxHighlighterFactory.$$$reportNull$$$0(0);
        }
        return jSHighlighter;
    }

    @Nullable
    protected static DialectOptionHolder detectDialectFromVirtualFile(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        if (virtualFile == null || project == null) {
            return null;
        }
        JSLanguageDialect languageDialect = DialectDetector.getLanguageDialect(virtualFile, project);
        return languageDialect != null ? languageDialect.getOptionHolder() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSSyntaxHighlighterFactory", "getSyntaxHighlighter"));
    }
}

