/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.intellij.javascript.nodejs.packageJson.PackageJsonNotifierConfiguration;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public class DefaultPackageJsonNotifierConfiguration
implements PackageJsonNotifierConfiguration {
    private final Project myProject;
    private final ProjectFileIndex myFileIndex;

    public DefaultPackageJsonNotifierConfiguration(@NotNull Project project, @NotNull ProjectFileIndex fileIndex) {
        if (project == null) {
            DefaultPackageJsonNotifierConfiguration.$$$reportNull$$$0(0);
        }
        if (fileIndex == null) {
            DefaultPackageJsonNotifierConfiguration.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myFileIndex = fileIndex;
    }

    @Override
    @NotNull
    public Promise<List<VirtualFile>> detectPackageJsonFiles() {
        ArrayList packageJsonFiles = new ArrayList();
        ReadAction.run(() -> {
            if (!this.myProject.isDisposed()) {
                for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                    for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(contentRoot);
                        if (packageJson == null) continue;
                        packageJsonFiles.add(packageJson);
                    }
                }
            }
        });
        Promise promise = Promise.resolve(packageJsonFiles);
        if (promise == null) {
            DefaultPackageJsonNotifierConfiguration.$$$reportNull$$$0(2);
        }
        return promise;
    }

    @Override
    public boolean isEssential(@NotNull VirtualFile packageJson) {
        VirtualFile parent;
        if (packageJson == null) {
            DefaultPackageJsonNotifierConfiguration.$$$reportNull$$$0(3);
        }
        if ((parent = packageJson.getParent()) == null) {
            return false;
        }
        VirtualFile contentRoot = this.myFileIndex.getContentRootForFile(parent, false);
        return parent.equals(contentRoot);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/DefaultPackageJsonNotifierConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/DefaultPackageJsonNotifierConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "detectPackageJsonFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEssential";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

