/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.intellij.docker.remote.DockerCredentialsEditor;
import com.intellij.docker.remote.DockerCredentialsHandler;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.DockerEditableCredentialsContribution;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.ext.CredentialsEditor;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.intellij.remote.ext.CredentialsTypeEx;
import com.intellij.remote.ext.RemoteCredentialsHandler;
import com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkForm;
import com.jetbrains.plugins.remotesdk.ui.CredentialsEditorProvider;
import com.jetbrains.plugins.remotesdk.ui.StatusPanel;
import org.jetbrains.annotations.Nullable;

public class DockerCredentialsType
extends CredentialsTypeEx<DockerCredentialsHolder>
implements CredentialsEditorProvider {
    public static final String DOCKER_PREFIX = "docker://";
    public static final Key<DockerCredentialsHolder> DOCKER_CREDENTIALS = Key.create((String)"DOCKER_CREDENTIALS");

    public static DockerCredentialsType getInstance() {
        return (DockerCredentialsType)((Object)CredentialsTypeEx.EP_NAME.findExtension(DockerCredentialsType.class));
    }

    public DockerCredentialsType() {
        super("Docker", DOCKER_PREFIX);
    }

    public Key<DockerCredentialsHolder> getCredentialsKey() {
        return DOCKER_CREDENTIALS;
    }

    public RemoteCredentialsHandler getHandler(DockerCredentialsHolder credentials) {
        return new DockerCredentialsHandler(credentials);
    }

    public DockerCredentialsHolder createCredentials() {
        return new DockerCredentialsHolder();
    }

    public boolean isAvailable(CredentialsLanguageContribution languageContribution) {
        return languageContribution instanceof DockerEditableCredentialsContribution;
    }

    public CredentialsEditor createEditor(@Nullable Project project, CredentialsLanguageContribution languageContribution, StatusPanel statusPanel) {
        return new DockerCredentialsEditor(languageContribution, statusPanel);
    }

    public String getDefaultInterpreterPath(CreateRemoteSdkForm.BundleAccessor bundleAccessor) {
        return bundleAccessor.message("remote.interpreter.docker.default.interpreter.path", new Object[0]);
    }

    public RemoteCredentials createRemoteCredentials(DockerCredentialsHolder credentials) {
        throw new UnsupportedOperationException("Docker SDK could not produce Remote SDK credentials");
    }

    public boolean useRemoteCredentials() {
        return false;
    }

    public boolean isBrowsingAvailable() {
        return false;
    }
}

