/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.syntax.MutableSyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.regex.RegexFacade;

class SyntaxNodeDescriptorImpl
implements MutableSyntaxNodeDescriptor {
    private static final Logger LOG = Logger.getInstance(SyntaxNodeDescriptor.class);
    private final Map<String, String> myStringAttributes = ContainerUtil.newHashMap();
    private final Map<String, RegexFacade> myRegexAttributes = ContainerUtil.newHashMap();
    private final Map<String, Plist> myPlistAttributes = ContainerUtil.newHashMap();
    private final List<SyntaxNodeDescriptor> myChildren = ContainerUtil.newArrayList();
    private final Map<String, SyntaxNodeDescriptor> myRepository = ContainerUtil.newHashMap();
    private final SyntaxNodeDescriptor myParentNode;
    private String myScopeName = "";

    SyntaxNodeDescriptorImpl(@Nullable SyntaxNodeDescriptor parentNode) {
        this.myParentNode = parentNode;
    }

    @Override
    public void setStringAttribute(String key, String value) {
        this.myStringAttributes.put(key, value);
    }

    @Override
    @Nullable
    public String getStringAttribute(String key) {
        return this.myStringAttributes.get(key);
    }

    @Override
    public void setPlistAttribute(String key, Plist value) {
        this.myPlistAttributes.put(key, value);
    }

    @Override
    @Nullable
    public Plist getPlistAttribute(String key) {
        return this.myPlistAttributes.get(key);
    }

    @Override
    public void setRegexAttribute(String key, RegexFacade value) {
        this.myRegexAttributes.put(key, value);
    }

    @Override
    @Nullable
    public RegexFacade getRegexAttribute(String key) {
        return this.myRegexAttributes.get(key);
    }

    @Override
    public void addChild(SyntaxNodeDescriptor descriptor) {
        this.myChildren.add(descriptor);
    }

    @Override
    @NotNull
    public List<SyntaxNodeDescriptor> getChildren() {
        List<SyntaxNodeDescriptor> list = this.myChildren;
        if (list == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public void appendRepository(String key, SyntaxNodeDescriptor descriptor) {
        this.myRepository.put(key, descriptor);
    }

    @Override
    public void setScopeName(@NotNull String scopeName) {
        if (scopeName == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(1);
        }
        this.myScopeName = scopeName;
    }

    @Override
    @NotNull
    public SyntaxNodeDescriptor findInRepository(String key) {
        SyntaxNodeDescriptor syntaxNodeDescriptor = this.myRepository.get(key);
        if (syntaxNodeDescriptor == null && this.myParentNode != null) {
            SyntaxNodeDescriptor syntaxNodeDescriptor2 = this.myParentNode.findInRepository(key);
            if (syntaxNodeDescriptor2 == null) {
                SyntaxNodeDescriptorImpl.$$$reportNull$$$0(2);
            }
            return syntaxNodeDescriptor2;
        }
        if (syntaxNodeDescriptor == null) {
            LOG.warn("Can't find repository '" + key + "'");
            SyntaxNodeDescriptor syntaxNodeDescriptor3 = EMPTY_NODE;
            if (syntaxNodeDescriptor3 == null) {
                SyntaxNodeDescriptorImpl.$$$reportNull$$$0(3);
            }
            return syntaxNodeDescriptor3;
        }
        SyntaxNodeDescriptor syntaxNodeDescriptor4 = syntaxNodeDescriptor;
        if (syntaxNodeDescriptor4 == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(4);
        }
        return syntaxNodeDescriptor4;
    }

    @Override
    @NotNull
    public String getScopeName() {
        String string = this.myScopeName;
        if (string == null) {
            SyntaxNodeDescriptorImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @Nullable
    public SyntaxNodeDescriptor getParentNode() {
        return this.myParentNode;
    }

    public String toString() {
        String name = this.myStringAttributes.get("name");
        return name != null ? "Syntax rule: " + name : super.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptorImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptorImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findInRepository";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setScopeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

