<?php
SOY2::import("util.CMSFileManager");
class FileActionPage extends CMSWebPageBase{
	
	const ACTION_LIST 		= 10;
	const ACTION_LIST_ALL	= 15;
	const ACTION_TREE 		= 20;
	const ACTION_DETAIL 	= 30;
	const ACTION_MKDIR 		= 40;
	const ACTION_RENAME 	= 50;
	const ACTION_DELETE 	= 60;
	const ACTION_UPLOAD 	= 70;
	const ACTION_SEARCH		= 80;
	const ACTION_RELOAD		= 90;
	
	var $action;
	
	function doPost(){
		global $site;
		
		//error_reporting(0);
		
		$dir = UserInfoUtil::getSiteDirectory();
		$root = str_replace("\\",'/',realpath(UserInfoUtil::getSiteDirectory()));
		
		switch ($this->action) {
			case self::ACTION_MKDIR:
				if(!soy2_check_token()) exit;
				
				$id = $_POST["id"];
				$file = CMSFileManager::get($root,$id);
				
				$name = $_POST["name"];
				
				$result = CMSFileManager::makeDirectory($root,$id,$name) ? "OK" : "NG" ;
				echo '{"text":"'.$result.'","soy2_token":"'.soy2_get_token().'"}';
				
				break;
			case self::ACTION_DELETE:
				if(!soy2_check_token()) exit;
				
				$id = $_POST["id"];
				$parentId = CMSFileManager::delete($root,$id);
				
				echo '{"text":"file:'.$parentId.'","soy2_token":"'.soy2_get_token().'"}';
				
				break;
			case self::ACTION_RENAME:
				
				$id = $_POST["renameId"];
				$newName = $_POST["newName"];
				
				//if success
				echo "OK";
				
				//if failed					
						
				break;
			case self::ACTION_SEARCH:
				$query = $_POST["q"];
				
				$queries = explode(" ",$query);
				
				CMSFileManager::search($queries);		
				
				break;
			case self::ACTION_UPLOAD:

				$id     = @$_POST["id"];
				$upload = @$_FILES['file'];
				$result = false;

				if(soy2_check_token()){
				$a="soy2checkOK";
				if($id && $upload){
					$site = UserInfoUtil::getSite();
			    	$url = (UserInfoUtil::getSiteURLBySiteId($site->getId()) != $site->getUrl() ) ? $site->getUrl() : null;
			    	CMSFileManager::setSiteInformation($site->getId(), $url, $site->getPath());
	    			$result = CMSFileManager::upload($root,$id,$upload);
				}
				}else{				$a="soy2checkNG";}
					
				
				echo '<html>';
				echo '<head>';
				echo '<script type="text/javascript"><!--'."\n";
				echo 'window.onload=function(){';
				echo 'window.parent.CMS_FileManager.soy2_token = "'.soy2_get_token().'";';
				echo 'window.parent.uploadFinish("file:'.$id.'",'.(int)$result.');';echo "//".$a."\n";
				echo '}'."\n";
				echo '--></script>';
				echo '</head>';
				echo '<body>';
				echo '</body>';
				echo '</html>';
				
				exit;
				
				break;
			case self::ACTION_DETAIL:
				$id = $_POST["id"];
				CMSFileManager::printJson($root,$id);
							
				break;
			case self::ACTION_TREE:
				$id = $_POST["id"];
				CMSFileManager::printTreeNode($root,false,$id);
				
				break;
			case self::ACTION_LIST_ALL:
				$id = $_POST["id"];
				$list = CMSFileManager::getAllFile($root,$id);
				
				$result = array();
				
				$siteUrl = UserInfoUtil::getSiteURL();
				$siteDir = UserInfoUtil::getSiteDirectory();
				
				foreach($list as $key => $file){
					if($file->isDir()){
						$list[$key] = null;
						unset($list[$key]);
						continue;					
					}
					
					if(defined("SOYCMS_ASP_MODE")){
						$path = "/" . str_replace($siteUrl,"",$file->getUrl());
					}else{
						$path = $file->getUrl();
					}
					
					$result[] = array(
						"id" => $file->getId(),
						"path" => $path,
						"url" => $file->getUrl()
					);
				}
				
				echo json_encode($result);				
				break;
			case self::ACTION_RELOAD:
				$id = $_POST["id"];
				
				SOY2::import("util.CMSFileManager");
					
				CMSFileManager::rebuildTree($root, $id);

				echo soy2_get_token();

				break;
			case self::ACTION_LIST:
			default:			
				$id = $_POST["id"];
				CMSFileManager::printList($root,$id);
				break;
		}
		
		exit;
	
	}
	
    function FileActionPage($args) {
    	$this->action = $args[0];

    	//WebPage::WebPage();
    	$this->doPost();
    }
    
    function createThumbnail($url){
    	
    	$height = null;
    	$width = 100;
    	
    	$extension = preg_replace("/.*\.([a-zA-Z]*)$/",'$1',$url);
		
		$img = null;
	    switch(true){
    		case ('jpg' == strtolower($extension)):
    		case ('jpeg' == strtolower($extension)):
    			$header = 'Content-type: image/jpeg';
    			$img = @imagecreatefromjpeg($url);
    			$functionName = 'imagejpeg';
    			break;
    		case ('gif' == strtolower($extension)):
    			$header = 'Content-type: image/gif';
    			$img = @imagecreatefromgif($url);
    			$functionName = 'imagegif';
    			break;
    		case ('png' == strtolower($extension)):
    			$header = 'Content-type: image/png';
    			$img = @imagecreatefrompng($url);
    			$functionName = 'imagepng';
    			break;
    	}
    	
    	
    	//画像が無かった場合
		if(!$img){
			header($header);
			echo file_get_contents($url);
			exit;				
		}
		
		$tempImage = $img;
			
		//新しい画像の大きさを決める。
		list($oldSize['height'],$oldSize['width']) = array(imagesy($tempImage),imagesx($tempImage));
		$newSize = array();
		if($height && $width){
			$newSize['height'] = $height;
			$newSize['width'] = $width;
		}else if($height){
			$newSize['height'] = $height;
			$newSize['width'] = $oldSize['width'] * $height / $oldSize['height'];
		}else if($width){
			$newSize['height'] = $oldSize['height'] * $width / $oldSize['width'];
			$newSize['width'] = $width;
		}else{
			$newSize = $oldSize;
		}
		
		if($newSize['height'] >= $oldSize['height'] && $newSize['width'] >= $oldSize['width']){
			$newSize = $oldSize;
		}
		
		$dst = imagecreatetruecolor($newSize['width'],$newSize['height']);
		$alpha = imagecolorallocate($dst, 255, 255, 255); // 色の作成
		imagefill($dst, 0, 0, $alpha);                    // 指定色で塗りつぶし
		imagecolortransparent($dst, $alpha);              // 指定色を透明色に
		imagecolordeallocate($dst, $alpha);               // 色リソースの開放
		imagesavealpha($dst, TRUE);
		
		imagecopyresized($dst,$tempImage,0,0,0,0,$newSize['width'],$newSize['height'],$oldSize['width'],$oldSize['height']);
	
		header($header);
		imagepng($dst);
    }
}
?>