# Building native libraries

The native library part of JNA needs to be rebuild when the embedded copy of
libffi is updated or the gluecode is updated/bugfixed.

## Supported build architectures and instructions

### Linux

The linux binaries are build in various debian and Ubuntu chroots. The setup
can be found her: https://github.com/matthiasblaesing/docker-jna-build

The build assumes, that the packages to be build are prepared using the
`prepare-build-libraries.sh` script, which exports zip files with the native
code for:

- Linux aarch64
- Linux arm hardfloat
- Linux arm softfloat
- Linux mips64el
- Linux ppc
- Linux ppc64le
- Linux riscv64
- Linux s390x
- Linux x86-64
- Linux x86

### AIX

The AIX binaries are build on cfarm (https://portal.cfarm.net/) for AIX ppc and
ppc64. Basis are the build packages generated by `prepare-build-libraries.sh`,
see the Linux section. The host is `cfarm111.cfarm.net`. The packages
autoconf (2.71), libtool (2.4.7) and m4 (1.4.19) are installed in the home
folder.

1. Copy the build packages for `aix-ppc` and `aix-ppc64` to the host using scp
   `scp build-package-aix-ppc* user@cfarm111.cfarm.net:`
2. ssh to the host
3. Unzip the packages `for i in *.zip; do unzip $i; done`
4. Setup the environment:
   ```bash
   # Ensure `gmake` is used
   export MAKE=gmake
   # Place local binaries on the path
   export PATH=/home/$USER/local/bin:$PATH
   # Ensure working ARFLAGS are used
   export ARFLAGS='-X32_64 cru'
   ```
5. Build 32bit:
   ```bash
   # Reference the 32bit JKD 6
   export JAVA_HOME=/usr/java6
   # Build
   cd build-package-aix-ppc-7.0.2
   bash build.sh
   # Copy result
   cp aix-ppc.jar ../
   cd ..
   ```
6. Build 64bit:
   ```bash
   # Reference the 64bit JKD 7
   export JAVA_HOME=/usr/java7_64
   # Build
   cd build-package-aix-ppc64-7.0.2
   bash build.sh
   # Copy result
   cp aix-ppc64.jar ../
   cd ..
   ```
7. Cleanup: `rm -r build-package-aix-ppc-7.0.2 build-package-aix-ppc-7.0.2.zip build-package-aix-ppc64-7.0.2 build-package-aix-ppc64-7.0.2.zip`
8. Exit build system: `exit`
9. Copy binaries to local system `scp "user@cfarm111.cfarm.net:*.jar" lib/native`

### Darwin / mac OS

Darwin binaries are build for x86-64bit and aarch64 on github using the
corresponding pipeline.

### Android

Android binaries are build using the Android NDK r12b for:

- Android aarch64
- Android armv7
- Android arm
- Android mips64
- Android mips
- Android x86-64
- Android x86

The documentation can be found in `AndroidDevelopmentEnvironment.md`.

### Solaris

Build on the opencsw buildfarm https://www.opencsw.org/.

1. Copy the build packages for `solaris` to the host using scp
   `scp build-package-sunos-* user@login.opencsw.org:`
2. Login to the gateway system `ssh user@login.opencsw.org`
3. Unzip the packages `for i in *.zip; do unzip $i; done`
4. SSH to the sparc build system `ssh unstable11s`
5. Setup the environment:
   ```bash
   # Ensure `gmake` is used
   export MAKE=gmake
   # Place local binaries on the path
   export PATH=$HOME/local/bin:$PATH
6. Build 32bit:
   ```bash
   # Reference the 32bit JKD 7
   export JAVA_HOME=/opt/csw/java/jdk1.7.0_80
   # Build
   cd build-package-sunos-sparc-7.0.2/native/libffi
   bash autogen.sh
   ./configure
   cd ../..
   bash build.sh
   # Copy result
   cp sunos-sparc.jar ../
   cd ..
   ```
7. Build 64bit:
   ```bash
   # Reference the 64bit JKD 8
   export JAVA_HOME=/opt/csw/java/jdk1.8.0_201
   # Build
   cd build-package-sunos-sparcv9-7.0.2/native/libffi
   bash autogen.sh
   ./configure
   cd ../..
   bash build.sh
   # Copy result
   cp sunos-sparcv9.jar ../
   cd ..
   ```
8. Switch to the x86 build system:
   ```bash
   logout
   ssh unstable11x
   ```
9. Setup the environment:
   ```bash
   # Ensure `gmake` is used
   export MAKE=gmake
   # Place local binaries on the path
   export PATH=$HOME/local/bin:$PATH
10. Build 32bit:
    ```bash
    # Reference the 32bit JKD 7
    export JAVA_HOME=/opt/csw/java/jdk1.7.0_80
    # Build
    cd build-package-sunos-x86-7.0.2/native/libffi
    bash autogen.sh
    ./configure
    cd ../..
    bash build.sh
    # Copy result
    cp sunos-x86.jar ../
    cd ..
    ```
11. Build 64bit:
    ```bash
    # Reference the 64bit JKD 8
    export JAVA_HOME=/opt/csw/java/jdk1.8.0_201
    # Build
    cd build-package-sunos-x86-64-7.0.2/native/libffi
    bash autogen.sh
    ./configure
    cd ../..
    bash build.sh
    # Copy result
    cp sunos-x86-64.jar ../
    cd ..
    ```
12. Return to login system `logout`
13. Cleanup: `rm -r build-package-sunos-sparc-7.0.2 build-package-sunos-sparc-7.0.2.zip build-package-sunos-sparcv9-7.0.2 build-package-sunos-sparcv9-7.0.2.zip build-package-sunos-x86-64-7.0.2 build-package-sunos-x86-64-7.0.2.zip build-package-sunos-x86-7.0.2 build-package-sunos-x86-7.0.2.zip`
14. Exit build system: `exit`
14. Copy binaries to local system: `scp "user@login.opencsw.org:*.jar" lib/native/`

### Windows

Build on a native x86 64bit system. x86 32bit and x86 64bit are build natively,
windows aarch64 is crossbuild.

The documentation can be found in `WindowsDevelopmentEnvironment.md`.

### FreeBSD

Binaries are build natively in VM Images of FreeBSD 13.2 (see `FreeBSD.md`)

Builds are done for:

- aarch64
- x86
- x86-64

### Dragonfly BSD

Binaries are build natively in a 6.4.0 x86-64 VM installed from the ISO Image:

https://www.dragonflybsd.org/download/

```bash
rsync -av --exclude=.git USER@BUILD_HOST:src/jnalib/ jnalib/
chmod +x jnalib/native/libffi/configure jnalib/native/libffi/install-sh
cd jnalib
ant
```

### OpenBSD

Binaries are build in VMs for

- x86
- x86-64

They are build using the build-packages generated as part of the Linux build

```
scp user@BUILD_HOST:src/jnalib/build/build-package-openbsd-x86-7.0.2.zip .
unzip build-package-openbsd-x86-7.0.2.zip
cd build-package-openbsd-x86-7.0.2
export JAVA_HOME=/usr/local/jdk-1.8.0
export MAKE=gmake
sh build.sh
scp openbsd-x86.jar user@BUILD_HOST:src/jnalib/lib/native
```

```
scp user@BUILD_HOST:src/jnalib/build/build-package-openbsd-x86-64-7.0.2.zip .
unzip build-package-openbsd-x86-7.0.2.zip
cd build-package-openbsd-x86-7.0.2
export JAVA_HOME=/usr/local/jdk-1.8.0
export MAKE=gmake
sh build.sh
scp openbsd-x86-64.jar user@BUILD_HOST:src/jnalib/lib/native
```