/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SmartStickyListener<T>
implements PropertyChangeListener {
    private SmartStickyListener<?> nextNode = null;
    private final AtomicBoolean overriding = new AtomicBoolean(false);
    private String recordKey;
    private String propKey;
    private static final String LISTENER_KEY = "SmartStickyListeners";

    public SmartStickyListener(String recordKey, String propKey) {
        this.recordKey = recordKey;
        this.propKey = propKey;
    }

    public static void hookListener(JComponent c, SmartStickyListener<?> listener) {
        if (listener.nextNode != null) {
            throw new IllegalArgumentException("listener cannot hook to multiple components");
        }
        listener.nextNode = (SmartStickyListener)c.getClientProperty(LISTENER_KEY);
        c.putClientProperty(LISTENER_KEY, listener);
        c.addPropertyChangeListener(listener.propKey, listener);
    }

    public static void unhookListeners(JComponent c) {
        SmartStickyListener<?> listener = (SmartStickyListener<?>)c.getClientProperty(LISTENER_KEY);
        c.putClientProperty(LISTENER_KEY, null);
        while (listener != null) {
            c.removePropertyChangeListener(listener.propKey, listener);
            listener = listener.nextNode;
        }
    }

    protected abstract boolean shouldRecord(T var1);

    protected abstract void overrideValue(JComponent var1, T var2);

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.overriding.compareAndSet(false, true)) {
            JComponent c = (JComponent)event.getSource();
            Object newValue = event.getNewValue();
            if (this.shouldRecord(newValue)) {
                c.putClientProperty(this.recordKey, newValue);
            }
            this.overrideValue(c, newValue);
            this.overriding.set(false);
        }
    }
}

