/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ForeignKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.DefaultDropDialog;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.DefaultListDialog;

public class DropForeignKeyCommand
extends AbstractRefactoringCommand {
    private static final ILogger s_log = LoggerController.createLogger(DropForeignKeyCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DropForeignKeyCommand.class);
    protected DefaultDropDialog customDialog;
    private DefaultListDialog _listDialog;
    private ForeignKeyInfo[] _foreignKeyInfo = null;

    public DropForeignKeyCommand(ISession session, IDatabaseObjectInfo[] info) {
        super(session, info);
    }

    @Override
    protected void onExecute() throws SQLException {
        if (!(this._info[0] instanceof ITableInfo)) {
            return;
        }
        ITableInfo ti = (ITableInfo)this._info[0];
        ForeignKeyInfo[] fkInfo = this._session.getMetaData().getImportedKeysInfo(ti);
        if (fkInfo.length == 1) {
            this._foreignKeyInfo = fkInfo;
            this.showCustomDialog();
        } else if (fkInfo.length == 0) {
            this._session.showErrorMessage(s_stringMgr.getString("DropForeignKeyCommand.noKeyToDrop", new Object[]{this._info[0].getSimpleName()}));
        } else {
            this._listDialog = new DefaultListDialog((IDatabaseObjectInfo[])fkInfo, ti.getSimpleName(), 5);
            this._listDialog.addColumnSelectionListener(new ColumnListSelectionActionListener());
            this._listDialog.setLocationRelativeTo(SessionUtils.getOwningFrame((ISession)this._session));
            this._listDialog.setVisible(true);
        }
    }

    @Override
    protected String[] generateSQLStatements() {
        ArrayList<String> result = new ArrayList<String>();
        for (ForeignKeyInfo fgInfo : this._foreignKeyInfo) {
            StringBuilder sql = new StringBuilder();
            sql.append(this._dialect.getDropForeignKeySQL(fgInfo.getForeignKeyName(), this._info[0].getSimpleName(), this._qualifier, this._sqlPrefs));
            if (this.customDialog.isCascadeSelected()) {
                sql.append(" CASCADE");
            } else {
                sql.append(" RESTRICT");
            }
            result.add(sql.toString());
        }
        return result.toArray(new String[0]);
    }

    @Override
    protected void executeScript(String script) {
        AbstractRefactoringCommand.CommandExecHandler handler = new AbstractRefactoringCommand.CommandExecHandler(this._session);
        SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.run();
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DropForeignKeyCommand.this.customDialog.setVisible(false);
                        DropForeignKeyCommand.this.customDialog.dispose();
                        for (IDatabaseObjectInfo dbinfo : DropForeignKeyCommand.this._info) {
                            DropForeignKeyCommand.this._session.getSchemaInfo().reload(dbinfo);
                        }
                    }
                });
            }
        });
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialectExt) {
        return dialectExt.supportsDropConstraint();
    }

    private void showCustomDialog() {
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DropForeignKeyCommand.this.customDialog = new DefaultDropDialog((IDatabaseObjectInfo[])DropForeignKeyCommand.this._foreignKeyInfo, 5, SessionUtils.getOwningFrame((ISession)DropForeignKeyCommand.this._session));
                        DropForeignKeyCommand.this.customDialog.addExecuteListener(new AbstractRefactoringCommand.ExecuteListener());
                        DropForeignKeyCommand.this.customDialog.addEditSQLListener(new AbstractRefactoringCommand.EditSQLListener(DropForeignKeyCommand.this.customDialog));
                        DropForeignKeyCommand.this.customDialog.addShowSQLListener(new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, DropForeignKeyCommand.this.customDialog));
                        DropForeignKeyCommand.this.customDialog.setLocationRelativeTo(SessionUtils.getOwningFrame((ISession)DropForeignKeyCommand.this._session));
                        DropForeignKeyCommand.this.customDialog.setVisible(true);
                    }
                });
            }
        });
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static /* synthetic */ ForeignKeyInfo[] access$202(DropForeignKeyCommand x0, ForeignKeyInfo[] x1) {
        x0._foreignKeyInfo = x1;
        return x1;
    }

    private class ColumnListSelectionActionListener
    implements ActionListener {
        private ColumnListSelectionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DropForeignKeyCommand.this._listDialog == null) {
                return;
            }
            DropForeignKeyCommand.this._listDialog.dispose();
            DropForeignKeyCommand.access$202(DropForeignKeyCommand.this, DropForeignKeyCommand.this._listDialog.getSelectedItems().toArray(new ForeignKeyInfo[0]));
            DropForeignKeyCommand.this.showCustomDialog();
        }
    }

    static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = DropForeignKeyCommand.access$000().getString("DropForeignKeyCommand.sqlDialogTitle");
    }
}

