/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax.rsyntax;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import net.sourceforge.squirrel_sql.client.session.SQLEntryPanelUtil;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IUndoHandler;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirrelRSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaDefaultInputMap;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaUI;
import org.fife.ui.rtextarea.RTextArea;

public class SquirreLRSyntaxTextAreaUI
extends RSyntaxTextAreaUI {
    public static final String RS_ACCELERATOR_STRING_TO_UPPER_CASE = "ctrl shift u";
    public static final String RS_ACCELERATOR_STRING_TO_LOWER_CASE = "ctrl shift l";
    public static final KeyStroke RS_ACCELERATOR_KEY_STROKE_TO_UPPER_CASE = KeyStroke.getKeyStroke(85, 3);
    public static final KeyStroke RS_ACCELERATOR_KEY_STROKE_TO_LOWER_CASE = KeyStroke.getKeyStroke(76, 3);
    public static final String RS_ACCELERATOR_LINE_UP = "ctrl shift up";
    public static final String RS_ACCELERATOR_LINE_DOWN = "ctrl shift down";
    public static final KeyStroke RS_ACCELERATOR_KEY_STROKE_LINE_UP = KeyStroke.getKeyStroke(38, 3);
    public static final KeyStroke RS_ACCELERATOR_KEY_STROKE_LINE_DOWN = KeyStroke.getKeyStroke(40, 3);
    private static final EditorKit _squirrel_defaultKit = new RSyntaxTextAreaEditorKit(){

        public Action[] getActions() {
            return TextAction.augmentList(super.getActions(), new Action[]{new SQuirrelSelectWordAction()});
        }
    };
    private SquirrelRSyntaxTextArea _squirrelRSyntaxTextArea;

    public SquirreLRSyntaxTextAreaUI(SquirrelRSyntaxTextArea squirrelRSyntaxTextArea) {
        super((JComponent)((Object)squirrelRSyntaxTextArea));
        this._squirrelRSyntaxTextArea = squirrelRSyntaxTextArea;
    }

    protected InputMap getRTextAreaInputMap() {
        InputMapUIResource map = new InputMapUIResource();
        InputMap shared = (InputMap)UIManager.get("RSyntaxTextAreaUI.inputMap");
        if (shared == null) {
            shared = new RSyntaxTextAreaDefaultInputMap();
            this.modifiyKeystrokes(shared);
            UIManager.put("RSyntaxTextAreaUI.inputMap", shared);
        }
        map.setParent(shared);
        return map;
    }

    private void modifiyKeystrokes(InputMap shared) {
        shared.remove(KeyStroke.getKeyStroke(32, 2));
        shared.remove(KeyStroke.getKeyStroke(74, 2));
        shared.remove(KeyStroke.getKeyStroke(68, 2));
        shared.remove(KeyStroke.getKeyStroke(10, 2));
        shared.remove(KeyStroke.getKeyStroke(109, 2));
        shared.remove(KeyStroke.getKeyStroke(38, 8));
        shared.remove(KeyStroke.getKeyStroke(40, 8));
        shared.remove(KeyStroke.getKeyStroke(' '));
        shared.put(RS_ACCELERATOR_KEY_STROKE_TO_UPPER_CASE, "RTA.UpperCaseAction");
        shared.put(RS_ACCELERATOR_KEY_STROKE_TO_LOWER_CASE, "RTA.LowerCaseAction");
        shared.put(RS_ACCELERATOR_KEY_STROKE_LINE_UP, "RTA.LineUpAction");
        shared.put(RS_ACCELERATOR_KEY_STROKE_LINE_DOWN, "RTA.LineDownAction");
        KeyStroke rsyntaxRedoStroke = KeyStroke.getKeyStroke(89, 2);
        KeyStroke squirrelRedoStroke = KeyStroke.getKeyStroke(82, 2);
        shared.put(squirrelRedoStroke, shared.get(rsyntaxRedoStroke));
    }

    public IUndoHandler createUndoHandler() {
        return new IUndoHandler(){

            public Action getUndoAction() {
                return SquirreLRSyntaxTextAreaUI.this.onGetUndoAction();
            }

            public Action getRedoAction() {
                return SquirreLRSyntaxTextAreaUI.this.onGetRedoAction();
            }
        };
    }

    private Action onGetUndoAction() {
        return SquirreLRSyntaxTextAreaUI.getActionForName(this._squirrelRSyntaxTextArea, "RTA.UndoAction");
    }

    private Action onGetRedoAction() {
        return SquirreLRSyntaxTextAreaUI.getActionForName(this._squirrelRSyntaxTextArea, "RTA.RedoAction");
    }

    public static Action getActionForName(SquirrelRSyntaxTextArea squirrelRSyntaxTextArea, String actionName) {
        Action[] actions;
        for (Action action : actions = squirrelRSyntaxTextArea.getUI().getEditorKit((JTextComponent)((Object)squirrelRSyntaxTextArea)).getActions()) {
            if (!actionName.equals(action.getValue("Name"))) continue;
            return action;
        }
        throw new IllegalStateException("Action " + actionName + "not found");
    }

    public EditorKit getEditorKit(JTextComponent tc) {
        return _squirrel_defaultKit;
    }

    private static class SQuirrelSelectWordAction
    extends RSyntaxTextAreaEditorKit.SelectWordAction {
        private SQuirrelSelectWordAction() {
        }

        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            int[] wordBoundsAtCursor = SQLEntryPanelUtil.getWordBoundsAtCursor((JTextComponent)textArea, (boolean)false);
            textArea.setSelectionStart(wordBoundsAtCursor[0]);
            textArea.setSelectionEnd(wordBoundsAtCursor[1]);
        }
    }
}

