/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.fife.io.IOUtil;
import org.fife.ui.EscapableDialog;
import org.fife.ui.RScrollPane;
import org.fife.ui.ResizableFrameContentPane;
import org.fife.ui.UIUtil;

public class AboutDialog
extends EscapableDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton okButton;
    private JButton licenseButton;
    private JTabbedPane tabbedPane;
    private Component appPanel;
    private static final ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.AboutDialog");

    public AboutDialog(Frame parent) {
        this(parent, null);
    }

    public AboutDialog(Frame parent, String title) {
        super(parent);
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        ResizableFrameContentPane contentPane = new ResizableFrameContentPane(new BorderLayout());
        contentPane.setBorder(UIUtil.getEmpty5Border());
        this.setContentPane(contentPane);
        this.tabbedPane = new JTabbedPane();
        contentPane.add(this.tabbedPane);
        JPanel temp = UIUtil.newTabbedPanePanel();
        temp = UIUtil.newTabbedPanePanel();
        temp.setLayout(new BorderLayout());
        temp.setBorder(UIUtil.getEmpty5Border());
        temp.add((Component)new JLabel(msg.getString("EnvironInfo")), "North");
        JTable table = new JTable(new PropertiesTableModel(msg)){

            public boolean getScrollableTracksViewportHeight() {
                Container parent = this.getParent();
                return parent instanceof JViewport ? parent.getHeight() > this.getPreferredSize().height : false;
            }
        };
        UIUtil.fixJTableRendererOrientations(table);
        table.setTableHeader(null);
        temp.add(new RScrollPane(10, 10, table));
        this.tabbedPane.add(msg.getString("Environment"), temp);
        JPanel aboutAppPanel = this.createAboutApplicationPanel();
        if (aboutAppPanel != null) {
            this.setApplicationPanel(aboutAppPanel);
        }
        this.okButton = UIUtil.newButton(msg, "OK", "OKButtonMnemonic");
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        this.licenseButton = UIUtil.newButton(msg, "License", "LicenseButtonMnemonic");
        this.licenseButton.setActionCommand("License");
        this.licenseButton.addActionListener(this);
        Container buttons = UIUtil.createButtonFooter(this.okButton, this.licenseButton);
        contentPane.add((Component)buttons, "South");
        this.getRootPane().setDefaultButton(this.okButton);
        this.setTitle(title != null ? title : msg.getString("AboutDialogTitle"));
        this.setModal(true);
        this.applyComponentOrientation(orientation);
        this.pack();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AboutDialog.this.tabbedPane.setSelectedIndex(0);
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("OK")) {
            this.setVisible(false);
        } else if (actionCommand.equals("License")) {
            JDialog licenseDialog = this.createLicenseDialog();
            licenseDialog.setVisible(true);
        }
    }

    public void addPanel(String title, Component panel) {
        this.tabbedPane.insertTab(title, null, panel, null, this.tabbedPane.getTabCount() - 1);
    }

    protected JPanel createAboutApplicationPanel() {
        return null;
    }

    protected JDialog createLicenseDialog() {
        return new LicenseDialog(this, AboutDialog.getModifiedBsdText());
    }

    private static final String getModifiedBsdText() {
        String text = null;
        try {
            text = IOUtil.readFully(AboutDialog.class.getResourceAsStream("modifiedBsdLicense.txt"));
        }
        catch (IOException ioe) {
            text = ioe.getMessage();
        }
        return text;
    }

    public void setApplicationPanel(Component panel) {
        if (this.appPanel != null) {
            this.tabbedPane.removeTabAt(0);
            this.tabbedPane.setComponentAt(0, panel);
            this.appPanel = panel;
        } else if (panel == null) {
            this.tabbedPane.removeTabAt(0);
            this.appPanel = null;
        } else {
            String title = msg.getString("Tab.Application");
            this.tabbedPane.insertTab(title, null, panel, null, 0);
            this.appPanel = panel;
        }
    }

    private static class PropertiesTableModel
    extends DefaultTableModel {
        public PropertiesTableModel(ResourceBundle msg) {
            super(9, 2);
            this.setValueAt(msg.getString("Environment.Label.JavaVendor"), 0, 0);
            this.setValueAt(System.getProperty("java.vendor"), 0, 1);
            this.setValueAt(msg.getString("Environment.Label.JavaVMVersion"), 1, 0);
            this.setValueAt(System.getProperty("java.vm.version"), 1, 1);
            this.setValueAt(msg.getString("Environment.Label.JavaVMVendor"), 2, 0);
            this.setValueAt(System.getProperty("java.vm.vendor"), 2, 1);
            this.setValueAt(msg.getString("Environment.Label.JavaSpecification"), 3, 0);
            this.setValueAt(System.getProperty("java.specification.name"), 3, 1);
            this.setValueAt(msg.getString("Environment.Label.JavaSpecificationVersion"), 4, 0);
            this.setValueAt(System.getProperty("java.specification.version"), 4, 1);
            this.setValueAt(msg.getString("Environment.Label.Classpath"), 5, 0);
            this.setValueAt(System.getProperty("java.class.path"), 5, 1);
            this.setValueAt(msg.getString("Environment.Label.OS"), 6, 0);
            this.setValueAt(System.getProperty("os.name"), 6, 1);
            this.setValueAt(msg.getString("Environment.Label.OSVersion"), 7, 0);
            this.setValueAt(System.getProperty("os.version"), 7, 1);
            this.setValueAt(msg.getString("Environment.Label.Architecture"), 8, 0);
            this.setValueAt(System.getProperty("os.arch"), 8, 1);
            this.setColumnIdentifiers(new String[]{"", ""});
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    protected class LicenseDialog
    extends EscapableDialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;

        public LicenseDialog(Dialog parent, String licenseText) {
            super(parent);
            ComponentOrientation o = ComponentOrientation.getOrientation(this.getLocale());
            this.setTitle(msg.getString("LicenseDialogTitle"));
            ResizableFrameContentPane cp = new ResizableFrameContentPane(new BorderLayout());
            cp.setBorder(UIUtil.getEmpty5Border());
            this.setContentPane(cp);
            JTextArea textArea = new JTextArea(22, 81);
            textArea.setText(licenseText);
            textArea.setFont(new Font("Monospaced", 0, 12));
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            textArea.setEditable(false);
            textArea.setCaretPosition(0);
            RScrollPane scrollPane = new RScrollPane(textArea);
            cp.add(scrollPane);
            JButton okButton = UIUtil.newButton(msg, "OK", "OKButtonMnemonic");
            okButton.addActionListener(this);
            Container buttons = UIUtil.createButtonFooter(okButton);
            cp.add((Component)buttons, "South");
            this.setModal(true);
            this.applyComponentOrientation(o);
            this.getRootPane().setDefaultButton(okButton);
            this.pack();
            this.setLocationRelativeTo(AboutDialog.this);
        }

        public void actionPerformed(ActionEvent e) {
            this.escapePressed();
        }
    }
}

