/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.util.ArrayList;
import java.util.TooManyListenersException;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.fw.gui.TreeDnDHandlerCallback;

public class TreeDnDHandler {
    private JTree _tree;
    private TreeDnDHandlerCallback _treeDnDHandlerCallback;
    private boolean _allowExternalDrop;

    public TreeDnDHandler(JTree tree, TreeDnDHandlerCallback treeDnDHandlerCallback) {
        this(tree, treeDnDHandlerCallback, false);
    }

    public TreeDnDHandler(JTree tree, TreeDnDHandlerCallback treeDnDHandlerCallback, boolean allowExternalDrop) {
        this._tree = tree;
        this._treeDnDHandlerCallback = treeDnDHandlerCallback;
        this._allowExternalDrop = allowExternalDrop;
        this.initDnD();
    }

    private void initDnD() {
        try {
            this._tree.setDragEnabled(true);
            DropTarget dt = new DropTarget();
            dt.addDropTargetListener(new DropTargetAdapter(){

                @Override
                public void drop(DropTargetDropEvent dtde) {
                    TreeDnDHandler.this.onDrop(dtde);
                }
            });
            this._tree.setDropTarget(dt);
        }
        catch (TooManyListenersException e) {
            throw new RuntimeException(e);
        }
    }

    private void onDrop(DropTargetDropEvent dtde) {
        TreePath[] toPaste;
        TreePath targetPath = this._tree.getPathForLocation(dtde.getLocation().x, dtde.getLocation().y);
        if (!dtde.isLocalTransfer()) {
            if (!this._allowExternalDrop) {
                return;
            }
            ArrayList<DefaultMutableTreeNode> nodes = this._treeDnDHandlerCallback.createPasteTreeNodesFromExternalTransfer(dtde, targetPath);
            ArrayList<TreePath> buf = new ArrayList<TreePath>();
            for (DefaultMutableTreeNode node : nodes) {
                buf.add(new TreePath(node));
            }
            toPaste = buf.toArray(new TreePath[buf.size()]);
        } else {
            toPaste = this._tree.getSelectionPaths();
        }
        if (0 != (3 & dtde.getDropAction())) {
            this.execCut(toPaste, targetPath);
            this._treeDnDHandlerCallback.dndExecuted();
        }
    }

    public void execCut(TreePath[] pathsToPaste, TreePath targetPath) {
        int i;
        DefaultTreeModel dtm = (DefaultTreeModel)this._tree.getModel();
        ArrayList<Object> cutNodes = new ArrayList();
        if (null == targetPath) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)dtm.getRoot();
            if (this._treeDnDHandlerCallback.nodeAcceptsKids(root)) {
                cutNodes = this.cutDragedNodes(pathsToPaste, targetPath, dtm);
                int[] childIndices = new int[cutNodes.size()];
                for (i = 0; i < cutNodes.size(); ++i) {
                    childIndices[i] = root.getChildCount();
                    root.add((MutableTreeNode)cutNodes.get(i));
                }
                dtm.nodesWereInserted(root, childIndices);
            }
        } else {
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)targetPath.getLastPathComponent();
            if (this._treeDnDHandlerCallback.nodeAcceptsKids(selNode)) {
                cutNodes = this.cutDragedNodes(pathsToPaste, targetPath, dtm);
                for (int i2 = 0; i2 < cutNodes.size(); ++i2) {
                    selNode.add((MutableTreeNode)cutNodes.get(i2));
                }
                dtm.nodeStructureChanged(selNode);
            } else {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selNode.getParent();
                if (this._treeDnDHandlerCallback.nodeAcceptsKids(parent)) {
                    cutNodes = this.cutDragedNodes(pathsToPaste, targetPath, dtm);
                    for (i = 0; i < cutNodes.size(); ++i) {
                        parent.insert((MutableTreeNode)cutNodes.get(i), parent.getIndex(selNode) + 1);
                    }
                    dtm.nodeStructureChanged(parent);
                }
            }
        }
        TreePath[] newSelPaths = new TreePath[cutNodes.size()];
        for (int i3 = 0; i3 < newSelPaths.length; ++i3) {
            newSelPaths[i3] = new TreePath(((DefaultMutableTreeNode)cutNodes.get(i3)).getPath());
        }
        this._tree.setSelectionPaths(newSelPaths);
    }

    private ArrayList<DefaultMutableTreeNode> cutDragedNodes(TreePath[] pathsToPaste, TreePath targetPath, DefaultTreeModel dtm) {
        ArrayList<DefaultMutableTreeNode> cutNodes = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < pathsToPaste.length; ++i) {
            if (pathsToPaste[i].equals(targetPath)) continue;
            DefaultMutableTreeNode cutNode = (DefaultMutableTreeNode)pathsToPaste[i].getLastPathComponent();
            cutNodes.add(cutNode);
            if (null == cutNode.getParent()) continue;
            dtm.removeNodeFromParent(cutNode);
        }
        return cutNodes;
    }
}

