/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseKeyTextHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DTProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.EmptyWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IsNullWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.NoParameterWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.ParameterWhereClausePart;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.gui.RightLabel;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.ThreadSafeDateFormat;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DataTypeTimestamp
extends BaseDataTypeComponent
implements IDataTypeComponent {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataTypeTimestamp.class);
    private static ILogger s_log = LoggerController.createLogger(DataTypeTimestamp.class);
    private boolean _isNullable;
    private JTable _table;
    private IRestorableTextComponent _textComponent;
    private DefaultColumnRenderer _renderer = DefaultColumnRenderer.getInstance();
    private static final String thisClassName = "net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeTimestamp";
    private static int DEFAULT_LOCALE_FORMAT = 3;
    private static boolean propertiesAlreadyLoaded = false;
    private static boolean useJavaDefaultFormat = true;
    private static int localeFormat = DEFAULT_LOCALE_FORMAT;
    private static boolean lenient = true;
    private static ThreadSafeDateFormat dateFormat = new ThreadSafeDateFormat(localeFormat, localeFormat);
    public static final int DO_NOT_USE = 0;
    public static final int USE_JDBC_ESCAPE_FORMAT = 1;
    public static final int USE_STRING_FORMAT = 2;
    private static int whereClauseUsage = 1;
    public static final String WHERE_CLAUSE_USAGE_KEY = "whereClauseUsage";
    private boolean _renderExceptionHasBeenLogged;

    public DataTypeTimestamp(JTable table, ColumnDisplayDefinition colDef) {
        this._table = table;
        this._colDef = colDef;
        this._isNullable = colDef.isNullable();
        DataTypeTimestamp.loadProperties();
    }

    private static void loadProperties() {
        if (!propertiesAlreadyLoaded) {
            useJavaDefaultFormat = true;
            String useJavaDefaultFormatString = DTProperties.get(thisClassName, "useJavaDefaultFormat");
            if (useJavaDefaultFormatString != null && useJavaDefaultFormatString.equals("false")) {
                useJavaDefaultFormat = false;
            }
            localeFormat = 3;
            String localeFormatString = DTProperties.get(thisClassName, "localeFormat");
            if (localeFormatString != null) {
                localeFormat = Integer.parseInt(localeFormatString);
            }
            lenient = true;
            String lenientString = DTProperties.get(thisClassName, "lenient");
            if (lenientString != null && lenientString.equals("false")) {
                lenient = false;
            }
            whereClauseUsage = 1;
            String whereClauseUsageString = DTProperties.get(thisClassName, WHERE_CLAUSE_USAGE_KEY);
            if (whereClauseUsageString != null) {
                whereClauseUsage = Integer.parseInt(whereClauseUsageString);
            }
            DataTypeTimestamp.initDateFormat(localeFormat, lenient);
        }
    }

    private static void initDateFormat(int format, boolean lenient) {
        dateFormat = new ThreadSafeDateFormat(localeFormat, localeFormat);
        dateFormat.setLenient(lenient);
    }

    @Override
    public String getClassName() {
        return "java.sql.Timestamp";
    }

    @Override
    public String renderObject(Object value) {
        if (useJavaDefaultFormat || value == null) {
            return (String)this._renderer.renderObject(value);
        }
        try {
            return (String)this._renderer.renderObject(dateFormat.format(value));
        }
        catch (Exception e) {
            if (!this._renderExceptionHasBeenLogged) {
                this._renderExceptionHasBeenLogged = true;
                s_log.error("Could not format \"" + value + "\" as date type", e);
            }
            return (String)this._renderer.renderObject(value);
        }
    }

    @Override
    public boolean isEditableInCell(Object originalValue) {
        return true;
    }

    @Override
    public boolean needToReRead(Object originalValue) {
        return false;
    }

    @Override
    public JTextField getJTextField() {
        this._textComponent = new RestorableJTextField();
        ((RestorableJTextField)this._textComponent).addKeyListener(new KeyTextHandler());
        ((RestorableJTextField)this._textComponent).addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent((RestorableJTextField)DataTypeTimestamp.this._textComponent, evt, DataTypeTimestamp.this._table);
                    CellDataPopup.showDialog(DataTypeTimestamp.this._table, DataTypeTimestamp.this._colDef, tableEvt, true);
                }
            }
        });
        return (JTextField)((Object)this._textComponent);
    }

    @Override
    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        if (value.equals("<null>") || value.equals("")) {
            return null;
        }
        try {
            if (useJavaDefaultFormat) {
                Timestamp obj = Timestamp.valueOf(value);
                return obj;
            }
            Date javaDate = dateFormat.parse(value);
            return new Timestamp(javaDate.getTime());
        }
        catch (Exception e) {
            messageBuffer.append(e.toString() + "\n");
            return null;
        }
    }

    @Override
    public boolean useBinaryEditingPanel() {
        return false;
    }

    @Override
    public boolean isEditableInPopup(Object originalValue) {
        return true;
    }

    @Override
    public JTextArea getJTextArea(Object value) {
        this._textComponent = new RestorableJTextArea();
        ((RestorableJTextArea)this._textComponent).setText(this.renderObject(value));
        ((RestorableJTextArea)this._textComponent).addKeyListener(new KeyTextHandler());
        return (RestorableJTextArea)this._textComponent;
    }

    @Override
    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    @Override
    public Object readResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        Timestamp data = rs.getTimestamp(index);
        if (rs.wasNull()) {
            return null;
        }
        return data;
    }

    @Override
    public IWhereClausePart getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        if (whereClauseUsage == 0) {
            return new EmptyWhereClausePart();
        }
        if (value == null || value.toString() == null || value.toString().length() == 0) {
            return new IsNullWhereClausePart(this._colDef);
        }
        if (whereClauseUsage == 1) {
            return new NoParameterWhereClausePart(this._colDef, this._colDef.getColumnName() + "={ts '" + value.toString() + "'}");
        }
        return new ParameterWhereClausePart(this._colDef, value, this);
    }

    @Override
    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null) {
            pstmt.setNull(position, this._colDef.getSqlType());
        } else {
            pstmt.setTimestamp(position, (Timestamp)value);
        }
    }

    @Override
    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            StringBuffer mbuf = new StringBuffer();
            Object newObject = this.validateAndConvert(dbDefaultValue, null, mbuf);
            if (mbuf.length() == 0) {
                return newObject;
            }
        }
        if (this._isNullable) {
            return null;
        }
        return new Timestamp(new Date().getTime());
    }

    @Override
    public boolean canDoFileIO() {
        return true;
    }

    @Override
    public String importObject(FileInputStream inStream) throws IOException {
        InputStreamReader inReader = new InputStreamReader(inStream);
        int fileSize = inStream.available();
        char[] charBuf = new char[fileSize];
        int count = inReader.read(charBuf, 0, fileSize);
        if (count != fileSize) {
            throw new IOException("Could read only " + count + " chars from a total file size of " + fileSize + ". Import failed.");
        }
        String fileText = charBuf[count - 1] == '\n' ? new String(charBuf, 0, count - 1) : new String(charBuf);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(fileText, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException("Text does not represent data of type " + this.getClassName() + ".  Text was:\n" + fileText);
        }
        return fileText;
    }

    @Override
    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        OutputStreamWriter outWriter = new OutputStreamWriter(outStream);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(text, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException(new String(messageBuffer));
        }
        outWriter.write(text);
        outWriter.flush();
        outWriter.close();
    }

    public static OkJPanel getControlPanel() {
        DataTypeTimestamp.loadProperties();
        return new TimestampOkJPanel();
    }

    private static class TimestampOkJPanel
    extends OkJPanel {
        private static final long serialVersionUID = 2391094010453874795L;
        Timestamp ts = new Timestamp(new Date().getTime());
        private JCheckBox useJavaDefaultFormatChk = new JCheckBox(DataTypeTimestamp.access$400().getString("dateTypeTimestamp.defaultFormat") + "(" + this.ts + ")");
        private RightLabel dateFormatTypeDropLabel = new RightLabel(DataTypeTimestamp.access$400().getString("dateTypeTimestamp.orLocaleDependend"));
        private DateFormatTypeCombo dateFormatTypeDrop = new DateFormatTypeCombo();
        private JCheckBox lenientChk = new JCheckBox(DataTypeTimestamp.access$400().getString("dateTypeTimestamp.allowInexact"));
        private JRadioButton doNotUseButton = new JRadioButton(DataTypeTimestamp.access$400().getString("dateTypeTimestamp.timestampInWhere"));
        String jdbcEscapeMsg = DataTypeTimestamp.access$400().getString("dateTypeTimestamp.jdbcEscape");
        private JRadioButton useTimestampFormatButton = new JRadioButton(this.jdbcEscapeMsg + "( \"{ts '" + this.ts + "'}\")");
        String stringVersionMsg = DataTypeTimestamp.access$400().getString("dateTypeTimestamp.stringVersion");
        private JRadioButton useStringFormatButton = new JRadioButton(this.stringVersionMsg + "('" + this.ts + "')");
        private transient ButtonModel[] radioButtonModels = new ButtonModel[]{this.doNotUseButton.getModel(), this.useTimestampFormatButton.getModel(), this.useStringFormatButton.getModel()};
        private ButtonGroup whereClauseUsageGroup = new ButtonGroup();

        public TimestampOkJPanel() {
            this.useJavaDefaultFormatChk.setSelected(useJavaDefaultFormat);
            this.useJavaDefaultFormatChk.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    TimestampOkJPanel.this.dateFormatTypeDrop.setEnabled(!TimestampOkJPanel.this.useJavaDefaultFormatChk.isSelected());
                    TimestampOkJPanel.this.dateFormatTypeDropLabel.setEnabled(!TimestampOkJPanel.this.useJavaDefaultFormatChk.isSelected());
                    TimestampOkJPanel.this.lenientChk.setEnabled(!TimestampOkJPanel.this.useJavaDefaultFormatChk.isSelected());
                }
            });
            this.dateFormatTypeDrop = new DateFormatTypeCombo();
            this.dateFormatTypeDrop.setSelectedIndex(localeFormat);
            this.lenientChk.setSelected(lenient);
            this.whereClauseUsageGroup.add(this.doNotUseButton);
            this.whereClauseUsageGroup.add(this.useTimestampFormatButton);
            this.whereClauseUsageGroup.add(this.useStringFormatButton);
            this.whereClauseUsageGroup.setSelected(this.radioButtonModels[whereClauseUsage], true);
            this.dateFormatTypeDrop.setEnabled(!this.useJavaDefaultFormatChk.isSelected());
            this.dateFormatTypeDropLabel.setEnabled(!this.useJavaDefaultFormatChk.isSelected());
            this.lenientChk.setEnabled(!this.useJavaDefaultFormatChk.isSelected());
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("dateTypeTimestamp.typeTimestamp")));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 17;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 0;
            this.add((Component)this.useJavaDefaultFormatChk, gbc);
            gbc.gridwidth = 1;
            gbc.gridx = 0;
            ++gbc.gridy;
            this.add((Component)this.dateFormatTypeDropLabel, gbc);
            ++gbc.gridx;
            this.add((Component)this.dateFormatTypeDrop, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            this.add((Component)this.lenientChk, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 0;
            this.add((Component)new JLabel(s_stringMgr.getString("dateTypeTimestamp.generateWhereClause")), gbc);
            ++gbc.gridy;
            gbc.insets = new Insets(0, 30, 0, 0);
            gbc.gridwidth = 0;
            this.add((Component)this.doNotUseButton, gbc);
            ++gbc.gridy;
            this.add((Component)this.useTimestampFormatButton, gbc);
            ++gbc.gridy;
            this.add((Component)this.useStringFormatButton, gbc);
        }

        @Override
        public void ok() {
            int buttonIndex;
            useJavaDefaultFormat = this.useJavaDefaultFormatChk.isSelected();
            DTProperties.put(DataTypeTimestamp.thisClassName, "useJavaDefaultFormat", Boolean.valueOf(useJavaDefaultFormat).toString());
            localeFormat = this.dateFormatTypeDrop.getValue();
            dateFormat = new ThreadSafeDateFormat(localeFormat, localeFormat);
            DTProperties.put(DataTypeTimestamp.thisClassName, "localeFormat", Integer.toString(localeFormat));
            lenient = this.lenientChk.isSelected();
            dateFormat.setLenient(lenient);
            DTProperties.put(DataTypeTimestamp.thisClassName, "lenient", Boolean.valueOf(lenient).toString());
            for (buttonIndex = 0; buttonIndex < this.radioButtonModels.length && !this.whereClauseUsageGroup.isSelected(this.radioButtonModels[buttonIndex]); ++buttonIndex) {
            }
            if (buttonIndex > this.radioButtonModels.length) {
                buttonIndex = 1;
            }
            whereClauseUsage = buttonIndex;
            DTProperties.put(DataTypeTimestamp.thisClassName, DataTypeTimestamp.WHERE_CLAUSE_USAGE_KEY, Integer.toString(whereClauseUsage));
            DataTypeTimestamp.initDateFormat(localeFormat, lenient);
        }
    }

    public static class DateFormatTypeCombo
    extends JComboBox {
        private static final long serialVersionUID = -923184160665210096L;

        public DateFormatTypeCombo() {
            this.addItem(s_stringMgr.getString("dataTypeTimestamp.full", DateFormat.getDateTimeInstance(0, 0).format(new Date())));
            this.addItem(s_stringMgr.getString("dataTypeTimestamp.long", DateFormat.getDateTimeInstance(1, 1).format(new Date())));
            this.addItem(s_stringMgr.getString("dataTypeTimestamp.medium", DateFormat.getDateTimeInstance(2, 2).format(new Date())));
            this.addItem(s_stringMgr.getString("dataTypeTimestamp.short", DateFormat.getDateTimeInstance(3, 3).format(new Date())));
        }

        @Override
        public void setSelectedIndex(int option) {
            if (option == 3) {
                super.setSelectedIndex(3);
            } else if (option == 2) {
                super.setSelectedIndex(2);
            } else if (option == 1) {
                super.setSelectedIndex(1);
            } else {
                super.setSelectedIndex(0);
            }
        }

        public int getValue() {
            if (this.getSelectedIndex() == 3) {
                return 3;
            }
            if (this.getSelectedIndex() == 2) {
                return 2;
            }
            if (this.getSelectedIndex() == 1) {
                return 1;
            }
            return 0;
        }
    }

    private class KeyTextHandler
    extends BaseKeyTextHandler {
        private KeyTextHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            JTextComponent _theComponent = (JTextComponent)((Object)DataTypeTimestamp.this._textComponent);
            String text = _theComponent.getText();
            if (c == '\t' || c == '\n') {
                int index = text.indexOf(c);
                if (index != -1) {
                    text = index == text.length() - 1 ? text.substring(0, text.length() - 1) : text.substring(0, index) + text.substring(index + 1);
                    ((IRestorableTextComponent)((Object)_theComponent)).updateText(text);
                    DataTypeTimestamp.this._beepHelper.beep(_theComponent);
                }
                e.consume();
            }
            if (DataTypeTimestamp.this._isNullable) {
                if (text.equals("<null>")) {
                    if (c == '\b' || c == '\u007f') {
                        DataTypeTimestamp.this._textComponent.restoreText();
                        e.consume();
                    } else {
                        DataTypeTimestamp.this._textComponent.updateText("");
                    }
                } else if ((c == '\b' || c == '\u007f') && text.length() <= 1) {
                    DataTypeTimestamp.this._textComponent.updateText("<null>");
                    e.consume();
                }
            } else {
                this.handleNotNullableField(text, c, e, DataTypeTimestamp.this._textComponent);
            }
        }
    }
}

