/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt;

import java.io.IOException;
import org.apache.poi.poifs.crypt.EncryptionHeader;
import org.apache.poi.poifs.crypt.EncryptionVerifier;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class EncryptionInfo {
    private final int versionMajor;
    private final int versionMinor;
    private final int encryptionFlags;
    private final EncryptionHeader header;
    private final EncryptionVerifier verifier;

    public EncryptionInfo(POIFSFileSystem fs) throws IOException {
        this(fs.getRoot());
    }

    public EncryptionInfo(NPOIFSFileSystem fs) throws IOException {
        this(fs.getRoot());
    }

    public EncryptionInfo(DirectoryNode dir) throws IOException {
        DocumentInputStream dis = dir.createDocumentInputStream("EncryptionInfo");
        this.versionMajor = dis.readShort();
        this.versionMinor = dis.readShort();
        this.encryptionFlags = dis.readInt();
        if (this.versionMajor == 4 && this.versionMinor == 4 && this.encryptionFlags == 64) {
            StringBuilder builder = new StringBuilder();
            byte[] xmlDescriptor = new byte[dis.available()];
            dis.read(xmlDescriptor);
            for (byte b : xmlDescriptor) {
                builder.append((char)b);
            }
            String descriptor = builder.toString();
            this.header = new EncryptionHeader(descriptor);
            this.verifier = new EncryptionVerifier(descriptor);
        } else {
            int hSize = dis.readInt();
            this.header = new EncryptionHeader(dis);
            this.verifier = this.header.getAlgorithm() == 26625 ? new EncryptionVerifier(dis, 20) : new EncryptionVerifier(dis, 32);
        }
    }

    public int getVersionMajor() {
        return this.versionMajor;
    }

    public int getVersionMinor() {
        return this.versionMinor;
    }

    public int getEncryptionFlags() {
        return this.encryptionFlags;
    }

    public EncryptionHeader getHeader() {
        return this.header;
    }

    public EncryptionVerifier getVerifier() {
        return this.verifier;
    }
}

