/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.shapes;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import net.sourceforge.napkinlaf.shapes.AbstractDrawnGenerator;
import net.sourceforge.napkinlaf.util.RandomValue;
import net.sourceforge.napkinlaf.util.RandomValueSource;
import net.sourceforge.napkinlaf.util.RandomXY;

public class DrawnTriangleGenerator
extends AbstractDrawnGenerator {
    private final RandomXY mid;
    private final RandomXY l;
    private final RandomXY r;
    private final RandomValue startAdjust;
    private final double rotate;

    public DrawnTriangleGenerator(double rotate) {
        this.rotate = rotate;
        double shimmy = 0.05;
        this.mid = new RandomXY(0.5, shimmy, 0.0, shimmy);
        this.l = new RandomXY(0.0, shimmy, 1.0, shimmy);
        this.r = new RandomXY(1.0, shimmy, 1.0, shimmy);
        this.startAdjust = new RandomValue(0.07);
    }

    public Shape generate(AffineTransform matrix) {
        int i;
        GeneralPath t = new GeneralPath();
        double xScale = matrix.getScaleX();
        double yScale = matrix.getScaleY();
        Point2D midAt = this.mid.generate();
        Point2D leftAt = this.l.generate();
        Point2D rightAt = this.r.generate();
        double xMid = midAt.getX();
        double yMid = midAt.getY();
        double xV1 = leftAt.getX();
        double yV1 = leftAt.getY();
        double xV2 = rightAt.getX();
        double yV2 = rightAt.getY();
        if (this.rotate != 0.0) {
            matrix = (AffineTransform)matrix.clone();
            matrix.rotate(this.rotate, 0.5, 0.5);
        }
        double[] points = new double[]{xMid, yMid, xV1, yV1, xV2, yV2};
        matrix.transform(points, 0, points, 0, 3);
        double minDist = Double.MAX_VALUE;
        int minPoint = 0;
        for (int i2 = 0; i2 < points.length; i2 += 2) {
            double x = points[i2];
            double y = points[i2 + 1];
            double dist = Math.sqrt(x * x + y * y);
            if (!(dist < minDist)) continue;
            minDist = dist;
            minPoint = i2;
        }
        float[] drawPoints = new float[points.length + 2];
        for (i = 0; i < points.length; ++i) {
            drawPoints[i] = (float)points[(i + minPoint) % points.length];
        }
        drawPoints[6] = drawPoints[0];
        drawPoints[7] = drawPoints[1];
        drawPoints[0] = (float)((double)drawPoints[0] + this.adjustStartOffset(this.startAdjust, xScale));
        drawPoints[1] = (float)((double)drawPoints[1] + this.adjustStartOffset(this.startAdjust, yScale));
        drawPoints[6] = (float)((double)drawPoints[6] + this.adjustStartOffset(this.startAdjust, xScale));
        drawPoints[7] = (float)((double)drawPoints[7] + this.adjustStartOffset(this.startAdjust, yScale));
        t.moveTo(drawPoints[0], drawPoints[1]);
        for (i = 2; i < drawPoints.length; i += 2) {
            t.lineTo(drawPoints[i], drawPoints[i + 1]);
        }
        return t;
    }

    private double adjustStartOffset(RandomValueSource off, double scale) {
        double result = off.generate();
        if (scale < 1.0) {
            double delta = 1.0 - scale;
            double exp = this.startAdjust.generate();
            double adjusted = Math.pow(delta, exp);
            double startScale = 1.0 - adjusted;
            result *= startScale;
        }
        return result;
    }

    public RandomValue getStartAdjust() {
        return this.startAdjust;
    }
}

