/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.FriendsGroup;
import org.igoweb.igoweb.client.swing.GetUsernameWindow;
import org.igoweb.igoweb.client.swing.KeepOutWindow;
import org.igoweb.igoweb.client.swing.UserRenderer;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.AList;
import org.igoweb.util.swing.APopupMenu;
import org.igoweb.util.swing.MsgOut;
import org.igoweb.util.swing.Prefs;
import org.igoweb.util.swing.SortedListModel;

public class UserList
extends AList<User>
implements ActionListener,
EventListener {
    private static final ArrayList<BuddyListModel> listModels = new ArrayList();
    private final Client client;
    private final BuddyListModel model;
    private final UsersPopup userPop = new UsersPopup();
    private int numMainUserPopItems;
    private final JMenuItem talkToMI;
    private final JMenuItem viewMI;
    private final JMenuItem sortByNameMI;
    private final JMenuItem sortByRankMI;
    private final JCheckBoxMenuItem buddyCheck;
    private final JCheckBoxMenuItem censorCheck;
    private final JCheckBoxMenuItem fanCheck;
    private final JMenuItem forceOutMI;
    private final JMenuItem delAcctMI;
    private JMenuItem kickMI;

    public UserList(Client client, Collection<User> users) {
        this(client, null, users);
    }

    public UserList(final Client client, FriendsGroup friends, Collection<User> users) {
        super(new UserRenderer(client, friends), 2, null, new BuddyListModel(client.getFriendsGroup(0), client.getFriendsGroup(3)), false);
        this.getInnerList().setFixedCellWidth(((Component)((Object)this.getInnerList().getCellRenderer())).getMinimumSize().width);
        this.model = (BuddyListModel)this.getListModel();
        if (users != null) {
            Iterator<User> uis = users.iterator();
            while (uis.hasNext()) {
                this.add(uis.next());
            }
        }
        this.client = client;
        this.talkToMI = new JMenuItem(Defs.getString(-903340586));
        this.userPop.add(this.talkToMI);
        this.talkToMI.addActionListener(this);
        this.viewMI = new JMenuItem(Defs.getString(-903340555));
        this.userPop.add(this.viewMI);
        this.viewMI.addActionListener(this);
        this.numMainUserPopItems = this.userPop.getComponentCount();
        this.userPop.addSeparator();
        this.buddyCheck = new JCheckBoxMenuItem(Defs.getString(-1219405872));
        this.buddyCheck.addActionListener(this);
        this.userPop.add(this.buddyCheck);
        this.censorCheck = new JCheckBoxMenuItem(Defs.getString(-1219405871));
        this.censorCheck.addActionListener(this);
        this.userPop.add(this.censorCheck);
        this.fanCheck = new JCheckBoxMenuItem(Defs.getString(-1219405870));
        this.fanCheck.addActionListener(this);
        this.userPop.add(this.fanCheck);
        this.userPop.addSeparator();
        ButtonGroup sorts = new ButtonGroup();
        this.sortByNameMI = new JRadioButtonMenuItem(Defs.getString(-903340595));
        sorts.add(this.sortByNameMI);
        this.userPop.add(this.sortByNameMI);
        this.sortByNameMI.addActionListener(this);
        this.sortByRankMI = new JRadioButtonMenuItem(Defs.getString(-903340591));
        sorts.add(this.sortByRankMI);
        this.userPop.add(this.sortByRankMI);
        this.sortByRankMI.addActionListener(this);
        if (client.getMe().getAuthLevel() >= 3) {
            this.userPop.addSeparator();
            this.forceOutMI = new JMenuItem(Defs.getString(-903340734));
            this.userPop.add(this.forceOutMI);
            this.forceOutMI.addActionListener(this);
        } else {
            this.forceOutMI = null;
        }
        if (client.getMe().getAuthLevel() >= 4) {
            this.delAcctMI = new JMenuItem(Defs.getString(-903340762));
            this.userPop.add(this.delAcctMI);
            this.delAcctMI.addActionListener(this);
            this.kickMI = new JMenuItem(Defs.getString(-903340651));
            this.userPop.add(this.kickMI);
            this.kickMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    final String victim = UserList.this.getMenuTarget().name;
                    new MsgOut(Defs.getString(-903340724), Defs.getString(-903340637, victim), 3, null, new String[]{Defs.getString(1436228521), Defs.getString(1436228510)}, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event2) {
                            if (event2.getActionCommand().equals(Defs.getString(1436228521))) {
                                client.sendKeepOut(victim, 0, "");
                            }
                        }
                    });
                }
            });
        } else {
            this.delAcctMI = null;
        }
        this.addPopup(this.userPop);
    }

    public void addMenuItem(JMenuItem mi) {
        this.userPop.insert(mi, this.numMainUserPopItems++);
    }

    public void add(User user) {
        if (this.model.add(user) && this.isDisplayable()) {
            user.addListener(this);
        }
    }

    public void remove(User user) {
        user.removeListener(this);
        this.model.remove(user);
    }

    public void sortNow() {
        this.model.sortNow();
    }

    public void clear() {
        for (User u : this.model) {
            u.removeListener(this);
        }
        this.model.clear();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        listModels.remove(this.model);
        this.client.removeListener(this);
        this.client.getFriendsGroup(0).removeListener(this);
        for (User u : this.model) {
            if (u == null) continue;
            u.removeListener(this);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        listModels.add(this.model);
        this.client.addListener(this);
        this.client.getFriendsGroup(0).addListener(this);
        for (User u : this.model) {
            if (u == null) continue;
            u.addListener(this);
        }
        this.model.sortNow();
    }

    protected void prepUserPop(User user) {
        User me = this.client.getMe();
        boolean isRealUser = user != UserRenderer.BUDDY_BAR && user != null;
        this.talkToMI.setEnabled(isRealUser && user.isConnected() && !user.equals(me) && (me.getAuthLevel() >= 4 || user.getAuthLevel() >= 4 || !me.isInTourn()));
        this.viewMI.setEnabled(isRealUser);
        this.buddyCheck.setEnabled(isRealUser);
        this.censorCheck.setEnabled(isRealUser);
        this.fanCheck.setEnabled(isRealUser);
        this.buddyCheck.setSelected(isRealUser && this.client.getFriendsGroup(0).contains(user));
        this.censorCheck.setSelected(isRealUser && this.client.getFriendsGroup(1).contains(user));
        this.fanCheck.setSelected(isRealUser && this.client.getFriendsGroup(2).contains(user));
        (this.model.getSortType() == 1 ? this.sortByRankMI : this.sortByNameMI).setSelected(true);
        if (this.forceOutMI != null) {
            this.forceOutMI.setEnabled(isRealUser && user.isConnected());
        }
        if (this.delAcctMI != null) {
            this.delAcctMI.setEnabled(isRealUser);
        }
        if (this.kickMI != null) {
            this.kickMI.setEnabled(isRealUser && user.isConnected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        User target = this.getMenuTarget();
        if (src == this.talkToMI) {
            this.client.createConvo(target.name, null);
        } else if (src == this.viewMI) {
            this.client.requestUserDetails(target.name);
        } else if (src == this.forceOutMI) {
            new KeepOutWindow(target.name, this.client, this);
        } else if (src == this.buddyCheck) {
            if (this.buddyCheck.isSelected()) {
                this.client.addFriend(0, target.name, "");
            } else {
                this.client.removeFriend(0, target.name);
            }
        } else if (src == this.censorCheck) {
            if (this.censorCheck.isSelected()) {
                this.client.addFriend(1, target.name, "");
            } else {
                this.client.removeFriend(1, target.name);
            }
        } else if (src == this.fanCheck) {
            if (this.fanCheck.isSelected()) {
                this.client.addFriend(2, target.name, "");
            } else {
                this.client.removeFriend(2, target.name);
            }
        } else if (src == this.delAcctMI) {
            new GetUsernameWindow(-903340744, this, this.getMenuTarget().name, this, this.client);
        } else if (src == this.sortByNameMI) {
            this.model.setSortType(0);
        } else if (src == this.sortByRankMI) {
            this.model.setSortType(1);
        } else if (src instanceof GetUsernameWindow) {
            this.client.sendDeleteAccountRequest(event.getActionCommand());
        }
    }

    @Override
    public void handleEvent(Event event) {
        switch (event.type) {
            case 114: {
                this.repaint();
                break;
            }
            case 0: {
                this.model.changed((User)event.source);
                break;
            }
            case 6: {
                this.model.changed((User)event.arg);
            }
            case 7: {
                this.model.sortNow();
            }
        }
    }

    @Override
    protected void handleClick(Object clickedUser) {
        User me;
        User user;
        if (clickedUser != null && clickedUser instanceof User && clickedUser != UserRenderer.BUDDY_BAR && !(user = (User)clickedUser).equals(me = this.client.getMe()) && user.isConnected() && (!me.isInTourn() || me.getAuthLevel() >= 4 || user.getAuthLevel() >= 4)) {
            this.client.createConvo(((User)clickedUser).name, null);
        }
    }

    public static void buddiesChanged() {
        Iterator<BuddyListModel> iter = listModels.iterator();
        while (iter.hasNext()) {
            iter.next().sortNow();
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.addPopup(isEnabled ? this.userPop : null);
        this.getInnerList().setEnabled(isEnabled);
    }

    public User getMenuTarget() {
        return (User)this.userPop.getTarget();
    }

    private static class BuddySorter
    extends User.Comparator {
        public static final String SORT_PREF = "6\\g:\"LuU";
        private FriendsGroup buddies;
        private FriendsGroup watches;

        public BuddySorter(FriendsGroup buddies, FriendsGroup watches) {
            super(Prefs.getInt(SORT_PREF, 0));
            this.buddies = buddies;
            this.watches = watches;
        }

        @Override
        public void setSortType(int newType) {
            super.setSortType(newType);
            Prefs.putInt(SORT_PREF, newType);
        }

        @Override
        public int compare(User o1, User o2) {
            boolean buddy2;
            if (o1 == null || o2 == null) {
                return super.compare(o1, o2);
            }
            User u1 = o1;
            User u2 = o2;
            boolean buddy1 = this.buddies.contains(u1) || this.watches.contains(u1);
            boolean bl = buddy2 = this.buddies.contains(u2) || this.watches.contains(u2);
            if (buddy1 != buddy2) {
                return buddy1 ? -1 : 1;
            }
            if (o1 == UserRenderer.BUDDY_BAR) {
                return -1;
            }
            if (o2 == UserRenderer.BUDDY_BAR) {
                return 1;
            }
            return super.compare(o1, o2);
        }
    }

    private static class BuddyListModel
    extends SortedListModel<User> {
        private boolean hasBar = false;
        private FriendsGroup buddies;
        private FriendsGroup watches;

        public BuddyListModel(FriendsGroup buddies, FriendsGroup watches) {
            super(new BuddySorter(buddies, watches));
            this.buddies = buddies;
            this.watches = watches;
        }

        @Override
        protected void sort() {
            super.sort();
            if (this.hasBar && !this.isEmpty()) {
                if (this.get(0) == UserRenderer.BUDDY_BAR) {
                    this.remove(0);
                    this.hasBar = false;
                    this.sortNow();
                } else if (this.get(this.size() - 1) == UserRenderer.BUDDY_BAR) {
                    this.remove(this.size() - 1);
                    this.hasBar = false;
                    this.sortNow();
                }
            } else if (this.size() > 1) {
                User u1 = (User)this.get(0);
                User uLast = (User)this.get(this.size() - 1);
                if ((this.buddies.contains(u1) || this.watches.contains(u1)) && !this.buddies.contains(uLast) && !this.watches.contains(uLast)) {
                    this.add(UserRenderer.BUDDY_BAR);
                    this.hasBar = true;
                    this.sortNow();
                }
            }
        }

        public int getSortType() {
            return ((BuddySorter)this.getComparator()).getSortType();
        }

        public void setSortType(int newSortType) {
            ((BuddySorter)this.getComparator()).setSortType(newSortType);
            this.sortNow();
        }
    }

    private class UsersPopup
    extends APopupMenu {
        @Override
        public void show(Component comp, int x, int y, Object popupSource) {
            User user = (User)popupSource;
            this.setLabel(user == null ? "" : Defs.getString(-903340573, user.name));
            UserList.this.prepUserPop(user);
            super.show(comp, x, y, popupSource);
        }
    }
}

