/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.animation;

import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeStep;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerCallback;

public class FadeState {
    protected static long counter;
    protected long id;
    private float fadePosition;
    private boolean isFadingIn;
    private boolean isLooping;
    private boolean isLoopingReverse;
    private int loopCount;
    private boolean toStopAtCycleBreak;
    private boolean toRepaintParent;
    private FadeTrackerCallback callback;
    public FadeStep fadeStep;
    public FadeKind fadeKind;

    public FadeState(FadeKind fadeKind, float fadePosition, boolean isFadingIn, boolean toRepaintParent) {
        this.fadeKind = fadeKind;
        this.fadePosition = fadePosition;
        this.isFadingIn = isFadingIn;
        this.toRepaintParent = toRepaintParent;
        this.id = FadeState.getId();
        this.isLooping = false;
        this.toStopAtCycleBreak = false;
        this.loopCount = -1;
    }

    private FadeState() {
    }

    public FadeState getCopy() {
        FadeState result = new FadeState();
        result.fadeKind = this.fadeKind;
        result.fadePosition = this.fadePosition;
        result.isFadingIn = this.isFadingIn;
        result.toRepaintParent = this.toRepaintParent;
        result.id = this.id;
        result.isLooping = this.isLooping;
        result.isLoopingReverse = this.isLoopingReverse;
        result.toStopAtCycleBreak = this.toStopAtCycleBreak;
        result.fadeStep = this.fadeStep;
        result.callback = this.callback;
        result.loopCount = this.loopCount;
        return result;
    }

    public void toStopAtCycleBreak() {
        if (!this.isLooping) {
            throw new IllegalArgumentException("Supported only on looping fades");
        }
        this.toStopAtCycleBreak = true;
    }

    protected static synchronized long getId() {
        return counter++;
    }

    public void setCallback(FadeTrackerCallback callback) {
        if (FadeTracker.DEBUG_MODE) {
            System.out.println("Setting callback of " + this.id + " to " + callback);
        }
        this.callback = callback;
    }

    public FadeTrackerCallback getCallback() {
        return this.callback;
    }

    public void setFadePosition(float fadePosition) {
        this.fadePosition = fadePosition;
    }

    public float getFadePosition() {
        return this.fadePosition;
    }

    public void setFadingIn(boolean isFadingIn) {
        this.isFadingIn = isFadingIn;
    }

    public boolean isFadingIn() {
        return this.isFadingIn;
    }

    public void setLooping(boolean isLooping) {
        this.isLooping = isLooping;
    }

    public boolean isLooping() {
        return this.isLooping;
    }

    public void setLoopingReverse(boolean isLoopingReverse) {
        this.isLoopingReverse = isLoopingReverse;
    }

    public boolean isLoopingReverse() {
        return this.isLoopingReverse;
    }

    public void setToStopAtCycleBreak(boolean toStopAtCycleBreak) {
        this.toStopAtCycleBreak = toStopAtCycleBreak;
    }

    public boolean isToStopAtCycleBreak() {
        return this.toStopAtCycleBreak;
    }

    public void setToRepaintParent(boolean toRepaintParent) {
        this.toRepaintParent = toRepaintParent;
    }

    public boolean isToRepaintParent() {
        return this.toRepaintParent;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public void setLoopCount(int loopCount) {
        this.loopCount = loopCount;
    }
}

