/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.wikiTable;

import java.util.Collection;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.sourceforge.squirrel_sql.fw.gui.TablePopupMenu;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.CopyWikiTableAction;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.ICopyWikiTableActionFactory;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.ITableActionCallback;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.IWikiTableConfiguration;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.IWikiTableConfigurationFactory;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.WikiTableConfigurationFactory;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class CopyWikiTableActionFactory
implements ICopyWikiTableActionFactory {
    private static CopyWikiTableActionFactory instance = null;
    private IWikiTableConfigurationFactory configurationFactory = WikiTableConfigurationFactory.getInstance();
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TablePopupMenu.class);

    CopyWikiTableActionFactory() {
    }

    @Override
    public JMenuItem createMenueItem(ITableActionCallback callback) {
        Collection configurations = CollectionUtils.select(this.configurationFactory.getConfigurations(), (Predicate)new EnabledConfigurationPredicate());
        if (configurations.isEmpty()) {
            return this.createMenuForEmptyConfigurations();
        }
        if (configurations.size() == 1) {
            return this.createMenuForExactlyOneConfiguration(callback, (IWikiTableConfiguration)configurations.iterator().next());
        }
        return this.createMenuForAListOfConfiguration(callback, configurations);
    }

    private JMenuItem createMenuForAListOfConfiguration(ITableActionCallback callback, Collection<IWikiTableConfiguration> configurations) {
        JMenu submenue = new JMenu(s_stringMgr.getString("TablePopupMenu.copyaswikitable"));
        for (IWikiTableConfiguration config : configurations) {
            submenue.add(new CopyWikiTableAction(config.getName(), config, callback));
        }
        return submenue;
    }

    private JMenuItem createMenuForExactlyOneConfiguration(ITableActionCallback callback, IWikiTableConfiguration configuration) {
        String actionName = s_stringMgr.getString("TablePopupMenu.copyaswikitableSpecific", configuration.getName());
        CopyWikiTableAction action = new CopyWikiTableAction(actionName, configuration, callback);
        return new JMenuItem(action);
    }

    private JMenuItem createMenuForEmptyConfigurations() {
        JMenuItem item = new JMenuItem(s_stringMgr.getString("TablePopupMenu.copyaswikitable"));
        item.setEnabled(false);
        return item;
    }

    public static synchronized ICopyWikiTableActionFactory getInstance() {
        if (instance == null) {
            instance = new CopyWikiTableActionFactory();
        }
        return instance;
    }

    public IWikiTableConfigurationFactory getConfigurationFactory() {
        return this.configurationFactory;
    }

    public void setConfigurationFactory(IWikiTableConfigurationFactory configurationFactory) {
        this.configurationFactory = configurationFactory;
    }

    private static class EnabledConfigurationPredicate
    implements Predicate {
        private EnabledConfigurationPredicate() {
        }

        public boolean evaluate(Object input) {
            IWikiTableConfiguration config = (IWikiTableConfiguration)input;
            return config.isEnabled();
        }
    }
}

