/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.properties;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.INewSessionPropertiesPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.properties.ISessionPropertiesPanel;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerEditableTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTextPanel;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class GeneralSessionPropertiesPanel
implements INewSessionPropertiesPanel,
ISessionPropertiesPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GeneralSessionPropertiesPanel.class);
    private SessionProperties _props;
    private MyPanel _myPanel = new MyPanel();
    private JScrollPane _scrolledMyPanel = new JScrollPane(this._myPanel);

    @Override
    public void initialize(IApplication app) throws IllegalArgumentException {
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        this._props = app.getSquirrelPreferences().getSessionProperties();
        this._myPanel.loadData(this._props);
    }

    @Override
    public void initialize(IApplication app, ISession session) throws IllegalArgumentException {
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        this._props = session.getProperties();
        this._myPanel.loadData(this._props);
    }

    @Override
    public Component getPanelComponent() {
        return this._scrolledMyPanel;
    }

    @Override
    public String getTitle() {
        return GeneralSessionPropertiesPanelI18n.TITLE;
    }

    @Override
    public String getHint() {
        return GeneralSessionPropertiesPanelI18n.HINT;
    }

    @Override
    public void applyChanges() {
        this._myPanel.applyChanges(this._props);
    }

    private static final class SplitPaneOrientationCombo
    extends JComboBox {
        SplitPaneOrientationCombo() {
            this.addItem(SplitPaneOrientation.VERTICAL);
            this.addItem(SplitPaneOrientation.HORIZONTAL);
        }
    }

    private static final class SplitPaneOrientation {
        static final SplitPaneOrientation HORIZONTAL = new SplitPaneOrientation(GeneralSessionPropertiesPanel.access$000().getString("generalPropertiesPanel.horizontal"), 1);
        static final SplitPaneOrientation VERTICAL = new SplitPaneOrientation(GeneralSessionPropertiesPanel.access$000().getString("generalPropertiesPanel.vertical"), 0);
        private final String _name;
        private final int _value;

        SplitPaneOrientation(String name, int value) {
            this._name = name;
            this._value = value;
        }

        public String toString() {
            return this._name;
        }

        int getValue() {
            return this._value;
        }
    }

    private static final class TabPlacementCombo
    extends JComboBox {
        TabPlacementCombo() {
            this.addItem(TabPlacement.TOP);
            this.addItem(TabPlacement.LEFT);
            this.addItem(TabPlacement.BOTTOM);
            this.addItem(TabPlacement.RIGHT);
        }

        void selectClassName(String className) {
            if (className.equals(DataSetViewerTablePanel.class.getName())) {
                this.setSelectedItem(OutputType.TABLE);
            } else if (className.equals(DataSetViewerTextPanel.class.getName())) {
                this.setSelectedItem(OutputType.TEXT);
            } else if (className.equals(DataSetViewerEditableTablePanel.class.getName())) {
                this.setSelectedItem(OutputType.EDITABLE_TABLE);
            }
        }

        String getSelectedClassName() {
            return ((OutputType)this.getSelectedItem()).getPanelClassName();
        }
    }

    private static final class TabPlacement {
        static final TabPlacement TOP = new TabPlacement(GeneralSessionPropertiesPanel.access$000().getString("generalPropertiesPanel.top"), 1);
        static final TabPlacement LEFT = new TabPlacement(GeneralSessionPropertiesPanel.access$000().getString("generalPropertiesPanel.left"), 2);
        static final TabPlacement BOTTOM = new TabPlacement(GeneralSessionPropertiesPanel.access$000().getString("generalPropertiesPanel.bottom"), 3);
        static final TabPlacement RIGHT = new TabPlacement(GeneralSessionPropertiesPanel.access$000().getString("generalPropertiesPanel.right"), 4);
        private final String _name;
        private final int _value;

        TabPlacement(String name, int value) {
            this._name = name;
            this._value = value;
        }

        public String toString() {
            return this._name;
        }

        int getValue() {
            return this._value;
        }
    }

    private static final class OutputTypeCombo
    extends JComboBox {
        OutputTypeCombo(boolean possiblyEditable) {
            this.addItem(OutputType.TABLE);
            this.addItem(OutputType.TEXT);
            if (possiblyEditable) {
                this.addItem(OutputType.EDITABLE_TABLE);
            }
        }

        void selectClassName(String className) {
            if (className.equals(DataSetViewerTablePanel.class.getName())) {
                this.setSelectedItem(OutputType.TABLE);
            } else if (className.equals(DataSetViewerTextPanel.class.getName())) {
                this.setSelectedItem(OutputType.TEXT);
            } else if (className.equals(DataSetViewerEditableTablePanel.class.getName())) {
                this.setSelectedItem(OutputType.EDITABLE_TABLE);
            }
        }

        String getSelectedClassName() {
            return ((OutputType)this.getSelectedItem()).getPanelClassName();
        }
    }

    private static final class OutputType {
        static final OutputType TEXT = new OutputType(GeneralSessionPropertiesPanelI18n.TEXT, DataSetViewerTextPanel.class.getName());
        static final OutputType TABLE = new OutputType(GeneralSessionPropertiesPanelI18n.TABLE, DataSetViewerTablePanel.class.getName());
        static final OutputType EDITABLE_TABLE = new OutputType(GeneralSessionPropertiesPanelI18n.EDITABLE_TABLE, DataSetViewerEditableTablePanel.class.getName());
        private final String _name;
        private final String _className;

        OutputType(String name, String className) {
            this._name = name;
            this._className = className;
        }

        public String toString() {
            return this._name;
        }

        String getPanelClassName() {
            return this._className;
        }
    }

    private static final class MyPanel
    extends JPanel {
        private JCheckBox _showToolBar = new JCheckBox(GeneralSessionPropertiesPanelI18n.SHOW_TOOLBAR);
        private TabPlacementCombo _mainTabPlacementCmb = new TabPlacementCombo();
        private TabPlacementCombo _objectTabPlacementCmb = new TabPlacementCombo();
        private TabPlacementCombo _sqlExecutionTabPlacementCmb = new TabPlacementCombo();
        private TabPlacementCombo _sqlResultsTabPlacementCmb = new TabPlacementCombo();
        private OutputTypeCombo _metaDataCmb = new OutputTypeCombo(false);
        private OutputTypeCombo _sqlResultsCmb = new OutputTypeCombo(true);
        private JCheckBox _chkKeepTableLayoutOnRerun = new JCheckBox();
        private OutputTypeCombo _tableContentsCmb = new OutputTypeCombo(true);
        private SplitPaneOrientationCombo _splitPaneOrientationCmb = new SplitPaneOrientationCombo();

        MyPanel() {
            super(new GridBagLayout());
            this.createGUI();
        }

        void loadData(SessionProperties props) {
            this._showToolBar.setSelected(props.getShowToolBar());
            int mainTabPlacement = props.getMainTabPlacement();
            int limit = this._mainTabPlacementCmb.getModel().getSize();
            for (int i = 0; i < limit; ++i) {
                TabPlacement tp = (TabPlacement)this._mainTabPlacementCmb.getItemAt(i);
                if (tp.getValue() != mainTabPlacement) continue;
                this._mainTabPlacementCmb.setSelectedIndex(i);
                break;
            }
            if (this._mainTabPlacementCmb.getSelectedIndex() == -1) {
                this._mainTabPlacementCmb.setSelectedIndex(0);
            }
            int objectTabPlacement = props.getObjectTabPlacement();
            int limit2 = this._objectTabPlacementCmb.getModel().getSize();
            for (int i = 0; i < limit2; ++i) {
                TabPlacement tp = (TabPlacement)this._objectTabPlacementCmb.getItemAt(i);
                if (tp.getValue() != objectTabPlacement) continue;
                this._objectTabPlacementCmb.setSelectedIndex(i);
                break;
            }
            if (this._objectTabPlacementCmb.getSelectedIndex() == -1) {
                this._objectTabPlacementCmb.setSelectedIndex(0);
            }
            int sqlExecutionTabPlacement = props.getSQLExecutionTabPlacement();
            int limit3 = this._sqlExecutionTabPlacementCmb.getModel().getSize();
            for (int i = 0; i < limit3; ++i) {
                TabPlacement tp = (TabPlacement)this._sqlExecutionTabPlacementCmb.getItemAt(i);
                if (tp.getValue() != sqlExecutionTabPlacement) continue;
                this._sqlExecutionTabPlacementCmb.setSelectedIndex(i);
                break;
            }
            if (this._sqlExecutionTabPlacementCmb.getSelectedIndex() == -1) {
                this._sqlExecutionTabPlacementCmb.setSelectedIndex(0);
            }
            int sqlResultsTabPlacement = props.getSQLResultsTabPlacement();
            int limit4 = this._sqlResultsTabPlacementCmb.getModel().getSize();
            for (int i = 0; i < limit4; ++i) {
                TabPlacement tp = (TabPlacement)this._sqlResultsTabPlacementCmb.getItemAt(i);
                if (tp.getValue() != sqlResultsTabPlacement) continue;
                this._sqlResultsTabPlacementCmb.setSelectedIndex(i);
                break;
            }
            if (this._sqlResultsTabPlacementCmb.getSelectedIndex() == -1) {
                this._sqlResultsTabPlacementCmb.setSelectedIndex(0);
            }
            int splitPaneOrientation = props.getSqlPanelOrientation();
            int limit5 = this._splitPaneOrientationCmb.getModel().getSize();
            for (int i = 0; i < limit5; ++i) {
                SplitPaneOrientation spo = (SplitPaneOrientation)this._splitPaneOrientationCmb.getItemAt(i);
                if (spo.getValue() != splitPaneOrientation) continue;
                this._splitPaneOrientationCmb.setSelectedIndex(i);
                break;
            }
            if (this._splitPaneOrientationCmb.getSelectedIndex() == -1) {
                this._splitPaneOrientationCmb.setSelectedIndex(0);
            }
            this._metaDataCmb.selectClassName(props.getMetaDataOutputClassName());
            this._sqlResultsCmb.selectClassName(props.getSQLResultsOutputClassName());
            this._chkKeepTableLayoutOnRerun.setSelected(props.getKeepTableLayoutOnRerun());
            this._tableContentsCmb.selectClassName(props.getTableContentsOutputClassName());
        }

        void applyChanges(SessionProperties props) {
            props.setShowToolBar(this._showToolBar.isSelected());
            props.setMetaDataOutputClassName(this._metaDataCmb.getSelectedClassName());
            props.setSQLResultsOutputClassName(this._sqlResultsCmb.getSelectedClassName());
            props.setKeepTableLayoutOnRerun(this._chkKeepTableLayoutOnRerun.isSelected());
            props.setTableContentsOutputClassName(this._tableContentsCmb.getSelectedClassName());
            TabPlacement tp = (TabPlacement)this._mainTabPlacementCmb.getSelectedItem();
            props.setMainTabPlacement(tp.getValue());
            tp = (TabPlacement)this._objectTabPlacementCmb.getSelectedItem();
            props.setObjectTabPlacement(tp.getValue());
            tp = (TabPlacement)this._sqlExecutionTabPlacementCmb.getSelectedItem();
            props.setSQLExecutionTabPlacement(tp.getValue());
            tp = (TabPlacement)this._sqlResultsTabPlacementCmb.getSelectedItem();
            props.setSQLResultsTabPlacement(tp.getValue());
            SplitPaneOrientation spOrientation = (SplitPaneOrientation)this._splitPaneOrientationCmb.getSelectedItem();
            props.setSqlPanelOrientation(spOrientation.getValue());
        }

        private void createGUI() {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.add((Component)this.createAppearancePanel(), gbc);
            ++gbc.gridy;
            this.add((Component)this.createOutputPanel(), gbc);
            ++gbc.gridy;
            this.add((Component)new JLabel(""), gbc);
            ++gbc.gridy;
            this.add((Component)new JLabel(GeneralSessionPropertiesPanelI18n.DATA_TYPE1), gbc);
            ++gbc.gridy;
            this.add((Component)new JLabel(GeneralSessionPropertiesPanelI18n.DATA_TYPE2), gbc);
        }

        private JPanel createAppearancePanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("generalSessionPropertiesPanel.appearance")));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.gridx = 0;
            gbc.gridy = 0;
            pnl.add((Component)this._showToolBar, gbc);
            ++gbc.gridy;
            pnl.add((Component)new JLabel(GeneralSessionPropertiesPanelI18n.MAIN_TAB_PLACEMENT, 4), gbc);
            ++gbc.gridx;
            gbc.weightx = 0.5;
            pnl.add((Component)this._mainTabPlacementCmb, gbc);
            ++gbc.gridx;
            gbc.weightx = 0.0;
            pnl.add((Component)new JLabel(GeneralSessionPropertiesPanelI18n.OBJECT_TAB_PLACEMENT, 4), gbc);
            ++gbc.gridx;
            gbc.weightx = 0.5;
            pnl.add((Component)this._objectTabPlacementCmb, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            pnl.add((Component)new JLabel(GeneralSessionPropertiesPanelI18n.SQL_EXECUTION_TAB_PLACEMENT, 4), gbc);
            ++gbc.gridx;
            gbc.weightx = 0.5;
            pnl.add((Component)this._sqlExecutionTabPlacementCmb, gbc);
            ++gbc.gridx;
            gbc.weightx = 0.0;
            pnl.add((Component)new JLabel(GeneralSessionPropertiesPanelI18n.SQL_RESULTS_TAB_PLACEMENT, 4), gbc);
            ++gbc.gridx;
            gbc.weightx = 0.5;
            pnl.add((Component)this._sqlResultsTabPlacementCmb, gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            pnl.add((Component)new JLabel(GeneralSessionPropertiesPanelI18n.SQL_PANEL_ORIENTATION, 4), gbc);
            ++gbc.gridx;
            gbc.weightx = 0.5;
            gbc.gridwidth = 3;
            pnl.add((Component)this._splitPaneOrientationCmb, gbc);
            return pnl;
        }

        private JPanel createOutputPanel() {
            JPanel pnl = new JPanel(new GridBagLayout());
            pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("editWherColsSheet.output")));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.gridx = 0;
            gbc.gridy = 0;
            pnl.add((Component)new JLabel(GeneralSessionPropertiesPanelI18n.META_DATA, 4), gbc);
            ++gbc.gridx;
            pnl.add((Component)this._metaDataCmb, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            pnl.add((Component)new JLabel(GeneralSessionPropertiesPanelI18n.TABLE_CONTENTS, 4), gbc);
            ++gbc.gridx;
            pnl.add((Component)this._tableContentsCmb, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            pnl.add((Component)new JSeparator(0), gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            pnl.add((Component)new MultipleLineLabel(s_stringMgr.getString("generalSessionPropertiesPanel.noteOnSqlResults")), gbc);
            gbc.gridwidth = 1;
            ++gbc.gridy;
            gbc.gridx = 0;
            pnl.add((Component)new JLabel(GeneralSessionPropertiesPanelI18n.SQL_RESULTS, 4), gbc);
            ++gbc.gridx;
            pnl.add((Component)this._sqlResultsCmb, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            pnl.add((Component)new JSeparator(0), gbc);
            gbc.gridwidth = 1;
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.gridwidth = 2;
            this._chkKeepTableLayoutOnRerun.setText(GeneralSessionPropertiesPanelI18n.KEEP_TABLE_LAYOUT_ON_RERUN);
            pnl.add((Component)this._chkKeepTableLayoutOnRerun, gbc);
            return pnl;
        }
    }

    static interface GeneralSessionPropertiesPanelI18n {
        public static final String HINT = GeneralSessionPropertiesPanel.access$000().getString("generalSessionPropertiesPanel.generalSettings");
        public static final String MAIN_TAB_PLACEMENT = GeneralSessionPropertiesPanel.access$000().getString("generalSessionPropertiesPanel.mainTabs");
        public static final String META_DATA = GeneralSessionPropertiesPanel.access$000().getString("generalSessionPropertiesPanel.metaData");
        public static final String SHOW_TOOLBAR = GeneralSessionPropertiesPanel.access$000().getString("generalSessionPropertiesPanel.showToolbar");
        public static final String OBJECT_TAB_PLACEMENT = GeneralSessionPropertiesPanel.access$000().getString("generalSessionPropertiesPanel.objectTabs");
        public static final String SQL_EXECUTION_TAB_PLACEMENT = GeneralSessionPropertiesPanel.access$000().getString("generalSessionPropertiesPanel.sqlExecTabs");
        public static final String SQL_RESULTS = GeneralSessionPropertiesPanel.access$000().getString("generalSessionPropertiesPanel.sqlResults");
        public static final String SQL_RESULTS_TAB_PLACEMENT = GeneralSessionPropertiesPanel.access$000().getString("generalSessionPropertiesPanel.sqlResultTabs");
        public static final String TITLE = GeneralSessionPropertiesPanel.access$000().getString("generalSessionPropertiesPanel.general");
        public static final String TABLE_CONTENTS = GeneralSessionPropertiesPanel.access$000().getString("generalSessionPropertiesPanel.tableContents");
        public static final String TABLE = GeneralSessionPropertiesPanel.access$000().getString("generalSessionPropertiesPanel.table");
        public static final String EDITABLE_TABLE = GeneralSessionPropertiesPanel.access$000().getString("generalSessionPropertiesPanel.editableTable");
        public static final String KEEP_TABLE_LAYOUT_ON_RERUN = GeneralSessionPropertiesPanel.access$000().getString("generalSessionPropertiesPanel.chkKeepTableLayoutOnRerun");
        public static final String TEXT = GeneralSessionPropertiesPanel.access$000().getString("generalSessionPropertiesPanel.text");
        public static final String DATA_TYPE1 = GeneralSessionPropertiesPanel.access$000().getString("generalSessionPropertiesPanel.dataTYpe1");
        public static final String DATA_TYPE2 = GeneralSessionPropertiesPanel.access$000().getString("generalSessionPropertiesPanel.dataTYpe2");
        public static final String SQL_PANEL_ORIENTATION = GeneralSessionPropertiesPanel.access$000().getString("generalSessionPropertiesPanel.sqlPanelOrientation");
    }
}

