/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.parser.kernel.completions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.Completion;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ParserLogger;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.SQLSchema;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.completions.SQLColumn;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.completions.SQLSelectStatementListener;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.completions.SQLStatement;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.completions.SQLTable;

public class SQLSelectStatement
extends SQLStatement {
    private static final int FA_START = 0;
    private static final int FA_END = 1;
    private static final int FA_GROUPBY = 0;
    private static final int FA_HAVING = 1;
    private static final int FA_ORDERBY = 2;
    private Map<String, SQLSchema.Table> aliasMap = new HashMap<String, SQLSchema.Table>();
    private int selectListStart;
    private int selectListEnd;
    private int fromStart;
    private int fromEnd;
    private int[][] fieldAreas = new int[3][2];
    private Vector<SQLSelectStatementListener> listeners = new Vector();

    public SQLSelectStatement(int start) {
        super(start);
    }

    public void setSelectListStart(int start) {
        this.selectListStart = start;
        this.selectListEnd = 99999;
        this.setEndPosition(this.selectListEnd);
    }

    public void setSelectListEnd(int end) {
        this.selectListEnd = end;
        this.setEndPosition(end);
    }

    public void setFromStart(int fromStart) {
        this.fromStart = fromStart;
        this.fromEnd = 99999;
        this.setEndPosition(this.fromEnd);
    }

    public void setFromEnd(int fromEnd) {
        this.fromEnd = fromEnd;
        this.setEndPosition(fromEnd);
    }

    public void setGroupByStart(int start) {
        this.setFieldAreaStart(0, start);
    }

    public void setGroupByEnd(int whereEnd) {
        this.setFieldAreEnd(0, whereEnd);
    }

    public void setHavingStart(int start) {
        this.setFieldAreaStart(1, start);
    }

    public void setHavingEnd(int whereEnd) {
        this.setFieldAreEnd(1, whereEnd);
    }

    public void setOrderByStart(int start) {
        this.setFieldAreaStart(2, start);
    }

    public void setOrderByEnd(int whereEnd) {
        this.setFieldAreEnd(2, whereEnd);
    }

    private void setFieldAreaStart(int fa, int start) {
        this.fieldAreas[fa][0] = start;
        this.fieldAreas[fa][1] = 99999;
        this.setEndPosition(99999);
    }

    private void setFieldAreEnd(int fa, int end) {
        this.fieldAreas[fa][1] = end;
        this.setEndPosition(end);
    }

    @Override
    public boolean setTable(String catalog, String schema, String name, String alias) {
        ParserLogger.log("setTable: " + alias + "." + name);
        SQLSchema.Table table = this.sqlSchema.getTable(catalog, schema, name);
        if (table == null) {
            return false;
        }
        if (alias != null) {
            this.aliasMap.put(alias, table.clone(alias));
            this.fireAliasDefined(name, alias);
        }
        return true;
    }

    @Override
    public List<SQLSchema.Table> getTables(String catalog, String schema, String name) {
        if (this.aliasMap.size() == 0) {
            return this.sqlSchema.getTables(catalog, schema, name);
        }
        List<SQLSchema.Table> tables = this.sqlSchema.getTables(catalog, schema, name);
        tables.addAll(this.aliasMap.values());
        return tables;
    }

    @Override
    public SQLSchema.Table getTableForAlias(String alias) {
        SQLSchema.Table table = this.aliasMap.get(alias);
        return table != null ? table : this.sqlSchema.getTableForAlias(alias);
    }

    @Override
    public Completion getCompletion(int offset) {
        Completion comp = super.getCompletion(offset);
        if (comp != null) {
            return comp;
        }
        if (offset >= this.selectListStart && offset <= this.selectListEnd) {
            return new SQLColumn(this, offset, offset);
        }
        if (offset >= this.fromStart && offset <= this.fromEnd) {
            return new SQLTable(this, offset, offset);
        }
        for (int i = 0; i < this.fieldAreas.length; ++i) {
            if (offset < this.fieldAreas[i][0] || offset > this.fieldAreas[i][1]) continue;
            SQLColumn col = new SQLColumn(this, offset, offset);
            col.setRepeatable(false);
            return col;
        }
        return null;
    }

    public void addListener(SQLSelectStatementListener l) {
        this.listeners.add(l);
    }

    public void removeListener(SQLSelectStatementListener l) {
        this.listeners.remove(l);
    }

    private void fireAliasDefined(String tableName, String aliasName) {
        SQLSelectStatementListener[] clone = this.listeners.toArray(new SQLSelectStatementListener[this.listeners.size()]);
        for (int i = 0; i < clone.length; ++i) {
            clone[i].aliasDefined(tableName, aliasName);
        }
    }
}

