/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ISequenceParentExtractor;
import net.sourceforge.squirrel_sql.client.session.schemainfo.ObjFilterMatcher;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SequenceParentExpander
implements INodeExpander {
    private static final ILogger s_log = LoggerController.createLogger(SequenceParentExpander.class);
    private ISequenceParentExtractor extractor = null;

    public void setExtractor(ISequenceParentExtractor extractor) {
        this.extractor = extractor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) throws SQLException {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
        ISQLConnection conn = session.getSQLConnection();
        SQLDatabaseMetaData md = session.getSQLConnection().getSQLMetaData();
        String catalogName = parentDbinfo.getCatalogName();
        String schemaName = parentDbinfo.getSchemaName();
        ObjFilterMatcher filterMatcher = new ObjFilterMatcher(session.getProperties());
        String sequenceParentQuerySql = this.extractor.getSequenceParentQuery();
        if (s_log.isDebugEnabled()) {
            s_log.debug("createChildren: running sequence parent query for sequence children: " + sequenceParentQuerySql);
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(sequenceParentQuerySql);
            this.extractor.bindParameters(pstmt, parentDbinfo, filterMatcher);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                DatabaseObjectInfo si = new DatabaseObjectInfo(catalogName, schemaName, rs.getString(1), DatabaseObjectType.SEQUENCE, md);
                if (!filterMatcher.matches(si.getSimpleName())) continue;
                childNodes.add(new ObjectTreeNode(session, si));
            }
        }
        catch (Throwable throwable) {
            SQLUtilities.closeResultSet(rs);
            SQLUtilities.closeStatement(pstmt);
            throw throwable;
        }
        SQLUtilities.closeResultSet(rs);
        SQLUtilities.closeStatement(pstmt);
        return childNodes;
    }
}

