/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph.querybuilder.sqlgen;

import java.util.ArrayList;
import java.util.HashMap;
import net.sourceforge.squirrel_sql.plugins.graph.AggregateFunctions;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfo;
import net.sourceforge.squirrel_sql.plugins.graph.TableFrameController;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.SelectCol;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.SelectStructure;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.sqlgen.FromClauseRes;
import net.sourceforge.squirrel_sql.plugins.graph.querybuilder.sqlgen.SelectClauseRes;

public class SelectClauseGenerator {
    public SelectClauseRes createSelectClause(FromClauseRes fromClause, SelectStructure selS) {
        boolean colAdded = false;
        boolean hasAggFct = false;
        boolean groupByHasCols = false;
        HashMap<String, String> selectFieldsByQualifiedCol = new HashMap<String, String>();
        HashMap<String, String> groupByFieldsByQualifiedCol = new HashMap<String, String>();
        for (TableFrameController tfc : fromClause.getTables()) {
            for (ColumnInfo columnInfo : tfc.getColumnInfos()) {
                if (!columnInfo.getQueryData().isInSelectClause()) continue;
                AggregateFunctions af = columnInfo.getQueryData().getAggregateFunction();
                String qualifiedCol = tfc.getTableInfo().getSimpleName() + "." + columnInfo.getColumnName();
                if (AggregateFunctions.NONE == af) {
                    selectFieldsByQualifiedCol.put(qualifiedCol, qualifiedCol);
                    groupByFieldsByQualifiedCol.put(qualifiedCol, qualifiedCol);
                    groupByHasCols = true;
                } else {
                    selectFieldsByQualifiedCol.put(qualifiedCol, af.getSQL() + "(" + qualifiedCol + ")");
                    hasAggFct = true;
                }
                colAdded = true;
            }
        }
        if (!colAdded) {
            return null;
        }
        ArrayList<String> qualifiedColsOrderedAsTheyAppearInSelect = new ArrayList<String>();
        StringBuffer selectClause = new StringBuffer("SELECT ");
        StringBuffer groupByClause = new StringBuffer("GROUP BY ");
        for (SelectCol selectCol : selS.getSelectCols()) {
            String selectField = (String)selectFieldsByQualifiedCol.remove(selectCol.getQualifiedCol());
            if (null != selectField) {
                selectClause.append(selectField).append(",");
            }
            qualifiedColsOrderedAsTheyAppearInSelect.add(selectCol.getQualifiedCol());
            String groupByField = (String)groupByFieldsByQualifiedCol.remove(selectCol.getQualifiedCol());
            if (null == groupByField) continue;
            groupByClause.append(groupByField).append(",");
        }
        if (0 < selectFieldsByQualifiedCol.size()) {
            throw new IllegalStateException("Not all select fields appeard in SelectStructure");
        }
        if (0 < groupByFieldsByQualifiedCol.size()) {
            throw new IllegalStateException("Not all group by fields appeard in SelectStructure");
        }
        selectClause.setLength(selectClause.length() - 1);
        if (hasAggFct && groupByHasCols) {
            groupByClause.setLength(groupByClause.length() - 1);
            return new SelectClauseRes(selectClause, groupByClause, qualifiedColsOrderedAsTheyAppearInSelect);
        }
        return new SelectClauseRes(selectClause, qualifiedColsOrderedAsTheyAppearInSelect);
    }
}

