/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.parser.kernel;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Vector;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ErrorInfo;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ErrorStream;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ExitParserThreadRequestException;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.Parser;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ParserListener;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.ParsingFinishedListener;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.SQLSchema;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.Scanner;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.TableAliasInfo;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.completions.ErrorListener;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.completions.SQLSelectStatementListener;
import net.sourceforge.squirrel_sql.client.session.parser.kernel.completions.SQLStatement;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public final class ParserThread
extends Thread {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ParserThread.class);
    private static final ILogger s_log = LoggerController.createLogger(ParserThread.class);
    public static final String PARSER_THREAD_NM = "SQLParserThread";
    private String _pendingString;
    private Errors _errors;
    private SQLSchema _schema;
    private SQLStatement _curSQLSelectStat;
    private Vector<TableAliasInfo> _workingTableAliasInfos = new Vector();
    private TableAliasInfo[] _lastRunTableAliasInfos = new TableAliasInfo[0];
    private Vector<ErrorInfo> _workingErrorInfos = new Vector();
    private ErrorInfo[] _lastRunErrorInfos = new ErrorInfo[0];
    private volatile boolean _exitThread;
    private ParsingFinishedListener _parsingFinishedListener;
    private int _lastParserRunOffset;
    private int _lastErrEnd = -1;
    private int _nextStatBegin = -1;
    private String _workingString;
    private IncrementalBuffer _workingBuffer;
    private boolean _errorDetected;
    private boolean _couldNotDetectPosErrorLogged;

    public ParserThread(SQLSchema schema) {
        super(PARSER_THREAD_NM);
        this._schema = schema;
        ErrorListener errListener = new ErrorListener(){

            @Override
            public void errorDetected(String message, int line, int column) {
                ParserThread.this.onErrorDetected(message, line, column);
            }
        };
        this._errors = new Errors(errListener);
        this.setPriority(1);
        this.start();
    }

    private void onErrorDetected(String message, int line, int column) {
        this._errorDetected = true;
        int errPos = this.getPos(line, column);
        this._lastErrEnd = this.getTokenEnd(errPos);
        this._nextStatBegin = this.predictNextStatementBegin(errPos);
        if (this._lastErrEnd > this._nextStatBegin) {
            return;
        }
        int beginPos = this._lastParserRunOffset + errPos;
        int endPos = this._lastParserRunOffset + this._lastErrEnd;
        if (beginPos < endPos) {
            this._workingErrorInfos.add(new ErrorInfo(message, this._lastParserRunOffset + errPos, this._lastParserRunOffset + this._lastErrEnd - 1));
        }
    }

    private int predictNextStatementBegin(int errPos) {
        int ret;
        int[][] commentIntervals = this.calculateCommentIntervals();
        for (ret = errPos; this._workingString.length() > ret && (!this.startsWithBeginKeyWord(ret) || this.isInComment(ret, commentIntervals)); ++ret) {
        }
        return ret;
    }

    private int[][] calculateCommentIntervals() {
        Vector<int[]> ret = new Vector<int[]>();
        boolean inMultiLineComment = false;
        boolean inLineComment = false;
        boolean isaSlash = false;
        boolean isaStar = false;
        boolean isaMinus = false;
        int[] curComment = null;
        for (int i = 0; i < this._workingString.length(); ++i) {
            if ('*' == this._workingString.charAt(i) && isaSlash && !inMultiLineComment && !inLineComment) {
                inMultiLineComment = true;
                curComment = new int[]{i - 1, -1};
            } else if ('/' == this._workingString.charAt(i) && isaStar && !inLineComment && inMultiLineComment) {
                inMultiLineComment = false;
                curComment[1] = i;
                ret.add(curComment);
                curComment = null;
            } else if ('-' == this._workingString.charAt(i) && isaMinus && !inMultiLineComment && !inLineComment) {
                inLineComment = true;
                curComment = new int[]{i - 1, -1};
            } else if ('\n' == this._workingString.charAt(i) && !inMultiLineComment && inLineComment) {
                inLineComment = false;
                curComment[1] = i;
                ret.add(curComment);
                curComment = null;
            }
            if ('/' == this._workingString.charAt(i)) {
                isaSlash = true;
                continue;
            }
            if ('*' == this._workingString.charAt(i)) {
                isaStar = true;
                continue;
            }
            if ('-' == this._workingString.charAt(i)) {
                isaMinus = true;
                continue;
            }
            isaSlash = false;
            isaStar = false;
            isaMinus = false;
        }
        if (null != curComment) {
            curComment[1] = this._workingString.length();
        }
        return (int[][])ret.toArray((T[])new int[ret.size()][]);
    }

    private boolean isInComment(int ret, int[][] commentIntervals) {
        for (int i = 0; i < commentIntervals.length; ++i) {
            if (commentIntervals[i][0] > ret || ret > commentIntervals[i][1]) continue;
            return true;
        }
        return false;
    }

    private boolean startsWithBeginKeyWord(int ret) {
        return this.startsWithIgnoreCase(ret, "SELECT") || this.startsWithIgnoreCase(ret, "UPDATE") || this.startsWithIgnoreCase(ret, "DELETE") || this.startsWithIgnoreCase(ret, "INSERT") || this.startsWithIgnoreCase(ret, "ALTER") || this.startsWithIgnoreCase(ret, "CREATE") || this.startsWithIgnoreCase(ret, "DROP");
    }

    private boolean startsWithIgnoreCase(int ret, String keyWord) {
        int endPos;
        int beginPos = ret;
        if (ret == 0) {
            beginPos = 0;
        } else if (Character.isWhitespace(this._workingString.charAt(ret - 1))) {
            beginPos = ret;
        } else {
            return false;
        }
        if (this._workingString.length() == beginPos + keyWord.length()) {
            endPos = beginPos + keyWord.length();
        } else if (this._workingString.length() > beginPos + keyWord.length() && Character.isWhitespace(this._workingString.charAt(beginPos + keyWord.length()))) {
            endPos = beginPos + keyWord.length();
        } else {
            return false;
        }
        return keyWord.equalsIgnoreCase(this._workingString.substring(beginPos, endPos));
    }

    private int getTokenEnd(int errPos) {
        int ret;
        for (ret = errPos; this._workingString.length() > ret && !Character.isWhitespace(this._workingString.charAt(ret)); ++ret) {
        }
        return ret;
    }

    private int getPos(int line, int column) {
        int ix = 0;
        for (int i = 0; i < line - 1; ++i) {
            if (Integer.MAX_VALUE != (ix = this.getNextLineStartIx(ix))) continue;
            if (!this._couldNotDetectPosErrorLogged) {
                this._couldNotDetectPosErrorLogged = true;
                String message = "Could not find position for line = " + line + ", column = " + column;
                s_log.error(message, new IllegalStateException(message));
            }
            return this._workingString.length();
        }
        return (ix += column) - 1;
    }

    private int getNextLineStartIx(int begIx) {
        int candidate1 = Integer.MAX_VALUE;
        int buf = this._workingString.indexOf(10, begIx);
        if (0 <= buf) {
            candidate1 = buf + 1;
        }
        int candidate2 = Integer.MAX_VALUE;
        buf = this._workingString.indexOf(13, begIx);
        if (0 <= buf) {
            candidate2 = buf + 1 < this._workingString.length() && '\n' == this._workingString.charAt(buf + 1) ? buf + 2 : buf + 1;
        }
        int ret = Math.min(candidate1, candidate2);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyParser(String sqlText) {
        ParserThread parserThread = this;
        synchronized (parserThread) {
            this._pendingString = sqlText;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitThread() {
        this._exitThread = true;
        ParserThread parserThread = this;
        synchronized (parserThread) {
            this.notify();
        }
    }

    public void setParsingFinishedListener(ParsingFinishedListener parsingFinishedListener) {
        this._parsingFinishedListener = parsingFinishedListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            do {
                ParserThread parserThread = this;
                synchronized (parserThread) {
                    this.wait();
                    this._workingString = this._pendingString;
                    this._workingBuffer = new IncrementalBuffer(new StringCharacterIterator(this._workingString));
                }
                if (this._exitThread) return;
                this._errorDetected = false;
                this.runParser();
                while (this._errorDetected && this._workingString.length() > this._nextStatBegin) {
                    this._workingString = this._workingString.substring(this._nextStatBegin, this._workingString.length());
                    if ("".equals(this._workingString.trim())) break;
                    this._lastParserRunOffset += this._nextStatBegin;
                    this._workingBuffer = new IncrementalBuffer(new StringCharacterIterator(this._workingString));
                    this._errorDetected = false;
                    this.runParser();
                }
                this._lastRunTableAliasInfos = this._workingTableAliasInfos.toArray(new TableAliasInfo[this._workingTableAliasInfos.size()]);
                this._lastRunErrorInfos = this._workingErrorInfos.toArray(new ErrorInfo[this._workingErrorInfos.size()]);
                this._workingTableAliasInfos.clear();
                this._workingErrorInfos.clear();
                this._lastParserRunOffset = 0;
                if (null == this._parsingFinishedListener) continue;
                this._parsingFinishedListener.parsingFinished();
            } while (!this._exitThread);
            return;
        }
        catch (ExitParserThreadRequestException eptre) {
            return;
        }
        catch (Exception e) {
            if (null != this._parsingFinishedListener) {
                this._parsingFinishedListener.parserExitedOnException(e);
            }
            e.printStackTrace();
        }
    }

    private void runParser() {
        this._errors.reset();
        Scanner scanner = new Scanner(this._workingBuffer, this._errors);
        Parser parser = new Parser(scanner, this._schema);
        parser.addParserListener(new ParserListener(){

            @Override
            public void statementAdded(SQLStatement statement) {
                ParserThread.this.onStatementAdded(statement);
            }
        });
        parser.addSQLSelectStatementListener(new SQLSelectStatementListener(){

            @Override
            public void aliasDefined(String tableName, String aliasName) {
                ParserThread.this.onAliasDefined(tableName, aliasName);
            }
        });
        parser.parse();
    }

    private void onStatementAdded(SQLStatement statement) {
        this._curSQLSelectStat = statement;
    }

    private void onAliasDefined(String tableName, String aliasName) {
        this._workingTableAliasInfos.add(new TableAliasInfo(aliasName, tableName, this._curSQLSelectStat.getStart() + this._lastParserRunOffset));
    }

    public TableAliasInfo[] getTableAliasInfos() {
        return this._lastRunTableAliasInfos;
    }

    public ErrorInfo[] getErrorInfos() {
        return this._lastRunErrorInfos;
    }

    public void end() {
        IncrementalBuffer oldBuffer = this._workingBuffer;
        this._workingBuffer = null;
        oldBuffer.eof();
    }

    public void accept(CharacterIterator chars) {
        this._workingBuffer.waitChars();
        this._workingBuffer.accept(chars);
    }

    private static class Errors
    extends ErrorStream {
        private int[][] errorStore;
        private int count;
        private ErrorListener listener;

        public Errors(ErrorListener listener) {
            this.listener = listener;
            this.errorStore = new int[5][3];
        }

        @Override
        protected void ParsErr(int n, int line, int col) {
            this.errorStore[this.count][0] = n;
            this.errorStore[this.count][1] = line;
            this.errorStore[this.count][2] = col;
            this.count = (this.count + 1) % 5;
            if (this.listener != null) {
                super.ParsErr(n, line, col);
            }
        }

        @Override
        protected void SemErr(int n, int line, int col) {
            this.errorStore[this.count][0] = n;
            this.errorStore[this.count][1] = line;
            this.errorStore[this.count][2] = col;
            this.count = (this.count + 1) % 5;
            if (this.listener != null) {
                switch (n) {
                    case 10: {
                        this.StoreError(n, line, col, s_stringMgr.getString("parserthread.undefinedTable"));
                        break;
                    }
                    default: {
                        super.SemErr(n, line, col);
                    }
                }
            }
        }

        @Override
        protected void StoreError(int n, int line, int col, String s) {
            if (this.listener != null) {
                this.listener.errorDetected(s, line, col);
            }
        }

        public void reset() {
            this.errorStore = new int[5][3];
        }
    }

    private class IncrementalBuffer
    extends Scanner.Buffer {
        private CharacterIterator chars;
        private char current;
        private boolean atEnd = false;

        IncrementalBuffer(CharacterIterator chars) {
            this.chars = chars;
            this.current = (char)(chars != null ? (int)chars.first() : 65535);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected synchronized char read() {
            if (ParserThread.this._exitThread) {
                throw new ExitParserThreadRequestException();
            }
            if (this.atEnd) {
                return '\uffff';
            }
            if (this.current == '\uffff' && this.chars != null) {
                CharacterIterator characterIterator = this.chars;
                synchronized (characterIterator) {
                    this.chars.notify();
                }
            }
            if (this.atEnd) {
                if (ParserThread.this._exitThread) {
                    throw new ExitParserThreadRequestException();
                }
                this.current = (char)65535;
                return '\uffff';
            }
            char prev = this.current;
            if (ParserThread.this._exitThread) {
                throw new ExitParserThreadRequestException();
            }
            this.current = this.chars.next();
            return prev;
        }

        synchronized void eof() {
            this.atEnd = true;
            this.notify();
        }

        synchronized void accept(CharacterIterator chars) {
            this.chars = chars;
            this.current = (char)(chars != null ? (int)chars.first() : 65535);
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitChars() {
            if (this.chars != null && this.current != '\uffff') {
                CharacterIterator characterIterator = this.chars;
                synchronized (characterIterator) {
                    try {
                        this.chars.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        int getBeginIndex() {
            return this.chars != null ? this.chars.getBeginIndex() : 0;
        }

        @Override
        protected void setIndex(int position) {
            this.current = this.chars.setIndex(position);
        }
    }
}

